/*
 * Decompiled with CFR 0.152.
 */
package net.diversionmc.parser.expression;

import net.diversionmc.parser.expression.ExpressionPiece;
import net.diversionmc.parser.expression.PieceResult;
import net.diversionmc.parser.util.FilePointer;

public class CommentPiece
extends ExpressionPiece {
    private final boolean inline;
    private final ExpressionPiece original;
    private char last;

    public CommentPiece(FilePointer ptr, boolean inline, ExpressionPiece original) {
        super(ptr);
        this.inline = inline;
        this.original = original;
    }

    @Override
    public PieceResult read(char c, FilePointer ptr) {
        if (this.inline) {
            return c == '\n' ? PieceResult.REPLACE_LEAVE : PieceResult.CONTINUE;
        }
        if (this.last == '*' && c == '/') {
            return PieceResult.REPLACE_TAKE;
        }
        this.last = c;
        return PieceResult.CONTINUE;
    }

    @Override
    public ExpressionPiece replace(FilePointer ptr) {
        return this.original;
    }
}

