/*
 * Decompiled with CFR 0.152.
 */
package net.digger.db;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Map;

public class H2Helper {
    private static final String VERSION_TABLE_NAME = "table_version";
    private static final int VERSION_TABLE_VERSION = 1;
    private static final String DEFAULT_USER = "sa";
    private static final String DEFAULT_PASSWORD = "";
    private final String connUrl;
    private String user = "sa";
    private String password = "";

    public H2Helper(String connUrl) throws ClassNotFoundException, SQLException {
        Class.forName("org.h2.Driver");
        this.connUrl = connUrl;
        this.initVersionTable();
    }

    public H2Helper(Path datafile) throws IOException, ClassNotFoundException, SQLException {
        this(datafile, null, null, null);
    }

    public H2Helper(Path datafile, Map<String, String> options) throws IOException, ClassNotFoundException, SQLException {
        this(datafile, options, null, null);
    }

    public H2Helper(Path datafile, Map<String, String> options, String user, String password) throws IOException, ClassNotFoundException, SQLException {
        Class.forName("org.h2.Driver");
        Files.createDirectories(datafile.getParent(), new FileAttribute[0]);
        StringBuilder sb = new StringBuilder();
        sb.append("jdbc:h2:").append(datafile.toString());
        if (options != null) {
            for (String key : options.keySet()) {
                sb.append(";").append(key).append("=").append(options.get(key));
            }
        }
        this.connUrl = sb.toString();
        this.setCredentials(user, password);
        this.initVersionTable();
    }

    public void setCredentials(String user, String password) {
        if (user == null) {
            this.user = DEFAULT_USER;
            this.password = DEFAULT_PASSWORD;
        } else {
            this.user = user;
            this.password = password;
        }
    }

    public String getConnUrl() {
        return this.connUrl;
    }

    public Connection connect() throws SQLException {
        return this.connect(this.user, this.password);
    }

    public Connection connect(String user, String password) throws SQLException {
        return DriverManager.getConnection(this.connUrl, user, password);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Integer getTableVersion(String name) throws SQLException {
        Connection conn = null;
        ResultSet result = null;
        conn = this.connect();
        result = conn.getMetaData().getTables(conn.getCatalog(), null, VERSION_TABLE_NAME.toUpperCase(), null);
        if (!result.next()) {
            Integer n = null;
            return n;
        }
        result.close();
        result = conn.getMetaData().getTables(conn.getCatalog(), null, name.toUpperCase(), null);
        if (!result.next()) {
            Integer n = null;
            return n;
        }
        result.close();
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT version from ").append(VERSION_TABLE_NAME);
        sql.append(" WHERE name = ?");
        Integer n = this.doQuery(conn, sql.toString(), ps -> ps.setString(1, name), rs -> {
            if (rs.next()) {
                return rs.getInt(1);
            }
            return null;
        });
        return n;
        finally {
            try {
                if (result != null) {
                    result.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException sQLException) {}
        }
    }

    private void updateTableVersion(Connection conn, String name, int version) throws SQLException {
        StringBuilder sql = new StringBuilder();
        sql.append("MERGE INTO ").append(VERSION_TABLE_NAME);
        sql.append(" (name, version)");
        sql.append(" KEY (name)");
        sql.append(" VALUES (?, ?)");
        this.doUpdate(conn, sql.toString(), (PreparedStatement ps) -> {
            ps.setString(1, name);
            ps.setInt(2, version);
        });
    }

    private void initVersionTable() throws SQLException {
        this.initTable(VERSION_TABLE_NAME, 1, (conn, current) -> {
            StringBuilder sql = new StringBuilder();
            if (current == null) {
                sql.setLength(0);
                sql.append("CREATE TABLE ").append(VERSION_TABLE_NAME).append(" (");
                sql.append(" name VARCHAR_IGNORECASE(255) NOT NULL PRIMARY KEY,");
                sql.append(" version INTEGER NOT NULL");
                sql.append(")");
                this.doUpdate(conn, sql.toString(), null);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initTable(String name, int version, UpgradeCallback upgrade) throws SQLException {
        Integer current = this.getTableVersion(name);
        if (current != null) {
            if (current == version) {
                return;
            }
            if (current > version) {
                throw new SQLException("Required version (" + version + ") for table " + name + " is older than current version (" + current + ").");
            }
        }
        try (Connection conn = null;){
            conn = this.connect();
            conn.setAutoCommit(false);
            upgrade.upgrade(conn, current);
            this.updateTableVersion(conn, name, version);
            conn.commit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T doQuery(String sql, PrepareCallback pc, ResultCallback<T> rc) throws SQLException {
        try (Connection conn = null;){
            conn = this.connect();
            T t = this.doQuery(conn, sql, pc, rc);
            return t;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T doQuery(Connection conn, String sql, PrepareCallback pc, ResultCallback<T> rc) throws SQLException {
        Statement ps = null;
        ResultSet rs = null;
        try {
            Connection connection = conn;
            synchronized (connection) {
                conn.setAutoCommit(true);
                ps = conn.prepareStatement(sql);
                if (pc != null) {
                    pc.prepare((PreparedStatement)ps);
                }
                rs = ps.executeQuery();
                T t = rc.process(rs);
                return t;
            }
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            if (ps != null) {
                ps.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int doUpdate(String sql, PrepareCallback pc) throws SQLException {
        try (Connection conn = null;){
            conn = this.connect();
            int n = this.doUpdate(conn, sql, pc);
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int doUpdate(Connection conn, String sql, PrepareCallback pc) throws SQLException {
        try (Statement ps = null;){
            Connection connection = conn;
            synchronized (connection) {
                conn.setAutoCommit(true);
                ps = conn.prepareStatement(sql);
                if (pc != null) {
                    pc.prepare((PreparedStatement)ps);
                }
                int n = ps.executeUpdate();
                return n;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T doUpdate(String sql, PrepareCallback pc, GeneratedKeysCallback<T> gkc) throws SQLException {
        try (Connection conn = null;){
            conn = this.connect();
            T t = this.doUpdate(conn, sql, pc, gkc);
            return t;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <T> T doUpdate(Connection conn, String sql, PrepareCallback pc, GeneratedKeysCallback<T> gkc) throws SQLException {
        PreparedStatement ps = null;
        ResultSet rs = null;
        Connection connection = conn;
        synchronized (connection) {
            try {
                conn.setAutoCommit(false);
                ps = conn.prepareStatement(sql, 1);
                if (pc != null) {
                    pc.prepare(ps);
                }
                int count = ps.executeUpdate();
                rs = ps.getGeneratedKeys();
                T result = gkc.process(count, rs);
                conn.commit();
                T t = result;
                return t;
            }
            catch (SQLException e) {
                try {
                    conn.rollback();
                    throw e;
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                throw e;
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
                if (ps != null) {
                    ps.close();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] doBatchUpdate(String sql, PrepareCallback pc) throws SQLException {
        try (Connection conn = null;){
            conn = this.connect();
            int[] nArray = this.doBatchUpdate(conn, sql, pc);
            return nArray;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int[] doBatchUpdate(Connection conn, String sql, PrepareCallback pc) throws SQLException {
        Statement ps = null;
        Connection connection = conn;
        synchronized (connection) {
            try {
                conn.setAutoCommit(false);
                ps = conn.prepareStatement(sql);
                if (pc != null) {
                    pc.prepare((PreparedStatement)ps);
                }
                int[] result = ps.executeBatch();
                conn.commit();
                int[] nArray = result;
                return nArray;
            }
            catch (SQLException e) {
                try {
                    conn.rollback();
                    throw e;
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                throw e;
            }
            finally {
                if (ps != null) {
                    ps.close();
                }
            }
        }
    }

    public static interface GeneratedKeysCallback<T> {
        public T process(int var1, ResultSet var2) throws SQLException;
    }

    public static interface ResultCallback<T> {
        public T process(ResultSet var1) throws SQLException;
    }

    public static interface PrepareCallback {
        public void prepare(PreparedStatement var1) throws SQLException;
    }

    public static interface UpgradeCallback {
        public void upgrade(Connection var1, Integer var2) throws SQLException;
    }
}

