/*
 * Decompiled with CFR 0.152.
 */
package net.devslash;

import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\n\u001a\u00020\u000bJ\u0006\u0010\f\u001a\u00020\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lnet/devslash/TimedTicket;", "", "millSteps", "", "clock", "Ljava/time/Clock;", "(JLjava/time/Clock;)V", "lastRelease", "Ljava/time/Instant;", "kotlin.jvm.PlatformType", "setLastRelease", "", "timeTillNextRelease", "service"})
public final class TimedTicket {
    private final long millSteps;
    @NotNull
    private final Clock clock;
    private Instant lastRelease;

    public TimedTicket(long millSteps, @NotNull Clock clock) {
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        this.millSteps = millSteps;
        this.clock = clock;
        this.lastRelease = Instant.ofEpochMilli(0L);
    }

    public final long timeTillNextRelease() {
        Instant now = this.clock.instant();
        long timeSinceLastRelease = Duration.between(this.lastRelease, now).toMillis();
        return RangesKt.coerceAtLeast((long)(this.millSteps - timeSinceLastRelease), (long)0L);
    }

    public final void setLastRelease() {
        this.lastRelease = this.clock.instant();
    }
}

