/*
 * Decompiled with CFR 0.152.
 */
package net.devslash;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.ktor.client.request.HttpRequestBuilder;
import io.ktor.client.request.HttpRequestKt;
import io.ktor.client.request.forms.FormBuilder;
import io.ktor.client.request.forms.FormDataContent;
import io.ktor.client.request.forms.FormDslKt;
import io.ktor.client.request.forms.MultiPartFormDataContent;
import io.ktor.http.ContentType;
import io.ktor.http.HeadersBuilder;
import io.ktor.http.Parameters;
import io.ktor.http.ParametersKt;
import io.ktor.http.URLBuilder;
import io.ktor.http.URLParserKt;
import io.ktor.http.content.ByteArrayContent;
import io.ktor.http.content.TextContent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import net.devslash.Body;
import net.devslash.ByteArrayType;
import net.devslash.BytesRequestBody;
import net.devslash.EmptyBody;
import net.devslash.FormPart;
import net.devslash.FormRequestBody;
import net.devslash.FormTypes;
import net.devslash.HttpMethod;
import net.devslash.HttpRequest;
import net.devslash.JsonRequestBody;
import net.devslash.MultipartFormRequestBody;
import net.devslash.NumberType;
import net.devslash.StringRequestBody;
import net.devslash.StringType;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lnet/devslash/KtorRequestMapper;", "", "()V", "mapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "mapHttpToKtor", "Lio/ktor/client/request/HttpRequestBuilder;", "httpRequest", "Lnet/devslash/HttpRequest;", "mapType", "Lio/ktor/http/HttpMethod;", "type", "Lnet/devslash/HttpMethod;", "service"})
@SourceDebugExtension(value={"SMAP\nKtorRequestMapper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KtorRequestMapper.kt\nnet/devslash/KtorRequestMapper\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,72:1\n125#2:73\n152#2,3:74\n37#3,2:77\n*S KotlinDebug\n*F\n+ 1 KtorRequestMapper.kt\nnet/devslash/KtorRequestMapper\n*L\n35#1:73\n35#1:74,3\n35#1:77,2\n*E\n"})
public final class KtorRequestMapper {
    @NotNull
    public static final KtorRequestMapper INSTANCE = new KtorRequestMapper();
    @NotNull
    private static final ObjectMapper mapper = new ObjectMapper();

    private KtorRequestMapper() {
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final HttpRequestBuilder mapHttpToKtor(@NotNull HttpRequest httpRequest) {
        HttpRequestBuilder httpRequestBuilder;
        Intrinsics.checkNotNullParameter((Object)httpRequest, (String)"httpRequest");
        HttpRequestBuilder $this$mapHttpToKtor_u24lambda_u241 = httpRequestBuilder = new HttpRequestBuilder();
        boolean bl = false;
        URLParserKt.takeFrom((URLBuilder)$this$mapHttpToKtor_u24lambda_u241.getUrl(), (String)httpRequest.getUrl());
        $this$mapHttpToKtor_u24lambda_u241.setMethod(INSTANCE.mapType(httpRequest.getType()));
        HttpRequestKt.headers((HttpRequestBuilder)$this$mapHttpToKtor_u24lambda_u241, (Function1)((Function1)new Function1<HeadersBuilder, Unit>(httpRequest){
            final /* synthetic */ HttpRequest $httpRequest;
            {
                this.$httpRequest = $httpRequest;
                super(1);
            }

            public final void invoke(@NotNull HeadersBuilder $this$headers) {
                Intrinsics.checkNotNullParameter((Object)$this$headers, (String)"$this$headers");
                Map $this$forEach$iv = this.$httpRequest.getHeaders();
                boolean $i$f$forEach = false;
                Iterator<Map.Entry<K, V>> iterator = $this$forEach$iv.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry<K, V> element$iv;
                    Map.Entry<K, V> it = element$iv = iterator.next();
                    boolean bl = false;
                    Iterable $this$forEach$iv2 = (Iterable)it.getValue();
                    boolean $i$f$forEach2 = false;
                    for (T element$iv2 : $this$forEach$iv2) {
                        String kVal = (String)element$iv2;
                        boolean bl2 = false;
                        $this$headers.append((String)it.getKey(), kVal);
                    }
                }
            }
        }));
        Body reqBody = httpRequest.getBody();
        if (!Intrinsics.areEqual((Object)reqBody, (Object)EmptyBody.INSTANCE)) {
            if (reqBody instanceof BytesRequestBody) {
                byte[] byArray = ((BytesRequestBody)reqBody).getBody().readAllBytes();
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"readAllBytes(...)");
                $this$mapHttpToKtor_u24lambda_u241.setBody((Object)new ByteArrayContent(byArray, null, null, 6, null));
            } else if (reqBody instanceof StringRequestBody) {
                byte[] byArray = ((StringRequestBody)reqBody).getBody().getBytes(Charsets.UTF_8);
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
                $this$mapHttpToKtor_u24lambda_u241.setBody((Object)new ByteArrayContent(byArray, null, null, 6, null));
            } else if (reqBody instanceof FormRequestBody) {
                void $this$toTypedArray$iv;
                void $this$mapTo$iv$iv;
                Collection $this$map$iv;
                Map map = ((FormRequestBody)reqBody).getForm();
                HttpRequestBuilder httpRequestBuilder2 = $this$mapHttpToKtor_u24lambda_u241;
                boolean $i$f$map = false;
                void var10_9 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList($this$map$iv.size());
                boolean $i$f$mapTo = false;
                Iterator iterator = $this$mapTo$iv$iv.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry item$iv$iv;
                    Map.Entry entry = item$iv$iv = iterator.next();
                    Collection collection = destination$iv$iv;
                    boolean bl2 = false;
                    String key = (String)entry.getKey();
                    List value = (List)entry.getValue();
                    collection.add(TuplesKt.to((Object)key, (Object)value));
                }
                $this$map$iv = (List)destination$iv$iv;
                boolean $i$f$toTypedArray = false;
                void thisCollection$iv = $this$toTypedArray$iv;
                Pair[] pairArray = thisCollection$iv.toArray(new Pair[0]);
                Parameters parameters = ParametersKt.parametersOf((Pair[])Arrays.copyOf(pairArray, pairArray.length));
                httpRequestBuilder2.setBody((Object)new FormDataContent(parameters));
            } else if (reqBody instanceof JsonRequestBody) {
                String string = mapper.writeValueAsString(((JsonRequestBody)reqBody).getData());
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"writeValueAsString(...)");
                $this$mapHttpToKtor_u24lambda_u241.setBody((Object)new TextContent(string, ContentType.Application.INSTANCE.getJson(), null, 4, null));
            } else if (reqBody instanceof MultipartFormRequestBody) {
                $this$mapHttpToKtor_u24lambda_u241.setBody((Object)new MultiPartFormDataContent(FormDslKt.formData((Function1)((Function1)new Function1<FormBuilder, Unit>(reqBody){
                    final /* synthetic */ Body $reqBody;
                    {
                        this.$reqBody = $reqBody;
                        super(1);
                    }

                    public final void invoke(@NotNull FormBuilder $this$formData) {
                        Intrinsics.checkNotNullParameter((Object)$this$formData, (String)"$this$formData");
                        Iterable $this$forEach$iv = ((MultipartFormRequestBody)this.$reqBody).getForm();
                        boolean $i$f$forEach = false;
                        for (T element$iv : $this$forEach$iv) {
                            FormPart it = (FormPart)element$iv;
                            boolean bl = false;
                            FormTypes value = it.getValue();
                            if (value instanceof NumberType) {
                                FormBuilder.append$default((FormBuilder)$this$formData, (String)it.getKey(), (Number)((NumberType)value).getI(), null, (int)4, null);
                                continue;
                            }
                            if (value instanceof StringType) {
                                FormBuilder.append$default((FormBuilder)$this$formData, (String)it.getKey(), (String)((StringType)value).getI(), null, (int)4, null);
                                continue;
                            }
                            if (!(value instanceof ByteArrayType)) continue;
                            FormBuilder.append$default((FormBuilder)$this$formData, (String)it.getKey(), (byte[])((ByteArrayType)value).getI(), null, (int)4, null);
                        }
                    }
                }))));
            }
        }
        return httpRequestBuilder;
    }

    private final io.ktor.http.HttpMethod mapType(HttpMethod type) {
        io.ktor.http.HttpMethod httpMethod;
        switch (WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
            case 1: {
                httpMethod = io.ktor.http.HttpMethod.Companion.getGet();
                break;
            }
            case 2: {
                httpMethod = io.ktor.http.HttpMethod.Companion.getPost();
                break;
            }
            case 3: {
                httpMethod = io.ktor.http.HttpMethod.Companion.getDelete();
                break;
            }
            case 4: {
                httpMethod = io.ktor.http.HttpMethod.Companion.getPut();
                break;
            }
            case 5: {
                httpMethod = io.ktor.http.HttpMethod.Companion.getPatch();
                break;
            }
            case 6: {
                httpMethod = io.ktor.http.HttpMethod.Companion.getHead();
                break;
            }
            case 7: {
                httpMethod = io.ktor.http.HttpMethod.Companion.getOptions();
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return httpMethod;
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[HttpMethod.values().length];
            try {
                nArray[HttpMethod.GET.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[HttpMethod.POST.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[HttpMethod.DELETE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[HttpMethod.PUT.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[HttpMethod.PATCH.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[HttpMethod.HEAD.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[HttpMethod.OPTIONS.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

