/*
 * Decompiled with CFR 0.152.
 */
package net.devslash.pipes;

import java.util.List;
import java.util.concurrent.ConcurrentLinkedDeque;
import kotlin.Metadata;
import kotlin.coroutines.Continuation;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import net.devslash.HttpRequest;
import net.devslash.HttpResponse;
import net.devslash.RequestData;
import net.devslash.RequestDataSupplier;
import net.devslash.ResolvedFullDataAfterHook;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B+\u0012$\u0010\u0004\u001a \u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00028\u0000\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\b0\u00070\u0005\u00a2\u0006\u0002\u0010\tJ%\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0014J\u0019\u0010\u0015\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\bH\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0016R/\u0010\u0004\u001a \u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00028\u0000\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\b0\u00070\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\b0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u0017"}, d2={"Lnet/devslash/pipes/Pipe;", "T", "Lnet/devslash/ResolvedFullDataAfterHook;", "Lnet/devslash/RequestDataSupplier;", "acceptor", "Lkotlin/Function2;", "Lnet/devslash/HttpResponse;", "", "Lnet/devslash/RequestData;", "(Lkotlin/jvm/functions/Function2;)V", "getAcceptor", "()Lkotlin/jvm/functions/Function2;", "storage", "Ljava/util/concurrent/ConcurrentLinkedDeque;", "accept", "", "req", "Lnet/devslash/HttpRequest;", "resp", "data", "(Lnet/devslash/HttpRequest;Lnet/devslash/HttpResponse;Ljava/lang/Object;)V", "getDataForRequest", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "service"})
public final class Pipe<T>
implements ResolvedFullDataAfterHook<T>,
RequestDataSupplier<T> {
    @NotNull
    private final Function2<HttpResponse, T, List<RequestData<T>>> acceptor;
    @NotNull
    private final ConcurrentLinkedDeque<RequestData<T>> storage;

    public Pipe(@NotNull Function2<? super HttpResponse, ? super T, ? extends List<? extends RequestData<T>>> acceptor) {
        Intrinsics.checkNotNullParameter(acceptor, (String)"acceptor");
        this.acceptor = acceptor;
        this.storage = new ConcurrentLinkedDeque();
    }

    @NotNull
    public final Function2<HttpResponse, T, List<RequestData<T>>> getAcceptor() {
        return this.acceptor;
    }

    @Nullable
    public Object getDataForRequest(@NotNull Continuation<? super RequestData<T>> $completion) {
        RequestData<T> requestData = this.storage.poll();
        if (requestData == null) {
            return null;
        }
        return requestData;
    }

    public void accept(@NotNull HttpRequest req, @NotNull HttpResponse resp, T data) {
        Intrinsics.checkNotNullParameter((Object)req, (String)"req");
        Intrinsics.checkNotNullParameter((Object)resp, (String)"resp");
        List newResults = (List)this.acceptor.invoke((Object)resp, data);
        this.storage.addAll(newResults);
    }

    public void init() {
        RequestDataSupplier.DefaultImpls.init((RequestDataSupplier)this);
    }
}

