/*
 * Decompiled with CFR 0.152.
 */
package net.devslash;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.ktor.client.request.HttpRequestBuilder;
import io.ktor.client.request.HttpRequestKt;
import io.ktor.client.request.forms.FormBuilder;
import io.ktor.client.request.forms.FormDataContent;
import io.ktor.client.request.forms.FormDslKt;
import io.ktor.client.request.forms.MultiPartFormDataContent;
import io.ktor.http.ContentType;
import io.ktor.http.HeadersBuilder;
import io.ktor.http.Parameters;
import io.ktor.http.ParametersBuilder;
import io.ktor.http.URLBuilder;
import io.ktor.http.URLParserKt;
import io.ktor.http.content.ByteArrayContent;
import io.ktor.http.content.TextContent;
import java.nio.charset.Charset;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import net.devslash.BasicBodyProvider;
import net.devslash.BodyProvider;
import net.devslash.ByteArrayType;
import net.devslash.EmptyBodyProvider;
import net.devslash.FormBody;
import net.devslash.FormPart;
import net.devslash.FormTypes;
import net.devslash.HttpMethod;
import net.devslash.HttpRequest;
import net.devslash.JsonBody;
import net.devslash.MultipartForm;
import net.devslash.NumberType;
import net.devslash.RawBody;
import net.devslash.StringType;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lnet/devslash/KtorRequestMapper;", "", "()V", "mapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "mapHttpToKtor", "Lio/ktor/client/request/HttpRequestBuilder;", "httpRequest", "Lnet/devslash/HttpRequest;", "mapType", "Lio/ktor/http/HttpMethod;", "type", "Lnet/devslash/HttpMethod;", "service"})
public final class KtorRequestMapper {
    @NotNull
    public static final KtorRequestMapper INSTANCE = new KtorRequestMapper();
    @NotNull
    private static final ObjectMapper mapper = new ObjectMapper();

    private KtorRequestMapper() {
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final HttpRequestBuilder mapHttpToKtor(@NotNull HttpRequest httpRequest) {
        Intrinsics.checkNotNullParameter((Object)httpRequest, (String)"httpRequest");
        HttpRequestBuilder httpRequestBuilder = new HttpRequestBuilder();
        boolean bl = false;
        boolean bl2 = false;
        HttpRequestBuilder $this$mapHttpToKtor_u24lambda_u2d3 = httpRequestBuilder;
        boolean bl3 = false;
        URLParserKt.takeFrom((URLBuilder)$this$mapHttpToKtor_u24lambda_u2d3.getUrl(), (String)httpRequest.getUrl());
        $this$mapHttpToKtor_u24lambda_u2d3.setMethod(INSTANCE.mapType(httpRequest.getType()));
        HttpRequestKt.headers((HttpRequestBuilder)$this$mapHttpToKtor_u24lambda_u2d3, (Function1)((Function1)new Function1<HeadersBuilder, Unit>(httpRequest){
            final /* synthetic */ HttpRequest $httpRequest;
            {
                this.$httpRequest = $httpRequest;
                super(1);
            }

            public final void invoke(@NotNull HeadersBuilder $this$headers) {
                Intrinsics.checkNotNullParameter((Object)$this$headers, (String)"$this$headers");
                Map $this$forEach$iv = this.$httpRequest.getHeaders();
                boolean $i$f$forEach = false;
                Map map = $this$forEach$iv;
                boolean bl = false;
                Iterator<Map.Entry<K, V>> iterator = map.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry<K, V> element$iv;
                    Map.Entry<K, V> it = element$iv = iterator.next();
                    boolean bl2 = false;
                    Iterable $this$forEach$iv2 = (Iterable)it.getValue();
                    boolean $i$f$forEach2 = false;
                    for (T element$iv2 : $this$forEach$iv2) {
                        String kVal = (String)element$iv2;
                        boolean bl3 = false;
                        $this$headers.append((String)it.getKey(), kVal);
                    }
                }
            }
        }));
        BodyProvider bodyProvider = httpRequest.getBody();
        if (bodyProvider instanceof JsonBody) {
            String string = mapper.writeValueAsString(((JsonBody)httpRequest.getBody()).get());
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"mapper.writeValueAsString((httpRequest.body as JsonBody).get())");
            $this$mapHttpToKtor_u24lambda_u2d3.setBody((Object)new TextContent(string, ContentType.Application.INSTANCE.getJson(), null, 4, null));
        } else if (bodyProvider instanceof BasicBodyProvider) {
            String string = ((BasicBodyProvider)httpRequest.getBody()).get();
            Charset charset = Charsets.UTF_8;
            boolean bl4 = false;
            String string2 = string;
            if (string2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            byte[] byArray = string2.getBytes(charset);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
            $this$mapHttpToKtor_u24lambda_u2d3.setBody((Object)new ByteArrayContent(byArray, null, null, 6, null));
        } else if (bodyProvider instanceof FormBody) {
            Parameters.Companion this_$iv = Parameters.Companion;
            boolean $i$f$build = false;
            ParametersBuilder parametersBuilder = new ParametersBuilder(0, 1, null);
            boolean bl5 = false;
            boolean bl6 = false;
            ParametersBuilder parametersBuilder2 = parametersBuilder;
            HttpRequestBuilder httpRequestBuilder2 = $this$mapHttpToKtor_u24lambda_u2d3;
            boolean bl7 = false;
            FormBody prov = (FormBody)httpRequest.getBody();
            Map $this$forEach$iv = prov.get();
            boolean $i$f$forEach = false;
            Map map = $this$forEach$iv;
            boolean bl8 = false;
            Iterator iterator = map.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry element$iv;
                Map.Entry $dstr$key$value = element$iv = iterator.next();
                boolean bl9 = false;
                Map.Entry entry = $dstr$key$value;
                boolean bl10 = false;
                String key = (String)entry.getKey();
                Map.Entry entry2 = $dstr$key$value;
                boolean bl11 = false;
                List value = (List)entry2.getValue();
                Iterable $this$forEach$iv2 = value;
                boolean $i$f$forEach2 = false;
                for (Object element$iv2 : $this$forEach$iv2) {
                    void $this$mapHttpToKtor_u24lambda_u2d3_u24lambda_u2d2;
                    String it = (String)element$iv2;
                    boolean bl12 = false;
                    $this$mapHttpToKtor_u24lambda_u2d3_u24lambda_u2d2.append(key, it);
                }
            }
            Unit unit = Unit.INSTANCE;
            Parameters parameters = parametersBuilder.build();
            httpRequestBuilder2.setBody((Object)new FormDataContent(parameters));
        } else if (bodyProvider instanceof MultipartForm) {
            MultipartForm bd = (MultipartForm)httpRequest.getBody();
            $this$mapHttpToKtor_u24lambda_u2d3.setBody((Object)new MultiPartFormDataContent(FormDslKt.formData((Function1)((Function1)new Function1<FormBuilder, Unit>(bd){
                final /* synthetic */ MultipartForm $bd;
                {
                    this.$bd = $bd;
                    super(1);
                }

                public final void invoke(@NotNull FormBuilder $this$formData) {
                    Intrinsics.checkNotNullParameter((Object)$this$formData, (String)"$this$formData");
                    Iterable $this$forEach$iv = this.$bd.getParts();
                    boolean $i$f$forEach = false;
                    for (T element$iv : $this$forEach$iv) {
                        FormPart it = (FormPart)element$iv;
                        boolean bl = false;
                        FormTypes value = it.getValue();
                        if (value instanceof NumberType) {
                            FormBuilder.append$default((FormBuilder)$this$formData, (String)it.getKey(), (Number)((NumberType)value).getI(), null, (int)4, null);
                            continue;
                        }
                        if (value instanceof StringType) {
                            FormBuilder.append$default((FormBuilder)$this$formData, (String)it.getKey(), (String)((StringType)value).getI(), null, (int)4, null);
                            continue;
                        }
                        if (!(value instanceof ByteArrayType)) continue;
                        FormBuilder.append$default((FormBuilder)$this$formData, (String)it.getKey(), (byte[])((ByteArrayType)value).getI(), null, (int)4, null);
                    }
                }
            }))));
        } else if (bodyProvider instanceof RawBody) {
            RawBody rb = (RawBody)httpRequest.getBody();
            byte[] byArray = rb.getRaw().readAllBytes();
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"rb.raw.readAllBytes()");
            $this$mapHttpToKtor_u24lambda_u2d3.setBody((Object)new ByteArrayContent(byArray, null, null, 6, null));
        } else if (Intrinsics.areEqual((Object)bodyProvider, (Object)EmptyBodyProvider.INSTANCE)) {
            // empty if block
        }
        return httpRequestBuilder;
    }

    private final io.ktor.http.HttpMethod mapType(HttpMethod type) {
        io.ktor.http.HttpMethod httpMethod;
        HttpMethod httpMethod2 = type;
        int n = WhenMappings.$EnumSwitchMapping$0[httpMethod2.ordinal()];
        switch (n) {
            case 1: {
                httpMethod = io.ktor.http.HttpMethod.Companion.getGet();
                break;
            }
            case 2: {
                httpMethod = io.ktor.http.HttpMethod.Companion.getPost();
                break;
            }
            case 3: {
                httpMethod = io.ktor.http.HttpMethod.Companion.getDelete();
                break;
            }
            case 4: {
                httpMethod = io.ktor.http.HttpMethod.Companion.getPut();
                break;
            }
            case 5: {
                httpMethod = io.ktor.http.HttpMethod.Companion.getPatch();
                break;
            }
            case 6: {
                httpMethod = io.ktor.http.HttpMethod.Companion.getHead();
                break;
            }
            case 7: {
                httpMethod = io.ktor.http.HttpMethod.Companion.getOptions();
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return httpMethod;
    }

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[HttpMethod.values().length];
            nArray[HttpMethod.GET.ordinal()] = 1;
            nArray[HttpMethod.POST.ordinal()] = 2;
            nArray[HttpMethod.DELETE.ordinal()] = 3;
            nArray[HttpMethod.PUT.ordinal()] = 4;
            nArray[HttpMethod.PATCH.ordinal()] = 5;
            nArray[HttpMethod.HEAD.ordinal()] = 6;
            nArray[HttpMethod.OPTIONS.ordinal()] = 7;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

