/*
 * Decompiled with CFR 0.152.
 */
package net.deelam.graphtools.hadoop;

import com.tinkerpop.blueprints.Edge;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import net.deelam.graphtools.GraphRecord;
import net.deelam.graphtools.hadoop.GraphRecordEdgeWriteable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.io.WritableUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphRecordWriteable
extends GraphRecord
implements WritableComparable<GraphRecordWriteable> {
    private static final Logger log = LoggerFactory.getLogger(GraphRecordWriteable.class);
    private static final long serialVersionUID = 201511100951L;
    private static final int SUPERNODE_THRESHOLD = 100000;
    private static final short NULL_TYPE = 0;
    private static final short BOOL_TYPE = 1;
    private static final short FLOAT_TYPE = 2;
    private static final short INT_TYPE = 3;
    private static final short LONG_TYPE = 4;
    private static final short STRING_TYPE = 5;
    private static final short DOUBLE_TYPE = 6;
    private static final short DATE_TYPE = 20;
    private static final short VALUESET_TYPE = 100;

    public void write(DataOutput out) throws IOException {
        GraphRecordWriteable.writeElement(this.id, this.props, out);
        this.writeEdges(out, this.inEdges);
        this.writeEdges(out, this.outEdges);
    }

    public void readFields(DataInput in) throws IOException {
        this.id = GraphRecordWriteable.readElementFields(this.props, in);
        this.inEdges.clear();
        this.readEdges(in, this.inEdges);
        this.outEdges.clear();
        this.readEdges(in, this.outEdges);
    }

    private void writeEdges(DataOutput out, Map<String, Edge> edges) throws IOException {
        int size = edges.size();
        if (size > 100000) {
            log.warn("StringIdVertexWritable id={} has over {} edges!", this.getId(), (Object)size);
        }
        out.writeInt(size);
        for (Edge e : edges.values()) {
            GraphRecordEdgeWriteable writableE = (GraphRecordEdgeWriteable)e;
            writableE.write(out);
        }
    }

    private void readEdges(DataInput in, Map<String, Edge> edges) throws IOException {
        int edgeCount = in.readInt();
        for (int i = 0; i < edgeCount; ++i) {
            GraphRecordEdgeWriteable edge = new GraphRecordEdgeWriteable();
            edge.readFields(in);
            edges.put(edge.getStringId(), (Edge)edge);
        }
    }

    public int compareTo(GraphRecordWriteable o) {
        return this.id.compareTo((String)o.getId());
    }

    static void writeElement(String id, Map<String, Object> props, DataOutput out) throws IOException {
        out.writeUTF(id);
        out.writeInt(props.size());
        for (Map.Entry<String, Object> e : props.entrySet()) {
            out.writeUTF(e.getKey());
            GraphRecordWriteable.writePropertyValue(out, e.getKey(), e.getValue());
        }
    }

    static String readElementFields(Map<String, Object> props, DataInput in) throws IOException {
        String id = in.readUTF();
        int propCount = in.readInt();
        props.clear();
        for (int i = 0; i < propCount; ++i) {
            String key = in.readUTF();
            Object val = GraphRecordWriteable.readPropertyValue(in);
            if (val == null) continue;
            props.put(key, val);
        }
        return id;
    }

    private static void writePropertyValue(DataOutput out, String key, Object value) throws IOException {
        if (value == null) {
            out.writeShort(0);
            out.writeBoolean(false);
        } else if (value instanceof String) {
            out.writeShort(5);
            out.writeUTF((String)value);
        } else if (value instanceof Boolean) {
            out.writeShort(1);
            out.writeBoolean((Boolean)value);
        } else if (value instanceof Float) {
            out.writeShort(2);
            out.writeFloat(((Float)value).floatValue());
        } else if (value instanceof Integer) {
            out.writeShort(3);
            WritableUtils.writeVInt((DataOutput)out, (int)((Integer)value));
        } else if (value instanceof Long) {
            out.writeShort(4);
            WritableUtils.writeVLong((DataOutput)out, (long)((Long)value));
        } else if (value instanceof Double) {
            out.writeShort(6);
            out.writeDouble((Double)value);
        } else if (value instanceof Date) {
            out.writeShort(20);
            WritableUtils.writeVLong((DataOutput)out, (long)((Date)value).getTime());
        } else if (value instanceof Set) {
            out.writeShort(100);
            out.writeUTF(((Set)value).toString());
        } else {
            throw new UnsupportedOperationException("Unhandled property class=" + value.getClass() + " for key=" + key);
        }
    }

    private static Object readPropertyValue(DataInput in) throws IOException {
        short valType = in.readShort();
        switch (valType) {
            case 0: {
                in.readBoolean();
                return null;
            }
            case 5: {
                return in.readUTF();
            }
            case 1: {
                return in.readBoolean();
            }
            case 2: {
                return Float.valueOf(in.readFloat());
            }
            case 3: {
                return WritableUtils.readVInt((DataInput)in);
            }
            case 4: {
                return WritableUtils.readVLong((DataInput)in);
            }
            case 6: {
                return in.readDouble();
            }
            case 20: {
                return new Date(WritableUtils.readVLong((DataInput)in));
            }
            case 100: {
                return in.readUTF();
            }
        }
        throw new UnsupportedOperationException("Unhandled property class=" + valType);
    }
}

