/*
 * Decompiled with CFR 0.152.
 */
package net.deelam.graphtools.graphfactories;

import com.tinkerpop.blueprints.KeyIndexableGraph;
import com.tinkerpop.blueprints.impls.tg.TinkerGraph;
import com.tinkerpop.blueprints.util.wrappers.id.IdGraph;
import java.io.File;
import java.io.IOException;
import net.deelam.graphtools.GraphUri;
import net.deelam.graphtools.IdGraphFactory;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class IdGraphFactoryTinker
implements IdGraphFactory {
    private static final Logger log = LoggerFactory.getLogger(IdGraphFactoryTinker.class);

    public static void register() {
        GraphUri.register("tinker", new IdGraphFactoryTinker());
    }

    public IdGraph<TinkerGraph> open(GraphUri gUri) {
        IdGraph graph;
        TinkerGraph.FileType fileType = IdGraphFactoryTinker.getFileSaveType(gUri);
        if (fileType == null) {
            log.debug("Opening Tinker graph in memory");
            graph = new IdGraph((KeyIndexableGraph)new TinkerGraph());
        } else {
            String path = gUri.getUriPath();
            log.debug("Opening Tinker graph at path={} of type={}", (Object)path, (Object)fileType);
            graph = new IdGraph((KeyIndexableGraph)new TinkerGraph(path, fileType));
        }
        return graph;
    }

    private static TinkerGraph.FileType getFileSaveType(GraphUri gUri) {
        String path = gUri.getUriPath();
        if (path == null || path.length() < 1 || path.equals("/")) {
            return null;
        }
        TinkerGraph.FileType fileType = TinkerGraph.FileType.JAVA;
        String fileTypeStr = gUri.getConfig().getString("fileType");
        if (fileTypeStr != null) {
            fileType = TinkerGraph.FileType.valueOf((String)fileTypeStr.toUpperCase());
        }
        return fileType;
    }

    @Override
    public void delete(GraphUri gUri) throws IOException {
        TinkerGraph.FileType fileType = IdGraphFactoryTinker.getFileSaveType(gUri);
        if (fileType == null) {
            return;
        }
        File pathFile = new File(gUri.getUriPath());
        log.info("Deleting TinkerGraph at {}", (Object)pathFile);
        FileUtils.deleteDirectory((File)pathFile);
    }

    @Override
    public boolean exists(GraphUri gUri) {
        TinkerGraph.FileType fileType = IdGraphFactoryTinker.getFileSaveType(gUri);
        if (fileType == null) {
            return false;
        }
        File pathFile = new File(gUri.getUriPath());
        return pathFile.exists();
    }
}

