/*
 * Decompiled with CFR 0.152.
 */
package net.deelam.graphtools.graphfactories;

import com.google.common.collect.Iterators;
import com.tinkerpop.blueprints.KeyIndexableGraph;
import com.tinkerpop.blueprints.impls.neo4j.Neo4jGraph;
import com.tinkerpop.blueprints.util.wrappers.id.IdGraph;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import net.deelam.graphtools.GraphUri;
import net.deelam.graphtools.IdGraphFactory;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IdGraphFactoryNeo4j
implements IdGraphFactory {
    private static final Logger log = LoggerFactory.getLogger(IdGraphFactoryNeo4j.class);
    private static final String CONFIG_PREFIX = "blueprints.neo4j.conf.";

    public static void register() {
        GraphUri.register("neo4j", new IdGraphFactoryNeo4j());
    }

    public IdGraph<Neo4jGraph> open(GraphUri gUri) {
        String[] keys;
        Configuration conf = gUri.getConfig();
        for (String key : keys = (String[])Iterators.toArray((Iterator)conf.getKeys(), String.class)) {
            if (key.startsWith("blueprints.neo4j")) continue;
            conf.setProperty(CONFIG_PREFIX + key, conf.getProperty(key));
        }
        String path = gUri.getUriPath();
        this.checkPath(path);
        log.debug("Opening Neo4j graph at path=" + path);
        conf.setProperty("blueprints.neo4j.directory", (Object)path);
        IdGraph graph = new IdGraph((KeyIndexableGraph)new Neo4jGraph(conf));
        return graph;
    }

    private void checkPath(String path) {
        if (path == null || path.equals("/")) {
            throw new IllegalArgumentException("Provide a path like so: 'neo4j://./myDB'");
        }
    }

    @Override
    public void delete(GraphUri gUri) throws IOException {
        File pathFile = new File(gUri.getUri().toString());
        if (pathFile.exists()) {
            log.info("Deleting Neo4j DB at {}", (Object)pathFile);
            FileUtils.deleteDirectory((File)pathFile);
        }
    }

    @Override
    public boolean exists(GraphUri gUri) {
        File pathFile = new File(gUri.getUri().toString());
        return pathFile.exists();
    }
}

