/*
 * Decompiled with CFR 0.152.
 */
package net.deelam.graphtools;

import com.google.common.collect.Iterables;
import com.tinkerpop.blueprints.Direction;
import com.tinkerpop.blueprints.Edge;
import com.tinkerpop.blueprints.Element;
import com.tinkerpop.blueprints.Graph;
import com.tinkerpop.blueprints.KeyIndexableGraph;
import com.tinkerpop.blueprints.Vertex;
import com.tinkerpop.blueprints.impls.tg.TinkerGraph;
import com.tinkerpop.blueprints.util.wrappers.id.IdGraph;
import java.beans.ConstructorProperties;
import java.io.IOException;
import org.apache.commons.lang3.mutable.MutableInt;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class GraphSchemaStats {
    private static final Logger log = LoggerFactory.getLogger(GraphSchemaStats.class);
    final String nodeTypeProperty;
    private String[] subTypePropertyKeys = new String[0];
    private static final String ID_PROPKEY = "IdGraph.__id";
    static final String UNKNOWN_TYPE = "Unknown";
    static final String UNKNOWN_LABEL = "Unknown";

    public Graph getSchema(Graph inputGraph) throws IOException {
        IdGraph schemaG = new IdGraph((KeyIndexableGraph)new TinkerGraph());
        this.extractSchema(inputGraph, (Graph)schemaG);
        return schemaG;
    }

    public void extractSchema(Graph graph, Graph schema) {
        long nodeCount = 0L;
        long edgeCount = 0L;
        for (Vertex v : graph.getVertices()) {
            Vertex inTypeV;
            Vertex typeV;
            ++nodeCount;
            int outEdgeSize = Iterables.size((Iterable)v.getEdges(Direction.OUT, new String[0]));
            edgeCount += (long)outEdgeSize;
            boolean outEdgeCountEmpty = outEdgeSize == 0;
            boolean inEdgeCountEmpty = Iterables.isEmpty((Iterable)v.getEdges(Direction.IN, new String[0]));
            if (outEdgeCountEmpty) {
                if (inEdgeCountEmpty) {
                    typeV = this.getTypeVertex(schema, v, null);
                    GraphSchemaStats.extractProperties((Element)v, (Element)typeV, "__NODES_WITH_NO_EDGES");
                } else {
                    inTypeV = this.getTypeVertex(schema, v, Direction.IN);
                    GraphSchemaStats.extractProperties((Element)v, (Element)inTypeV, "__NODES_WITH_IN_EDGES_ONLY");
                }
            } else {
                typeV = this.getTypeVertex(schema, v, Direction.OUT);
                GraphSchemaStats.incrementCount((Element)typeV, "__NODES_WITH_OUT_EDGES");
                if (inEdgeCountEmpty) {
                    GraphSchemaStats.extractProperties((Element)v, (Element)typeV, "__NODES_WITH_OUT_EDGES_ONLY");
                }
                this.extractEdgeSchema(schema, v);
            }
            if (inEdgeCountEmpty) continue;
            inTypeV = this.getTypeVertex(schema, v, Direction.IN);
            GraphSchemaStats.incrementCount((Element)inTypeV, "__NODES_WITH_IN_EDGES");
        }
        log.debug("Total: {} nodes and {} edges", (Object)nodeCount, (Object)edgeCount);
    }

    private static void extractProperties(Element v, Element typeV, String countKey) {
        GraphSchemaStats.incrementCount(typeV, countKey);
        for (String k : v.getPropertyKeys()) {
            String className;
            if (k.equals("__id")) {
                String newKey = ID_PROPKEY;
                typeV.setProperty(newKey, (Object)v.getId().getClass().getSimpleName());
                continue;
            }
            String existingSimpleClassName = (String)typeV.getProperty(k);
            if (existingSimpleClassName.contains(className = v.getProperty(k).getClass().getSimpleName())) continue;
            typeV.setProperty(k, (Object)(existingSimpleClassName + "," + className));
        }
    }

    private static void incrementCount(Element typeV, String countKey) {
        if (countKey != null) {
            MutableInt counter = (MutableInt)typeV.getProperty(countKey);
            if (counter == null) {
                counter = new MutableInt();
                typeV.setProperty(countKey, (Object)counter);
            }
            counter.increment();
        }
    }

    private Vertex getTypeVertex(Graph schema, Vertex v, Direction direction) {
        Object type = v.getProperty(this.nodeTypeProperty);
        if (type == null) {
            type = "Unknown";
        }
        StringBuilder idSB = new StringBuilder(type.toString());
        for (String subTypePropKey : this.subTypePropertyKeys) {
            String subType = (String)v.getProperty(subTypePropKey);
            if (subType == null) continue;
            idSB.append("_").append(subType);
        }
        String id = idSB.append("_").append(direction).toString();
        Vertex typeV = schema.getVertex((Object)id);
        if (typeV == null) {
            typeV = schema.addVertex((Object)id);
        }
        return typeV;
    }

    private void extractEdgeSchema(Graph schema, Vertex outV) {
        Vertex outTypeV = this.getTypeVertex(schema, outV, Direction.OUT);
        for (Edge e : outV.getEdges(Direction.OUT, new String[0])) {
            GraphSchemaStats.incrementCount((Element)outTypeV, "__OUT_EDGES");
            Vertex inV = e.getVertex(Direction.IN);
            Vertex inTypeV = this.getTypeVertex(schema, inV, Direction.IN);
            GraphSchemaStats.extractProperties((Element)inV, (Element)inTypeV, "__IN_EDGES");
            Edge typeE = this.getTypeEdge(schema, outTypeV, e, inTypeV);
            GraphSchemaStats.extractProperties((Element)e, (Element)typeE, "__EDGES");
        }
    }

    private Edge getTypeEdge(Graph schema, Vertex outTypeV, Edge e, Vertex inTypeV) {
        String edgeId = outTypeV.getId().toString() + "->" + inTypeV.getId();
        Edge typeE = schema.getEdge((Object)edgeId);
        if (typeE == null) {
            String label = e.getLabel();
            if (label == null) {
                label = "Unknown";
            }
            typeE = schema.addEdge((Object)edgeId, outTypeV, inTypeV, label);
        }
        return typeE;
    }

    @ConstructorProperties(value={"nodeTypeProperty"})
    public GraphSchemaStats(String nodeTypeProperty) {
        this.nodeTypeProperty = nodeTypeProperty;
    }

    public void setSubTypePropertyKeys(String[] subTypePropertyKeys) {
        this.subTypePropertyKeys = subTypePropertyKeys;
    }
}

