/*
 * Decompiled with CFR 0.152.
 */
package net.deelam.graphtools;

import com.tinkerpop.blueprints.Direction;
import com.tinkerpop.blueprints.Edge;
import com.tinkerpop.blueprints.Vertex;
import java.io.Serializable;
import java.util.UUID;
import net.deelam.graphtools.GraphRecord;
import net.deelam.graphtools.GraphRecordElement;

public class GraphRecordEdge
extends GraphRecordElement
implements Edge,
Serializable {
    private static final long serialVersionUID = 201509030420L;
    protected String label;
    protected String outVertexStringId;
    protected String inVertexStringId;

    public GraphRecordEdge emptyCopy() {
        return new GraphRecordEdge(this.getStringId(), this.label, this.outVertexStringId, this.inVertexStringId);
    }

    private GraphRecordEdge(String id, String label, String outVertex, String inVertex) {
        super(id);
        this.label = label;
        this.outVertexStringId = outVertex;
        this.inVertexStringId = inVertex;
    }

    public GraphRecordEdge(String id, String label, Vertex outVertex, Vertex inVertex) {
        this(id, label, (String)outVertex.getId(), (String)inVertex.getId());
    }

    public GraphRecordEdge(String label, Vertex outVertex, Vertex inVertex) {
        this(GraphRecordEdge.newEdgeId(), label, (String)outVertex.getId(), (String)inVertex.getId());
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    private static String newEdgeId() {
        return UUID.randomUUID().toString();
    }

    public Vertex getVertex(Direction direction) throws IllegalArgumentException {
        if (direction == Direction.OUT) {
            return new GraphRecord(this.outVertexStringId);
        }
        if (direction == Direction.IN) {
            return new GraphRecord(this.inVertexStringId);
        }
        throw new UnsupportedOperationException();
    }

    public void setInNodeId(long id) {
        this.setNodeId(Direction.IN, id);
    }

    public void setOutNodeId(long id) {
        this.setNodeId(Direction.OUT, id);
    }

    public Long getInNodeId() {
        return this.getNodeId(Direction.IN);
    }

    public Long getOutNodeId() {
        return this.getNodeId(Direction.OUT);
    }

    public void setNodeId(Direction dir, long id) {
        this.setProperty(dir.toString() + LONG_ID_PROPKEY, id);
    }

    public Long getNodeId(Direction dir) {
        return (Long)this.getProperty(dir.toString() + LONG_ID_PROPKEY);
    }

    @Override
    public String toString() {
        return "EdgeWritable[" + super.toString() + ",outStrId=" + this.outVertexStringId + " inStrId=" + this.inVertexStringId + "]";
    }

    public GraphRecordEdge() {
    }

    public String getLabel() {
        return this.label;
    }

    public String getOutVertexStringId() {
        return this.outVertexStringId;
    }

    public String getInVertexStringId() {
        return this.inVertexStringId;
    }
}

