/*
 * Decompiled with CFR 0.152.
 */
package net.deelam.graphtools;

import com.tinkerpop.blueprints.Graph;
import com.tinkerpop.blueprints.util.io.graphml.GraphMLWriter;
import com.tinkerpop.blueprints.util.io.graphson.GraphSONWriter;
import java.io.IOException;
import net.deelam.graphtools.PrettyPrintXml;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphExporter {
    private static final Logger log = LoggerFactory.getLogger(GraphExporter.class);

    public static void exportGraphml(Graph graph, String filename) throws IOException {
        GraphExporter.exportGraphml(graph, filename, false);
    }

    public static void exportGraphml(Graph graph, String filename, boolean prettyPrint) throws IOException {
        log.info("Exported graph {} to {}", (Object)graph, (Object)filename);
        GraphMLWriter.outputGraph((Graph)graph, (String)filename);
        if (prettyPrint) {
            PrettyPrintXml.prettyPrint(filename, filename + "-pretty.graphml");
        }
    }

    public static void exportGson(Graph graph, String filename) throws IOException {
        log.info("Exported graph {} to {}", (Object)graph, (Object)filename);
        GraphSONWriter.outputGraph((Graph)graph, (String)filename);
    }
}

