/*
 * Decompiled with CFR 0.152.
 */
package net.csdn.modules.controller;

import com.google.inject.Inject;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import net.csdn.annotation.FDesc;
import net.csdn.annotation.MDesc;
import net.csdn.annotation.Param;
import net.csdn.annotation.rest.At;
import net.csdn.annotation.rest.BasicInfo;
import net.csdn.common.collect.Tuple3;
import net.csdn.common.logging.CSLogger;
import net.csdn.common.logging.Loggers;
import net.csdn.common.settings.Settings;
import net.csdn.modules.controller.APIDesc;
import net.csdn.modules.controller.ParamDesc;
import net.csdn.modules.controller.ResponseStatus;
import org.joda.time.DateTime;

public class API {
    private Settings settings;
    private CSLogger logger = Loggers.getLogger(API.class);
    private ConcurrentHashMap<Method, Tuple3<AtomicLong, AtomicLong, AtomicLong>> APIQPS = new ConcurrentHashMap();
    private ConcurrentHashMap<Method, AvgTime> APIAVGTIME = new ConcurrentHashMap();
    private ConcurrentHashMap<Method, ConcurrentHashMap<Integer, AtomicLong>> APISTATUS = new ConcurrentHashMap();
    private Long SystemStartTime = 0L;
    private boolean forceAPICheck = false;
    private int internal = 1000;
    private int averageTimeInternal = 1000;

    @Inject
    public API(Settings settings) {
        this.settings = settings;
        this.internal = settings.getAsInt("application.api.qps.internal", Integer.valueOf(1000));
        this.averageTimeInternal = settings.getAsInt("application.api.qps.average-time-internal", Integer.valueOf(1000));
        this.forceAPICheck = settings.getAsBoolean("application.api.strict.check", Boolean.valueOf(false));
        this.SystemStartTime = System.currentTimeMillis();
    }

    public void addPath(Method api) {
        this.APIQPS.putIfAbsent(api, (Tuple3<AtomicLong, AtomicLong, AtomicLong>)new Tuple3((Object)new AtomicLong(this.SystemStartTime), (Object)new AtomicLong(), (Object)new AtomicLong()));
        this.APIAVGTIME.putIfAbsent(api, new AvgTime(new AtomicLong(this.SystemStartTime), new AtomicLong(), new AtomicLong(), new AtomicLong()));
        this.APISTATUS.putIfAbsent(api, new ConcurrentHashMap());
    }

    public boolean validateAPI() {
        if (this.forceAPICheck) {
            return true;
        }
        return true;
    }

    public Map<Method, APIDesc> collectAPIInfoes() {
        HashMap<Method, APIDesc> APIDescs = new HashMap<Method, APIDesc>();
        for (Method method : this.APIQPS.keySet()) {
            At path = method.getAnnotation(At.class);
            MDesc mDesc = method.getAnnotation(MDesc.class);
            BasicInfo basicInfo = method.getAnnotation(BasicInfo.class);
            APIDesc apiDesc = new APIDesc();
            apiDesc.path = path.path()[0];
            apiDesc.desc = mDesc != null ? mDesc.value() : "";
            apiDesc.qps = ((AtomicLong)this.APIQPS.get(method).v3()).get();
            apiDesc.avgTime = this.APIAVGTIME.get((Object)method).lastTimeRange.get();
            apiDesc.paramDesces = this.createParamDescs(method);
            ArrayList<ResponseStatus> responseStatuses = new ArrayList<ResponseStatus>();
            for (Map.Entry<Integer, AtomicLong> item : this.APISTATUS.get(method).entrySet()) {
                ResponseStatus responseStatus = new ResponseStatus();
                responseStatus.status = item.getKey();
                responseStatus.count = item.getValue().get();
                responseStatuses.add(responseStatus);
            }
            apiDesc.responseStatuses = responseStatuses;
            APIDescs.put(method, apiDesc);
        }
        return APIDescs;
    }

    private List<ParamDesc> createParamDescs(Method method) {
        ArrayList<ParamDesc> paramDescs = new ArrayList<ParamDesc>();
        Annotation[][] paramAnnoes = method.getParameterAnnotations();
        Class<?>[] types = method.getParameterTypes();
        for (int i = 0; i < paramAnnoes.length; ++i) {
            Annotation[] paramAnno = paramAnnoes[i];
            if (paramAnno.length == 0) continue;
            ParamDesc paramDesc = new ParamDesc();
            for (Annotation item : paramAnno) {
                if (item instanceof FDesc) {
                    paramDesc.desc = ((FDesc)item).value();
                }
                if (!(item instanceof Param)) continue;
                paramDesc.name = ((Param)item).value();
            }
            paramDesc.ptype = types[i].getName();
            paramDescs.add(paramDesc);
        }
        return paramDescs;
    }

    public boolean enable() {
        return this.settings.getAsBoolean("application.api.qps.enable", Boolean.valueOf(false));
    }

    public synchronized void qpsIncrement(Method api) {
        Tuple3<AtomicLong, AtomicLong, AtomicLong> info;
        if (!this.enable() || api == null) {
            return;
        }
        long now = System.currentTimeMillis();
        if (now - ((AtomicLong)(info = this.APIQPS.get(api)).v1()).get() > (long)this.internal) {
            ((AtomicLong)info.v3()).set(((AtomicLong)info.v2()).get());
            ((AtomicLong)info.v2()).set(0L);
            ((AtomicLong)info.v1()).set(now);
        } else {
            ((AtomicLong)info.v2()).incrementAndGet();
        }
    }

    public synchronized void averageTimeIncrement(Method api, long time) {
        if (!this.enable() || api == null) {
            return;
        }
        long now = System.currentTimeMillis();
        AvgTime info = this.APIAVGTIME.get(api);
        info.count.incrementAndGet();
        if (now - info.timeStart.get() > (long)this.averageTimeInternal) {
            if (info.count.get() == 0L) {
                info.lastTimeRange.set(0L);
            } else {
                info.lastTimeRange.set(info.nowTimeRange.get() / info.count.get());
            }
            info.nowTimeRange.set(0L);
            info.timeStart.set(now);
        } else {
            info.nowTimeRange.addAndGet(time);
        }
    }

    public synchronized void statusIncrement(Method api, int status) {
        if (!this.enable() || api == null) {
            return;
        }
        ConcurrentHashMap<Integer, AtomicLong> chm = this.APISTATUS.get(api);
        if (!chm.containsKey(status)) {
            chm.put(status, new AtomicLong());
        }
        chm.get(status).incrementAndGet();
    }

    public String systemStartTime() {
        return new DateTime((Object)this.SystemStartTime).toString("yyyy-MM-dd HH-mm-ss S");
    }

    class AvgTime {
        AtomicLong timeStart;
        AtomicLong nowTimeRange;
        AtomicLong lastTimeRange;
        AtomicLong count;

        AvgTime(AtomicLong timeStart, AtomicLong nowTimeRange, AtomicLong lastTimeRange, AtomicLong count) {
            this.timeStart = timeStart;
            this.nowTimeRange = nowTimeRange;
            this.lastTimeRange = lastTimeRange;
            this.count = count;
        }
    }
}

