/*
 * Decompiled with CFR 0.152.
 */
package net.csdn.modules.cache;

import com.google.inject.Inject;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import net.csdn.common.settings.Settings;
import tech.mlsql.common.utils.cache.Cache;
import tech.mlsql.common.utils.cache.CacheBuilder;
import tech.mlsql.common.utils.cache.CacheLoader;
import tech.mlsql.common.utils.cache.LoadingCache;

public class AppCache {
    private Settings settings;
    private Cache<String, Object> defaultCache;
    private Map<String, LoadingCache> cacheMap;

    @Inject
    public AppCache(Settings settings) {
        this.settings = settings;
        this.defaultCache = CacheBuilder.newBuilder().expireAfterWrite((long)settings.getAsInt("cache.refresh.minutes", Integer.valueOf(2)).intValue(), TimeUnit.MINUTES).maximumSize((long)settings.getAsInt("cache.maximumSize", Integer.valueOf(10000)).intValue()).build();
        this.cacheMap = new ConcurrentHashMap<String, LoadingCache>();
    }

    public <T> T fetch(String name, Callable<T> callable) {
        try {
            return (T)this.defaultCache.get((Object)name, callable);
        }
        catch (ExecutionException e) {
            e.printStackTrace();
            return null;
        }
    }

    public <K, V> AppCache buildCache(String name, CacheLoader<K, V> cacheLoader, int timeByMINUTES) {
        if (!this.cacheMap.containsKey(name)) {
            LoadingCache cache = CacheBuilder.newBuilder().expireAfterWrite((long)timeByMINUTES, TimeUnit.MINUTES).maximumSize(1L).build(cacheLoader);
            this.cacheMap.put(name, cache);
        }
        return this;
    }

    public LoadingCache cache(String name) {
        return this.cacheMap.get(name);
    }
}

