/*
 * Decompiled with CFR 0.152.
 */
package net.csdn.bootstrap.loader.impl;

import com.google.inject.AbstractModule;
import java.io.DataInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import javassist.CtClass;
import net.csdn.ServiceFramwork;
import net.csdn.annotation.AnnotationException;
import net.csdn.annotation.Util;
import net.csdn.bootstrap.loader.Loader;
import net.csdn.common.collections.WowCollections;
import net.csdn.common.logging.CSLogger;
import net.csdn.common.logging.Loggers;
import net.csdn.common.logging.support.MessageFormat;
import net.csdn.common.scan.ScanService;
import net.csdn.common.settings.Settings;

public class UtilLoader
implements Loader {
    private CSLogger logger = Loggers.getLogger(UtilLoader.class);

    @Override
    public void load(Settings settings) throws Exception {
        final ArrayList moduleList = new ArrayList();
        for (String item : WowCollections.split2((String)settings.get("application.util"), (String)",")) {
            ServiceFramwork.scanService.scanArchives(item, new ScanService.LoadClassEnhanceCallBack(){

                public Class loaded(DataInputStream classFile) {
                    try {
                        CtClass ctClass = ServiceFramwork.classPool.makeClass((InputStream)classFile);
                        if (!ctClass.hasAnnotation(Util.class)) {
                            return null;
                        }
                        UtilLoader.this.logger.info("util load :    " + ctClass.getName(), new Object[0]);
                        final Class clzz = ctClass.toClass();
                        final Util util = clzz.getAnnotation(Util.class);
                        if (clzz.isInterface()) {
                            throw new AnnotationException(MessageFormat.format((String)"{} util should not be interface", (Object[])new Object[]{clzz.getName()}));
                        }
                        moduleList.add(new AbstractModule(){

                            protected void configure() {
                                this.bind(clzz).in(util.value());
                            }
                        });
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    return null;
                }
            });
        }
        ServiceFramwork.AllModules.addAll(moduleList);
    }
}

