/*
 * Decompiled with CFR 0.152.
 */
package net.csdn.bootstrap.loader.impl;

import com.google.inject.AbstractModule;
import com.google.inject.Scopes;
import com.google.inject.Singleton;
import java.io.DataInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import javassist.CtClass;
import net.csdn.ServiceFramwork;
import net.csdn.annotation.AnnotationException;
import net.csdn.annotation.Service;
import net.csdn.bootstrap.loader.Loader;
import net.csdn.common.collections.WowCollections;
import net.csdn.common.logging.CSLogger;
import net.csdn.common.logging.Loggers;
import net.csdn.common.logging.support.MessageFormat;
import net.csdn.common.scan.ScanService;
import net.csdn.common.settings.Settings;
import tech.mlsql.common.utils.collect.ImmutableMap;

public class ServiceLoader
implements Loader {
    private CSLogger logger = Loggers.getLogger(ServiceLoader.class);

    @Override
    public void load(final Settings settings) throws Exception {
        ArrayList<Object> moduleList = new ArrayList<Object>();
        final HashSet ctClasses = new HashSet();
        this.logger.info("scan service package => " + settings.get("application.service"), new Object[0]);
        for (String item : WowCollections.split2((String)settings.get("application.service"), (String)",")) {
            ServiceFramwork.scanService.scanArchives(item, new ScanService.LoadClassEnhanceCallBack(){

                public Class loaded(DataInputStream classFile) {
                    try {
                        CtClass ctClass = ServiceFramwork.classPool.makeClass((InputStream)classFile);
                        try {
                            ctClasses.add(ctClass.toClass());
                        }
                        catch (Exception e) {
                            String name = ctClass.getName();
                            Class<?> me = Class.forName(name);
                            if (!ctClasses.contains(me)) {
                                ctClasses.add(me);
                            }
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    return null;
                }
            });
        }
        for (final Class clzz : ctClasses) {
            if (clzz.getAnnotation(Singleton.class) != null) {
                this.logger.info("load  service with @Singleton  => " + clzz.getName(), new Object[0]);
                moduleList.add(new AbstractModule(){

                    protected void configure() {
                        this.bind(clzz).in(Scopes.SINGLETON);
                    }
                });
                continue;
            }
            final Service service = clzz.getAnnotation(Service.class);
            if (service == null) continue;
            if (clzz.isInterface() && service.implementedBy() == null) {
                throw new AnnotationException(MessageFormat.format((String)"{} no implemented class configured", (Object[])new Object[]{clzz.getName()}));
            }
            moduleList.add(new AbstractModule(){

                protected void configure() {
                    if (clzz.isInterface()) {
                        ImmutableMap singleton = settings.getByPrefix("application.dynamic.implemented.singleton.").getAsMap();
                        ImmutableMap prototype = settings.getByPrefix("application.dynamic.implemented.prototype.").getAsMap();
                        if (singleton.containsKey(clzz.getName()) || prototype.containsKey(clzz.getName())) {
                            ServiceLoader.this.logger.info("service will not loaned because application.dynamic.implemented.singleton or application.dynamic.implemented.prototype configured:  with @Service => " + clzz.getName() + " to " + service.implementedBy().getName() + " in " + service.value().getName(), new Object[0]);
                        } else {
                            ServiceLoader.this.logger.info("load  service with @Service => " + clzz.getName() + " to " + service.implementedBy().getName() + " in " + service.value().getName(), new Object[0]);
                            this.bind(clzz).to(service.implementedBy()).in(service.value());
                        }
                    } else {
                        ServiceLoader.this.logger.info("load  service with @Service => " + clzz.getName() + " in " + service.value().getName(), new Object[0]);
                        this.bind(clzz).in(service.value());
                    }
                }
            });
        }
        for (final Map.Entry entry : settings.getByPrefix("application.dynamic.implemented.singleton.").getAsMap().entrySet()) {
            moduleList.add(new AbstractModule(){

                protected void configure() {
                    try {
                        Class<?> clzz = Class.forName((String)entry.getValue());
                        this.bind(Class.forName((String)entry.getKey())).to(clzz).in(Scopes.SINGLETON);
                    }
                    catch (ClassNotFoundException e) {
                        e.printStackTrace();
                    }
                }
            });
        }
        for (final Map.Entry entry : settings.getByPrefix("application.dynamic.implemented.prototype.").getAsMap().entrySet()) {
            moduleList.add(new AbstractModule(){

                protected void configure() {
                    try {
                        Class<?> clzz = Class.forName((String)entry.getValue());
                        this.bind(Class.forName((String)entry.getKey())).to(clzz).in(Scopes.NO_SCOPE);
                    }
                    catch (ClassNotFoundException e) {
                        e.printStackTrace();
                    }
                }
            });
        }
        this.logger.info("load service in ServiceFramwork.serviceModules =>" + ServiceFramwork.serviceModules.size(), new Object[0]);
        moduleList.addAll(ServiceFramwork.serviceModules);
        ServiceFramwork.AllModules.addAll(moduleList);
        this.logger.info("total load service  =>" + ServiceFramwork.AllModules.size(), new Object[0]);
    }
}

