/*
 * Decompiled with CFR 0.152.
 */
package net.csdn.bootstrap.loader.impl;

import com.google.inject.AbstractModule;
import com.google.inject.Singleton;
import java.util.ArrayList;
import net.csdn.ServiceFramwork;
import net.csdn.bootstrap.loader.Loader;
import net.csdn.common.scan.ScanModule;
import net.csdn.common.settings.Settings;
import net.csdn.jpa.type.DBInfo;
import net.csdn.jpa.type.DBType;
import net.csdn.modules.cache.AppCacheModule;
import net.csdn.modules.cache.CacheModule;
import net.csdn.modules.controller.ControllerModule;
import net.csdn.modules.http.HttpModule;
import net.csdn.modules.settings.SettingsModule;
import net.csdn.modules.threadpool.ThreadPoolModule;
import net.csdn.modules.transport.TransportModule;

public class ModuelLoader
implements Loader {
    @Override
    public void load(final Settings settings) {
        ArrayList<Object> moduleList = new ArrayList<Object>();
        moduleList.add((Object)new SettingsModule(settings));
        moduleList.add((Object)new ThreadPoolModule());
        moduleList.add((Object)new TransportModule());
        moduleList.add((Object)new HttpModule());
        moduleList.add(new ScanModule());
        moduleList.add((Object)new ControllerModule());
        boolean disableRedis = settings.getAsBoolean((Object)((Object)ServiceFramwork.mode) + ".datasources.redis.disable", Boolean.valueOf(true));
        if (!disableRedis) {
            moduleList.add((Object)new CacheModule());
        }
        moduleList.add((Object)new AppCacheModule());
        boolean disableMysql = settings.getAsBoolean((Object)((Object)ServiceFramwork.mode) + ".datasources.mysql.disable", Boolean.valueOf(false));
        if (!disableMysql) {
            moduleList.add(new AbstractModule(){

                protected void configure() {
                    this.bind(DBInfo.class).in(Singleton.class);
                }
            });
            moduleList.add(new AbstractModule(){

                protected void configure() {
                    String clzzName = settings.get("type_mapping", "net.csdn.jpa.type.impl.MysqlType");
                    try {
                        Class<?> czz = Class.forName(clzzName);
                        this.bind(DBType.class).to(czz).in(Singleton.class);
                    }
                    catch (ClassNotFoundException e) {
                        e.printStackTrace();
                    }
                }
            });
        }
        moduleList.addAll(ServiceFramwork.modules);
        ServiceFramwork.AllModules.addAll(moduleList);
    }
}

