/*
 * Decompiled with CFR 0.152.
 */
package net.csdn.modules.controller;

import com.google.common.collect.ImmutableMap;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import net.csdn.common.logging.CSLogger;
import net.csdn.common.logging.Loggers;
import net.csdn.common.settings.Settings;
import net.sf.json.JSONObject;

@Singleton
public class QpsManager {
    private String module = "qps";
    private Map<String, Integer> qpsConfs = new ConcurrentHashMap<String, Integer>();
    private long timePeriod;
    private Map<String, QpsValue> currentQps = new ConcurrentHashMap<String, QpsValue>();
    private CSLogger logger = Loggers.getLogger(QpsManager.class);
    private ScheduledExecutorService scheduledExecutorService = Executors.newScheduledThreadPool(1, Executors.defaultThreadFactory());
    private Settings settings;

    public String qpsConfs() {
        return JSONObject.fromObject(this.qpsConfs).toString();
    }

    public void configureQpsLimiter(Map<String, String> config) {
        boolean qpsLimitEnable = this.settings.getAsBoolean("qpslimit.enable", Boolean.valueOf(false));
        if (qpsLimitEnable) {
            for (Map.Entry<String, String> conf : config.entrySet()) {
                this.qpsConfs.put(conf.getKey(), Integer.parseInt(conf.getValue()));
            }
        }
    }

    @Inject
    public QpsManager(Settings settings) {
        this.settings = settings;
        ImmutableMap confs = settings.getByPrefix("qps.").getAsMap();
        if (confs != null) {
            this.logger.info("\u52a0\u8f7d\u914d\u7f6e " + confs, new Object[0]);
            for (Map.Entry conf : confs.entrySet()) {
                this.qpsConfs.put((String)conf.getKey(), Integer.parseInt((String)conf.getValue()));
            }
        }
        this.timePeriod = settings.getAsLong("qps.period", Long.valueOf(3000L));
        this.logger.info("\u7edf\u8ba1\u5468\u671f " + this.timePeriod + "\u79d2", new Object[0]);
        this.scheduledExecutorService.scheduleWithFixedDelay(new Runnable(){

            @Override
            public void run() {
                QpsManager.this.logger.debug("\u5f00\u59cbqps\u6570\u636e\u5207\u6362", new Object[0]);
                QpsManager.this.currentQps = new ConcurrentHashMap();
            }
        }, 1000L, this.timePeriod, TimeUnit.MILLISECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean check(String type) {
        Integer max = this.qpsConfs.get(type);
        if (max == null) {
            return false;
        }
        QpsValue currentQpsValue = this.currentQps.get(type);
        if (currentQpsValue == null) {
            Map<String, QpsValue> map = this.currentQps;
            synchronized (map) {
                currentQpsValue = this.currentQps.get(type);
                if (currentQpsValue == null) {
                    currentQpsValue = new QpsValue();
                    this.currentQps.put(type, currentQpsValue);
                }
            }
        }
        currentQpsValue.value.incrementAndGet();
        return max != null && currentQpsValue != null && (long)max.intValue() < (long)(currentQpsValue.value.get() * 1000) / this.timePeriod;
    }

    public static class QpsValue {
        public AtomicInteger value = new AtomicInteger();
    }
}

