/*
 * Decompiled with CFR 0.152.
 */
package net.csdn.modules.thrift.pool;

import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import net.csdn.modules.thrift.pool.NoValidObjectException;
import net.csdn.modules.thrift.pool.ObjectPool;
import net.csdn.modules.thrift.pool.PoolExhaustedException;
import net.csdn.modules.thrift.pool.PoolableObjectFactory;

public class BaseObjectPool<K, V>
implements ObjectPool<K, V> {
    private static final int MAX_VALIDATION_RETRY_COUNT = 3;
    private final PoolableObjectFactory<K, V> factory;
    private final int min;
    private final int max;
    private final boolean borrowValidation;
    private final boolean returnValidation;
    private final boolean disposable;
    private final long keepAliveTimeoutInSecs;
    private final ConcurrentHashMap<K, QueuePool<V>> keyedObjectPool = new ConcurrentHashMap();
    private final ConcurrentHashMap<V, K> managedActiveObjects = new ConcurrentHashMap();
    private final AtomicBoolean destroyed = new AtomicBoolean();
    private final ScheduledExecutorService scheduledExecutor;
    private final ScheduledFuture<?> scheduledFuture;

    private BaseObjectPool(Builder<K, V> builder) {
        this.factory = ((Builder)builder).factory;
        this.min = ((Builder)builder).min;
        this.max = ((Builder)builder).max;
        this.borrowValidation = ((Builder)builder).borrowValidation;
        this.returnValidation = ((Builder)builder).returnValidation;
        this.disposable = ((Builder)builder).disposable;
        this.keepAliveTimeoutInSecs = ((Builder)builder).keepAliveTimeoutInSecs;
        if (this.keepAliveTimeoutInSecs > 0L) {
            this.scheduledExecutor = Executors.newSingleThreadScheduledExecutor();
            this.scheduledFuture = this.scheduledExecutor.scheduleWithFixedDelay(new EvictionTask(), this.keepAliveTimeoutInSecs, this.keepAliveTimeoutInSecs, TimeUnit.SECONDS);
        } else {
            this.scheduledExecutor = null;
            this.scheduledFuture = null;
        }
    }

    @Override
    public void createAllMinObjects(K key) throws NoValidObjectException {
        V result;
        if (this.destroyed.get()) {
            throw new IllegalStateException("pool has already destroyed");
        }
        if (key == null) {
            throw new IllegalArgumentException("key must not be null");
        }
        QueuePool<V> pool = this.keyedObjectPool.get(key);
        if (pool == null) {
            QueuePool newPool = new QueuePool(this.max);
            QueuePool oldPool = this.keyedObjectPool.putIfAbsent(key, newPool);
            QueuePool queuePool = pool = oldPool == null ? newPool : oldPool;
        }
        if (((QueuePool)pool).destroyed.get()) {
            throw new IllegalStateException("pool already has destroyed. key=" + key);
        }
        for (int i = 0; i < this.max && (result = this.createIfUnderSpecificSize(this.min, pool, key, this.borrowValidation)) != null; ++i) {
            if (((QueuePool)pool).queue.offer(result)) continue;
            try {
                this.factory.destroyObject(key, result);
            }
            catch (Exception exception) {
                // empty catch block
            }
            ((QueuePool)pool).poolSizeHint.decrementAndGet();
            break;
        }
    }

    @Override
    public void removeAllObjects(K key) {
        if (this.destroyed.get()) {
            throw new IllegalStateException("pool has already destroyed");
        }
        if (key == null) {
            throw new IllegalArgumentException("key must not be null");
        }
        QueuePool<V> pool = this.keyedObjectPool.get(key);
        if (pool == null) {
            return;
        }
        if (((QueuePool)pool).destroyed.get()) {
            return;
        }
        this.clearPool(pool, key);
    }

    @Override
    public V borrowObject(K key, long timeoutInMillis) throws PoolExhaustedException, NoValidObjectException, InterruptedException {
        Object result;
        boolean disposableCreation;
        if (this.destroyed.get()) {
            throw new IllegalStateException("pool already has destroyed");
        }
        if (key == null) {
            throw new IllegalArgumentException("key must not be null");
        }
        QueuePool<V> pool = this.keyedObjectPool.get(key);
        if (pool == null) {
            QueuePool newPool = new QueuePool(this.max);
            QueuePool oldPool = this.keyedObjectPool.putIfAbsent(key, newPool);
            QueuePool queuePool = pool = oldPool == null ? newPool : oldPool;
        }
        if (((QueuePool)pool).destroyed.get()) {
            throw new IllegalStateException("pool already has destroyed. key=" + key);
        }
        int retryCount = 0;
        do {
            disposableCreation = false;
            result = this.createIfUnderSpecificSize(this.min, pool, key, false);
            if (result == null) {
                result = ((QueuePool)pool).queue.poll();
            }
            if (result == null) {
                result = this.createIfUnderSpecificSize(this.max, pool, key, false);
            }
            if (result == null) {
                result = timeoutInMillis < 0L && !this.disposable ? ((QueuePool)pool).queue.take() : ((QueuePool)pool).queue.poll(timeoutInMillis, TimeUnit.MILLISECONDS);
            }
            if (result == null && this.disposable) {
                try {
                    result = this.factory.createObject(key);
                }
                catch (Exception e) {
                    throw new NoValidObjectException(e);
                }
                disposableCreation = true;
            }
            if (result == null) {
                throw new PoolExhaustedException("pool is exhausted");
            }
            if (!this.borrowValidation) break;
            boolean valid = false;
            try {
                valid = this.factory.validateObject(key, result);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (valid) break;
            try {
                this.factory.destroyObject(key, result);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (!disposableCreation) {
                ((QueuePool)pool).poolSizeHint.decrementAndGet();
            }
            result = null;
        } while (this.borrowValidation && ++retryCount <= 3);
        if (this.borrowValidation && result == null) {
            throw new NoValidObjectException("there is no valid object");
        }
        if (result != null && ((QueuePool)pool).destroyed.get()) {
            try {
                this.factory.destroyObject(key, result);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (!disposableCreation) {
                ((QueuePool)pool).poolSizeHint.decrementAndGet();
            }
            throw new IllegalStateException("pool already has destroyed. key=" + key);
        }
        if (result != null && !disposableCreation) {
            this.managedActiveObjects.put(result, key);
        }
        return result;
    }

    private V createIfUnderSpecificSize(int specificSize, QueuePool<V> pool, K key, boolean validation) throws NoValidObjectException {
        if (this.destroyed.get()) {
            throw new IllegalStateException("pool has already destroyed");
        }
        if (pool == null) {
            throw new IllegalArgumentException("pool must not be null");
        }
        if (key == null) {
            throw new IllegalArgumentException("key must not be null");
        }
        if (specificSize >= ((QueuePool)pool).poolSizeHint.incrementAndGet()) {
            try {
                int currentSizeHint;
                V result = this.factory.createObject(key);
                if (result == null) {
                    ((QueuePool)pool).poolSizeHint.decrementAndGet();
                    throw new IllegalStateException("failed to create the object. the created object must not be null");
                }
                if (validation) {
                    boolean valid = false;
                    try {
                        valid = this.factory.validateObject(key, result);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (!valid) {
                        try {
                            this.factory.destroyObject(key, result);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        ((QueuePool)pool).poolSizeHint.decrementAndGet();
                        return null;
                    }
                }
                if ((currentSizeHint = ((QueuePool)pool).poolSizeHint.get()) > ((QueuePool)pool).peakSizeHint) {
                    ((QueuePool)pool).peakSizeHint = currentSizeHint;
                }
                return result;
            }
            catch (Exception e) {
                ((QueuePool)pool).poolSizeHint.decrementAndGet();
                throw new NoValidObjectException(e);
            }
        }
        ((QueuePool)pool).poolSizeHint.decrementAndGet();
        return null;
    }

    @Override
    public void returnObject(K key, V value) {
        if (this.destroyed.get()) {
            throw new IllegalStateException("pool has already destroyed");
        }
        if (key == null) {
            throw new IllegalArgumentException("key must not be null");
        }
        if (value == null) {
            return;
        }
        K managed = this.managedActiveObjects.remove(value);
        QueuePool<V> pool = this.keyedObjectPool.get(key);
        if (pool == null || managed == null) {
            try {
                this.factory.destroyObject(key, value);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return;
        }
        if (this.returnValidation) {
            boolean valid = false;
            try {
                valid = this.factory.validateObject(key, value);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (!valid) {
                try {
                    this.factory.destroyObject(key, value);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ((QueuePool)pool).poolSizeHint.decrementAndGet();
                return;
            }
        }
        if (((QueuePool)pool).destroyed.get() || !((QueuePool)pool).queue.offer(value)) {
            try {
                this.factory.destroyObject(key, value);
            }
            catch (Exception exception) {
                // empty catch block
            }
            ((QueuePool)pool).poolSizeHint.decrementAndGet();
        }
    }

    @Override
    public void removeObject(K key, V value) {
        if (this.destroyed.get()) {
            throw new IllegalStateException("pool has already destroyed");
        }
        if (key == null) {
            throw new IllegalArgumentException("key must not be null");
        }
        if (value == null) {
            return;
        }
        K managed = this.managedActiveObjects.remove(value);
        QueuePool<V> pool = this.keyedObjectPool.get(key);
        if (pool == null || managed == null) {
            try {
                this.factory.destroyObject(key, value);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return;
        }
        ((QueuePool)pool).queue.remove(value);
        try {
            this.factory.destroyObject(key, value);
        }
        catch (Exception exception) {
            // empty catch block
        }
        ((QueuePool)pool).poolSizeHint.decrementAndGet();
    }

    @Override
    public void destroy() {
        if (!this.destroyed.compareAndSet(false, true)) {
            return;
        }
        if (this.scheduledFuture != null) {
            this.scheduledFuture.cancel(true);
        }
        if (this.scheduledExecutor != null) {
            this.scheduledExecutor.shutdown();
        }
        for (Map.Entry<K, QueuePool<V>> entry : this.keyedObjectPool.entrySet()) {
            K key = entry.getKey();
            QueuePool<V> pool = entry.getValue();
            ((QueuePool)pool).destroyed.compareAndSet(false, true);
            this.clearPool(pool, key);
        }
        this.keyedObjectPool.clear();
        for (Map.Entry<Object, QueuePool<Object>> entry : this.managedActiveObjects.entrySet()) {
            Object object = entry.getKey();
            QueuePool<Object> key = entry.getValue();
            try {
                this.factory.destroyObject(key, object);
            }
            catch (Exception exception) {}
        }
        this.managedActiveObjects.clear();
    }

    private void clearPool(QueuePool<V> pool, K key) {
        Object object;
        if (pool == null || key == null) {
            return;
        }
        while ((object = ((QueuePool)pool).queue.poll()) != null) {
            try {
                this.factory.destroyObject(key, object);
            }
            catch (Exception exception) {
                // empty catch block
            }
            ((QueuePool)pool).poolSizeHint.decrementAndGet();
        }
    }

    @Override
    public int getPoolSize(K key) {
        if (this.destroyed.get()) {
            return -1;
        }
        if (key == null) {
            return -1;
        }
        QueuePool<V> pool = this.keyedObjectPool.get(key);
        if (pool == null) {
            return 0;
        }
        return ((QueuePool)pool).poolSizeHint.get();
    }

    @Override
    public int getPeakCount(K key) {
        if (this.destroyed.get()) {
            return -1;
        }
        if (key == null) {
            return -1;
        }
        QueuePool<V> pool = this.keyedObjectPool.get(key);
        if (pool == null) {
            return 0;
        }
        return ((QueuePool)pool).peakSizeHint;
    }

    @Override
    public int getActiveCount(K key) {
        if (this.destroyed.get()) {
            return -1;
        }
        if (key == null) {
            return -1;
        }
        QueuePool<V> pool = this.keyedObjectPool.get(key);
        if (pool == null) {
            return 0;
        }
        return ((QueuePool)pool).poolSizeHint.get() - ((QueuePool)pool).queue.size();
    }

    @Override
    public int getIdleCount(K key) {
        if (this.destroyed.get()) {
            return -1;
        }
        if (key == null) {
            return -1;
        }
        QueuePool<V> pool = this.keyedObjectPool.get(key);
        if (pool == null) {
            return 0;
        }
        return ((QueuePool)pool).queue.size();
    }

    public int getMin() {
        return this.min;
    }

    public int getMax() {
        return this.max;
    }

    public boolean isBorrowValidation() {
        return this.borrowValidation;
    }

    public boolean isReturnValidation() {
        return this.returnValidation;
    }

    public boolean isDisposable() {
        return this.disposable;
    }

    public long getKeepAliveTimeoutInSecs() {
        return this.keepAliveTimeoutInSecs;
    }

    public String toString() {
        return "BaseObjectPool{keepAliveTimeoutInSecs=" + this.keepAliveTimeoutInSecs + ", disposable=" + this.disposable + ", borrowValidation=" + this.borrowValidation + ", returnValidation=" + this.returnValidation + ", max=" + this.max + ", min=" + this.min + ", factory=" + this.factory + '}';
    }

    public static class Builder<K, V> {
        private static final int DEFAULT_MIN = 5;
        private static final int DEFAULT_MAX = Integer.MAX_VALUE;
        private static final boolean DEFAULT_BORROW_VALIDATION = false;
        private static final boolean DEFAULT_RETURN_VALIDATION = false;
        private static final boolean DEFAULT_DISPOSABLE = false;
        private static final long DEFAULT_KEEP_ALIVE_TIMEOUT_IN_SEC = 1800L;
        private final PoolableObjectFactory<K, V> factory;
        private int min = 5;
        private int max = Integer.MAX_VALUE;
        private boolean borrowValidation = false;
        private boolean returnValidation = false;
        private boolean disposable = false;
        private long keepAliveTimeoutInSecs = 1800L;

        public Builder(PoolableObjectFactory<K, V> factory) {
            this.factory = factory;
        }

        public Builder<K, V> min(int min) {
            if (min >= 0) {
                this.min = min;
            }
            return this;
        }

        public Builder<K, V> max(int max) {
            if (max >= 1) {
                this.max = max;
            }
            return this;
        }

        public Builder<K, V> borrowValidation(boolean borrowValidation) {
            this.borrowValidation = borrowValidation;
            return this;
        }

        public Builder<K, V> returnValidation(boolean returnValidation) {
            this.returnValidation = returnValidation;
            return this;
        }

        public Builder<K, V> disposable(boolean disposable) {
            this.disposable = disposable;
            return this;
        }

        public Builder<K, V> keepAliveTimeoutInSecs(long keepAliveTimeoutInSecs) {
            this.keepAliveTimeoutInSecs = keepAliveTimeoutInSecs;
            return this;
        }

        public ObjectPool<K, V> build() {
            if (this.min > this.max) {
                this.max = this.min;
            }
            return new BaseObjectPool(this);
        }
    }

    private class EvictionTask
    implements Runnable {
        private final AtomicBoolean running = new AtomicBoolean();

        private EvictionTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (!this.running.compareAndSet(false, true)) {
                return;
            }
            try {
                for (Map.Entry entry : BaseObjectPool.this.keyedObjectPool.entrySet()) {
                    Object object;
                    Object key = entry.getKey();
                    QueuePool pool = (QueuePool)entry.getValue();
                    if (pool.destroyed.get()) continue;
                    while (!pool.destroyed.get() && BaseObjectPool.this.min < pool.poolSizeHint.get() && (object = pool.queue.poll()) != null) {
                        try {
                            BaseObjectPool.this.factory.destroyObject(key, object);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        pool.poolSizeHint.decrementAndGet();
                    }
                }
            }
            finally {
                this.running.set(false);
            }
        }
    }

    private static class QueuePool<V> {
        private final AtomicInteger poolSizeHint = new AtomicInteger();
        private volatile int peakSizeHint = 0;
        private final BlockingQueue<V> queue;
        private final AtomicBoolean destroyed = new AtomicBoolean();

        private QueuePool(int max) {
            if (max <= 0 || max == Integer.MAX_VALUE) {
                throw new RuntimeException("QueuePool num invalide");
            }
            this.queue = new LinkedBlockingQueue<V>(max);
        }
    }
}

