/*
 * Decompiled with CFR 0.152.
 */
package net.csdn.modules.http;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.csdn.ServiceFramwork;
import net.csdn.annotation.NoTransaction;
import net.csdn.common.collect.Tuple;
import net.csdn.common.env.Environment;
import net.csdn.common.exception.ExceptionHandler;
import net.csdn.common.logging.CSLogger;
import net.csdn.common.logging.Loggers;
import net.csdn.common.settings.Settings;
import net.csdn.http.server.JettyServer;
import net.csdn.jpa.JPA;
import net.csdn.modules.controller.API;
import net.csdn.modules.http.ApplicationController;
import net.csdn.modules.http.DefaultResponse;
import net.csdn.modules.http.DefaultRestRequest;
import net.csdn.modules.http.PortGenerator;
import net.csdn.modules.http.RestController;
import net.csdn.modules.http.processor.HttpFinishProcessor;
import net.csdn.modules.http.processor.HttpStartProcessor;
import net.csdn.modules.http.processor.ProcessInfo;
import net.csdn.modules.http.processor.impl.DefaultHttpFinishProcessor;
import net.csdn.modules.http.processor.impl.DefaultHttpStartProcessor;
import net.csdn.modules.http.support.HttpHolder;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.handler.AbstractHandler;

@Singleton
public class HttpServer {
    private final Server server;
    private CSLogger logger = Loggers.getLogger(this.getClass());
    private RestController restController;
    private boolean disableMysql = false;
    private Settings settings;
    private API api;
    private final int httpPort;
    private List<HttpStartProcessor> httpStartProcessorList = new ArrayList<HttpStartProcessor>();
    private List<HttpFinishProcessor> httpFinishProcessorList = new ArrayList<HttpFinishProcessor>();
    private static ThreadLocal<HttpHolder> httpHolder = new ThreadLocal();

    public static void setHttpHolder(HttpHolder value) {
        httpHolder.set(value);
    }

    public static void removeHttpHolder() {
        httpHolder.remove();
    }

    public static HttpHolder httpHolder() {
        return httpHolder.get();
    }

    @Inject
    public HttpServer(Settings settings, RestController restController, API api) {
        this.settings = settings;
        this.restController = restController;
        this.api = api;
        this.registerHttpStartProcessor(new DefaultHttpStartProcessor());
        this.registerHttpFinishProcessor(new DefaultHttpFinishProcessor());
        Environment environment = new Environment(settings);
        this.disableMysql = settings.getAsBoolean((Object)((Object)ServiceFramwork.mode) + ".datasources.mysql.disable", Boolean.valueOf(false));
        JettyServer jettyServer = new JettyServer();
        this.httpPort = settings.getAsInt("http.port", Integer.valueOf(this.generateHttpPort()));
        this.server = jettyServer.createServer(settings.getAsInt("http.threads.min", Integer.valueOf(100)).intValue(), settings.getAsInt("http.threads.max", Integer.valueOf(1000)).intValue());
        ServerConnector connector = jettyServer.createConnector(this.server, settings.get("http.host", ""), this.httpPort);
        connector.setIdleTimeout((long)settings.getAsInt("http.server.idleTimeout", Integer.valueOf(30000)).intValue());
        this.server.addConnector((Connector)connector);
        jettyServer.connfigureServer(this.server, settings.get("serviceframework.static.loader.classpath.dir", "assets"), environment.templateDirFile().getPath(), settings.getAsBoolean("application.static.enable", Boolean.valueOf(false)).booleanValue(), settings.getAsBoolean("serviceframework.static.loader.classpath.enable", Boolean.valueOf(false)).booleanValue(), settings.getAsBoolean("application.session.enable", Boolean.valueOf(false)).booleanValue(), (AbstractHandler)new DefaultHandler());
    }

    public void registerHttpStartProcessor(HttpStartProcessor httpStartProcessor) {
        this.httpStartProcessorList.add(httpStartProcessor);
    }

    public void registerHttpFinishProcessor(HttpFinishProcessor httpFinishProcessor) {
        this.httpFinishProcessorList.add(httpFinishProcessor);
    }

    private int generateHttpPort() {
        String clzz = this.settings.get("http.class.port", "");
        if (!clzz.isEmpty()) {
            PortGenerator pg = null;
            try {
                pg = (PortGenerator)Class.forName(clzz).newInstance();
                return pg.getPort();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return 8080;
    }

    public int getHttpPort() {
        return this.httpPort;
    }

    public void start() {
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    HttpServer.this.server.start();
                    HttpServer.this.server.join();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }).start();
    }

    public void close() {
        try {
            this.server.stop();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void join() {
        try {
            this.server.join();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    class DefaultHandler
    extends AbstractHandler {
        DefaultHandler() {
        }

        private void rollback(Method action) {
            if (!HttpServer.this.disableMysql && action != null && action.getAnnotation(NoTransaction.class) == null) {
                try {
                    JPA.getJPAConfig().getJPAContext().closeTx(true);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        private void defaultErrorAction(DefaultResponse channel, Exception e) {
            if (HttpServer.this.restController.errorHandlerKey() != null) {
                ApplicationController errorApplicationController = (ApplicationController)ServiceFramwork.injector.getInstance((Class)HttpServer.this.restController.errorHandlerKey().v1());
                try {
                    RestController.enhanceApplicationController(errorApplicationController, HttpServer.httpHolder().restRequest(), channel);
                    try {
                        ((Method)HttpServer.this.restController.errorHandlerKey().v2()).invoke((Object)errorApplicationController, e);
                    }
                    catch (Exception e2) {
                        ExceptionHandler.renderHandle((Exception)e2);
                        channel.send();
                    }
                }
                catch (Exception e1) {
                    HttpServer.this.logger.error("System processing error", (Throwable)e1, new Object[0]);
                }
            } else {
                try {
                    channel.error(e);
                }
                catch (IOException e1) {
                    HttpServer.this.logger.error("System processing error", (Throwable)e1, new Object[0]);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handle(String s, Request request, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException, ServletException {
            DefaultResponse channel = new DefaultResponse(httpServletRequest, httpServletResponse, HttpServer.this.restController);
            ProcessInfo processInfo = new ProcessInfo();
            try {
                DefaultRestRequest restRequest = new DefaultRestRequest(httpServletRequest);
                HttpServer.setHttpHolder(new HttpHolder(restRequest, channel));
                Tuple<Class<ApplicationController>, Method> tuple = HttpServer.this.restController.getHandler(restRequest);
                if (tuple != null) {
                    processInfo.method = (Method)tuple.v2();
                }
                for (HttpStartProcessor httpStartProcessor : HttpServer.this.httpStartProcessorList) {
                    httpStartProcessor.process(HttpServer.this.settings, httpServletRequest, httpServletResponse, processInfo);
                }
                try {
                    HttpServer.this.restController.dispatchRequest(restRequest, channel);
                }
                catch (Exception e) {
                    ExceptionHandler.renderHandle((Exception)e);
                }
                channel.send();
            }
            catch (Exception e) {
                if (!"qps-overflow".equals(e.getMessage())) {
                    HttpServer.this.logger.error("System processing error", (Throwable)e, new Object[0]);
                }
                this.rollback(processInfo.method);
                this.defaultErrorAction(channel, e);
            }
            finally {
                processInfo.status = channel.status();
                if (channel.content() != null) {
                    processInfo.responseLength = channel.content().length();
                }
                for (HttpFinishProcessor httpFinishProcessor : HttpServer.this.httpFinishProcessorList) {
                    httpFinishProcessor.process(HttpServer.this.settings, httpServletRequest, httpServletResponse, processInfo);
                }
                HttpServer.removeHttpHolder();
            }
        }
    }
}

