/*
 * Decompiled with CFR 0.152.
 */
package net.csdn.bootstrap.loader.impl;

import com.google.inject.AbstractModule;
import com.google.inject.Guice;
import com.google.inject.Module;
import com.google.inject.Stage;
import java.io.DataInputStream;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import javassist.CtClass;
import net.csdn.ServiceFramwork;
import net.csdn.annotation.rest.At;
import net.csdn.annotation.rest.ErrorAction;
import net.csdn.annotation.rest.NoAction;
import net.csdn.bootstrap.loader.Loader;
import net.csdn.common.collect.Tuple;
import net.csdn.common.collections.WowCollections;
import net.csdn.common.logging.CSLogger;
import net.csdn.common.logging.Loggers;
import net.csdn.common.scan.ScanService;
import net.csdn.common.settings.Settings;
import net.csdn.enhancer.ControllerEnhancer;
import net.csdn.filter.FilterEnhancer;
import net.csdn.modules.controller.API;
import net.csdn.modules.http.ApplicationController;
import net.csdn.modules.http.RestController;
import net.csdn.modules.http.RestRequest;

public class ControllerLoader
implements Loader {
    private static final CSLogger logger = Loggers.getLogger(ControllerLoader.class);

    @Override
    public void load(Settings settings) throws Exception {
        ServiceFramwork.injector = Guice.createInjector((Stage)Stage.PRODUCTION, ServiceFramwork.AllModules);
        ArrayList<Module> moduleList = new ArrayList<Module>();
        final List controllers = WowCollections.list((Object[])new CtClass[0]);
        final FilterEnhancer enhancer = new FilterEnhancer(settings);
        for (String item : WowCollections.split2((String)settings.get("application.controller"), (String)",")) {
            ServiceFramwork.scanService.scanArchives(item, new ScanService.LoadClassEnhanceCallBack(){

                public Class loaded(DataInputStream classFile) {
                    try {
                        CtClass ctClass = enhancer.enhanceThisClass(classFile);
                        if (ctClass != null) {
                            logger.info("controller load :    " + ctClass.getName(), new Object[0]);
                            controllers.add(ctClass);
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    return null;
                }
            });
        }
        ((ControllerEnhancer)enhancer).enhanceThisClass2(controllers);
        for (String item : WowCollections.split2((String)settings.get("application.controller.default", "net.csdn.api.controller.SystemInfoController,net.csdn.api.controller.APIDescController"), (String)",")) {
            try {
                moduleList.add(ControllerLoader.bindAction(Class.forName(item)));
            }
            catch (Exception e) {
                logger.error("load default controller error:" + e, new Object[0]);
            }
        }
        for (String ctName : WowCollections.split2((String)settings.get("application.controllerNames"), (String)",")) {
            Class<?> ctClzz = Class.forName(ctName);
            if (Modifier.isAbstract(ctClzz.getModifiers())) continue;
            moduleList.add(ControllerLoader.bindAction(ctClzz));
        }
        for (CtClass ctClass : controllers) {
            if (Modifier.isAbstract(ctClass.getModifiers())) continue;
            moduleList.add(ControllerLoader.bindAction(Class.forName(ctClass.getName())));
        }
        ServiceFramwork.injector = ServiceFramwork.injector.createChildInjector(moduleList);
    }

    private static Module bindAction(final Class clzz) {
        return new AbstractModule(){

            protected void configure() {
                if (clzz == null) {
                    return;
                }
                try {
                    Method[] methods;
                    boolean isController = false;
                    Class wow = clzz;
                    while (wow.getSuperclass() != null) {
                        if (wow.getSuperclass() == ApplicationController.class) {
                            isController = true;
                            break;
                        }
                        wow = wow.getSuperclass();
                    }
                    if (!isController) {
                        return;
                    }
                    for (Method method : methods = clzz.getDeclaredMethods()) {
                        RestRequest.Method[] httpMethods;
                        At at;
                        ErrorAction errorAction;
                        if (method.getModifiers() == 2) continue;
                        RestController restController = (RestController)ServiceFramwork.injector.getInstance(RestController.class);
                        API api = (API)ServiceFramwork.injector.getInstance(API.class);
                        NoAction noAction = method.getAnnotation(NoAction.class);
                        if (noAction != null) {
                            if (restController.defaultHandlerKey() != null) {
                                throw new RuntimeException("Only one default action can be defined. current is " + method.getName());
                            }
                            restController.setDefaultHandlerKey((Tuple<Class<ApplicationController>, Method>)new Tuple((Object)clzz, (Object)method));
                        }
                        if ((errorAction = method.getAnnotation(ErrorAction.class)) != null) {
                            if (restController.errorHandlerKey() != null) {
                                throw new RuntimeException("Only one error action can be defined. current is " + method.getName());
                            }
                            restController.setErrorHandlerKey((Tuple<Class<ApplicationController>, Method>)new Tuple((Object)clzz, (Object)method));
                        }
                        if ((at = method.getAnnotation(At.class)) == null) continue;
                        String url = at.path()[0];
                        for (RestRequest.Method httpMethod : httpMethods = at.types()) {
                            Tuple tuple = new Tuple((Object)clzz, (Object)method);
                            restController.registerHandler(httpMethod, url, (Tuple<Class<ApplicationController>, Method>)tuple);
                            api.addPath((Method)tuple.v2());
                        }
                        this.bind(clzz);
                    }
                }
                catch (Exception e) {
                    logger.error("System initialize error", (Throwable)e, new Object[0]);
                }
            }
        };
    }
}

