/*
 * Decompiled with CFR 0.152.
 */
package net.csdn.jpa.model;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.persistence.metamodel.Attribute;
import javax.persistence.metamodel.EntityType;
import javax.persistence.metamodel.Metamodel;
import net.csdn.common.collections.WowCollections;
import net.csdn.common.logging.CSLogger;
import net.csdn.common.logging.Loggers;
import net.csdn.common.param.ParamBinding;
import net.csdn.jpa.JPA;
import net.csdn.jpa.context.JPAContext;
import net.csdn.jpa.hql.WowCommonParser;
import net.csdn.jpa.hql.WowJoinParser;
import net.csdn.jpa.hql.WowSelectParser;
import net.csdn.jpa.hql.WowWhereParser;
import net.csdn.jpa.model.JPABase;
import net.csdn.jpa.model.Model;
import org.apache.commons.lang.StringUtils;
import tech.mlsql.common.utils.collect.Maps;

public class JPQL {
    private CSLogger logger = Loggers.getLogger(this.getClass());
    private JPAContext jpaContext;
    private String sql = "";
    private String where = "";
    private String select = "";
    private String joins = "";
    private String order = "";
    private String group = "";
    private int limit = -1;
    private int offset = 0;
    private Map<String, Object> bindings = new HashMap<String, Object>();
    private static String EMPTY_STRING = " ";
    private String entity = "";
    private String defaultName = "";
    private Set<String> columns;
    private static String SQL_PARAM_PREFIX = "SF_";

    public JPQL(JPAContext jpaContext) {
        this.jpaContext = jpaContext;
    }

    public JPQL(JPAContext jpaContext, String entity) {
        this.jpaContext = jpaContext;
        this.entity = entity;
        this.defaultName = entity.toLowerCase();
        this.columns = this.getColumns();
    }

    public EntityManager em() {
        if (this.jpaContext.em() != null && this.jpaContext.em().isOpen()) {
            return this.jpaContext.em();
        }
        this.jpaContext = JPA.getJPAConfig().getJPAContext();
        return this.jpaContext.em();
    }

    public Model find(Integer id) {
        List list = this.where("id=" + id).fetch();
        if (list.size() == 0) {
            return null;
        }
        return (Model)list.get(0);
    }

    public List<Model> find(List ids) {
        String in_ids = WowCollections.join((Collection)ids, (String)",", (String)"'");
        List list = this.where("id in (" + in_ids + ")").fetch();
        return list;
    }

    public JPQL where(String condition, Map params) {
        this.where(condition);
        this.bindings.putAll(params);
        return this;
    }

    public JPQL where(String condition) {
        this.where = (StringUtils.isEmpty((String)this.where) ? "where" : this.where + " and ") + EMPTY_STRING + "(" + this.parseWhere(condition) + ")";
        return this;
    }

    public JPQL where(Map whereQuery) {
        List con = WowCollections.list((Object[])new Object[0]);
        for (Object key : whereQuery.keySet()) {
            con.add(key + "=:" + key);
        }
        this.where(WowCollections.join((Collection)con, (String)" AND "), whereQuery);
        return this;
    }

    public JPQL in(String fieldName, Map bindings) {
        List con = WowCollections.list((Object[])new Object[0]);
        for (Object key : bindings.keySet()) {
            con.add(fieldName + " in (:" + key + ")");
        }
        this.where(WowCollections.join((Collection)con, (String)" AND "), bindings);
        return this;
    }

    public JPQL in(String fieldName, List params) {
        List con = WowCollections.list((Object[])new Object[0]);
        HashMap bindings = Maps.newHashMap();
        con.add(fieldName + " in (:" + SQL_PARAM_PREFIX + fieldName + ")");
        bindings.put(SQL_PARAM_PREFIX + fieldName, params);
        this.where(WowCollections.join((Collection)con, (String)" AND "), bindings);
        return this;
    }

    public JPQL group(String group) {
        this.group = group.startsWith("group") ? this.parse(group) : "group by " + this.parse(group);
        return this;
    }

    public JPQL from(String modelAndAlias) {
        String[] modelAndAliasArray = (modelAndAlias = modelAndAlias.trim()).split("\\s+");
        if (modelAndAliasArray.length == 1) {
            this.defaultName = this.entity.toLowerCase();
            this.entity = modelAndAlias;
        } else {
            this.defaultName = modelAndAliasArray[1];
            this.entity = modelAndAliasArray[0];
        }
        return this;
    }

    private String parseWhere(String condition) {
        WowWhereParser wowWhereParser = new WowWhereParser(this.columns, this.defaultName);
        wowWhereParser.parse(condition);
        return wowWhereParser.toHql();
    }

    private String parseSelect(String condition) {
        WowSelectParser wowSelectParser = new WowSelectParser(this.columns, this.defaultName);
        wowSelectParser.parse(condition);
        return wowSelectParser.toHql();
    }

    private String parse(String wow) {
        WowCommonParser commonParser = new WowCommonParser(this.columns, this.defaultName);
        commonParser.parse(wow);
        return commonParser.toHql();
    }

    private String parseJoin(String joins) {
        WowJoinParser wowJoinParser = new WowJoinParser(this.columns, this.defaultName);
        wowJoinParser.parse(joins);
        return wowJoinParser.toHql();
    }

    private Set<String> getColumns() {
        Metamodel metamodel = this.em().getMetamodel();
        Iterator entities = metamodel.getEntities().iterator();
        HashSet<String> columns = new HashSet<String>();
        while (entities.hasNext()) {
            EntityType entityType = (EntityType)entities.next();
            if (!this.entity.equals(entityType.getName())) continue;
            try {
                Set attributes = entityType.getAttributes();
                for (Attribute attribute : attributes) {
                    columns.add(attribute.getName());
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return columns;
    }

    public JPQL select(String select) {
        if (WowCollections.isEmpty((String)select)) {
            this.select = "";
            return this;
        }
        this.select = this.parseSelect(select);
        return this;
    }

    public JPQL joins(String joins) {
        this.joins = joins.contains("join") ? this.parseJoin(joins) : " inner join fetch " + this.parseJoin(joins);
        return this;
    }

    public JPQL order(String order) {
        if (WowCollections.isEmpty((String)order)) {
            this.order = "";
            return this;
        }
        this.order = "order by " + EMPTY_STRING + this.parse(order);
        return this;
    }

    public JPQL limit(int limit) {
        this.limit = limit;
        return this;
    }

    public JPQL offset(int offset) {
        this.offset = offset;
        return this;
    }

    public Long countFetch(String countString) {
        return this.count_fetch();
    }

    public Long count_fetch(String countString) {
        this.sql = this.parseSelect(countString) + EMPTY_STRING + "from" + EMPTY_STRING + this.entity + " as " + this.defaultName + EMPTY_STRING + this.joins + EMPTY_STRING + this.where + EMPTY_STRING + this.group + EMPTY_STRING + this.order + EMPTY_STRING;
        Query query = this.em().createQuery(this.sql);
        for (String obj : this.bindings.keySet()) {
            query.setParameter(obj, this.bindings.get(obj));
        }
        return Long.parseLong(query.getSingleResult().toString());
    }

    public Long count_fetch() {
        return this.count_fetch("count(*)");
    }

    public <T> T single_fetch() {
        List list;
        this.sql = this.select + EMPTY_STRING + "from" + EMPTY_STRING + this.entity + " as " + this.defaultName + EMPTY_STRING + this.joins + EMPTY_STRING + this.where + EMPTY_STRING + this.group + EMPTY_STRING + this.order + EMPTY_STRING;
        Query query = this.em().createQuery(this.sql);
        for (String obj : this.bindings.keySet()) {
            query.setParameter(obj, this.bindings.get(obj));
        }
        query.setFirstResult(this.offset);
        if (this.limit != -1) {
            query.setMaxResults(this.limit);
        }
        if ((list = query.getResultList()).size() == 0) {
            return null;
        }
        return (T)list.get(0);
    }

    public <T> T singleFetch() {
        return this.single_fetch();
    }

    public List fetch() {
        this.sql = this.select + EMPTY_STRING + "from" + EMPTY_STRING + this.entity + " as " + this.defaultName + EMPTY_STRING + this.joins + EMPTY_STRING + this.where + EMPTY_STRING + this.group + EMPTY_STRING + this.order + EMPTY_STRING;
        Query query = this.em().createQuery(this.sql);
        for (String obj : this.bindings.keySet()) {
            query.setParameter(obj, this.bindings.get(obj));
        }
        query.setFirstResult(this.offset);
        if (this.limit != -1) {
            query.setMaxResults(this.limit);
        }
        return query.getResultList();
    }

    public long count(String entity) {
        return Long.parseLong(this.em().createQuery("select count(*) from " + entity + " e").getSingleResult().toString());
    }

    public long count(String entity, String query, Object[] params) {
        return Long.parseLong(this.bindParameters(this.em().createQuery(this.createCountQuery(entity, entity, query, params)), params).getSingleResult().toString());
    }

    public List findAll(String entity) {
        return this.em().createQuery("select e from " + entity + " e").getResultList();
    }

    public JPABase findById(Class clzz, Object id) throws Exception {
        JPABase model = (JPABase)this.em().find(clzz, id);
        return model;
    }

    public List findBy(String entity, String query, Object[] params) {
        Query q = this.em().createQuery(this.createFindByQuery(entity, entity, query, params));
        return this.bindParameters(q, params).getResultList();
    }

    public Model.JPAQuery find(String entity, String query, Object[] params) {
        Query q = this.em().createQuery(this.createFindByQuery(entity, entity, query, params));
        return new Model.JPAQuery(this.createFindByQuery(entity, entity, query, params), this.bindParameters(q, params));
    }

    public Model.JPAQuery find(String entity) {
        Query q = this.em().createQuery(this.createFindByQuery(entity, entity, null, new Object[0]));
        return new Model.JPAQuery(this.createFindByQuery(entity, entity, null, new Object[0]), this.bindParameters(q, new Object[0]));
    }

    public Model.JPAQuery all(String entity) {
        Query q = this.em().createQuery(this.createFindByQuery(entity, entity, null, new Object[0]));
        return new Model.JPAQuery(this.createFindByQuery(entity, entity, null, new Object[0]), this.bindParameters(q, new Object[0]));
    }

    public int delete(String entity, String query, Object[] params) {
        Query q = this.em().createQuery(this.createDeleteQuery(entity, entity, query, params));
        return this.bindParameters(q, params).executeUpdate();
    }

    public int deleteAll(String entity) {
        Query q = this.em().createQuery(this.createDeleteQuery(entity, entity, null, new Object[0]));
        return this.bindParameters(q, new Object[0]).executeUpdate();
    }

    public JPABase findOneBy(String entity, String query, Object[] params) {
        Query q = this.em().createQuery(this.createFindByQuery(entity, entity, query, params));
        List results = this.bindParameters(q, params).getResultList();
        if (results.size() == 0) {
            return null;
        }
        return (JPABase)results.get(0);
    }

    public JPABase create(Class clzz, Map<String, Object> params) throws Exception {
        Object o = clzz.newInstance();
        ParamBinding paramBinding = new ParamBinding();
        paramBinding.parse(params);
        paramBinding.toModel(o);
        return (Model)o;
    }

    public String createFindByQuery(String entityName, String entityClass, String query, Object ... params) {
        if (query == null || query.trim().length() == 0) {
            return "from " + entityName;
        }
        if (query.matches("^by[A-Z].*$")) {
            return "from " + entityName + " where " + this.findByToJPQL(query);
        }
        if (query.trim().toLowerCase().startsWith("select ")) {
            return query;
        }
        if (query.trim().toLowerCase().startsWith("from ")) {
            return query;
        }
        if (query.trim().toLowerCase().startsWith("order by ")) {
            return "from " + entityName + " " + query;
        }
        if (query.trim().indexOf(32) == -1 && query.trim().indexOf(61) == -1 && params != null && params.length == 1) {
            query = query + " = ?1";
        }
        if (query.trim().indexOf(32) == -1 && query.trim().indexOf(61) == -1 && params == null) {
            query = query + " = null";
        }
        return "from " + entityName + " where " + query;
    }

    public String createDeleteQuery(String entityName, String entityClass, String query, Object ... params) {
        if (query == null) {
            return "delete from " + entityName;
        }
        if (query.trim().toLowerCase().startsWith("delete ")) {
            return query;
        }
        if (query.trim().toLowerCase().startsWith("from ")) {
            return "delete " + query;
        }
        if (query.trim().indexOf(32) == -1 && query.trim().indexOf(61) == -1 && params != null && params.length == 1) {
            query = query + " = ?1";
        }
        if (query.trim().indexOf(32) == -1 && query.trim().indexOf(61) == -1 && params == null) {
            query = query + " = null";
        }
        return "delete from " + entityName + " where " + query;
    }

    public String createCountQuery(String entityName, String entityClass, String query, Object ... params) {
        if (query.trim().toLowerCase().startsWith("select ")) {
            return query;
        }
        if (query.matches("^by[A-Z].*$")) {
            return "select count(*) from " + entityName + " where " + this.findByToJPQL(query);
        }
        if (query.trim().toLowerCase().startsWith("from ")) {
            return "select count(*) " + query;
        }
        if (query.trim().toLowerCase().startsWith("order by ")) {
            return "select count(*) from " + entityName;
        }
        if (query.trim().indexOf(32) == -1 && query.trim().indexOf(61) == -1 && params != null && params.length == 1) {
            query = query + " = ?1";
        }
        if (query.trim().indexOf(32) == -1 && query.trim().indexOf(61) == -1 && params == null) {
            query = query + " = null";
        }
        if (query.trim().length() == 0) {
            return "select count(*) from " + entityName;
        }
        return "select count(*) from " + entityName + " e where " + query;
    }

    public Query bindParameters(Query q, Object ... params) {
        if (params == null) {
            return q;
        }
        if (params.length == 1 && params[0] instanceof Map) {
            return this.bindParameters(q, (Map)params[0]);
        }
        for (int i = 0; i < params.length; ++i) {
            q.setParameter(i + 1, params[i]);
        }
        return q;
    }

    public Query bindParameters(Query q, Map<String, Object> params) {
        if (params == null) {
            return q;
        }
        for (String key : params.keySet()) {
            q.setParameter(key, params.get(key));
        }
        return q;
    }

    public String findByToJPQL(String findBy) {
        findBy = findBy.substring(2);
        StringBuilder jpql = new StringBuilder();
        String subRequest = findBy.contains("OrderBy") ? findBy.split("OrderBy")[0] : findBy;
        String[] parts = subRequest.split("And");
        int index = 1;
        for (int i = 0; i < parts.length; ++i) {
            String prop;
            String part = parts[i];
            if (part.endsWith("NotEqual")) {
                prop = JPQL.extractProp(part, "NotEqual");
                jpql.append(prop).append(" <> ?").append(index++);
            } else if (part.endsWith("Equal")) {
                prop = JPQL.extractProp(part, "Equal");
                jpql.append(prop).append(" = ?").append(index++);
            } else if (part.endsWith("IsNotNull")) {
                prop = JPQL.extractProp(part, "IsNotNull");
                jpql.append(prop).append(" is not null");
            } else if (part.endsWith("IsNull")) {
                prop = JPQL.extractProp(part, "IsNull");
                jpql.append(prop).append(" is null");
            } else if (part.endsWith("LessThan")) {
                prop = JPQL.extractProp(part, "LessThan");
                jpql.append(prop).append(" < ?").append(index++);
            } else if (part.endsWith("LessThanEquals")) {
                prop = JPQL.extractProp(part, "LessThanEquals");
                jpql.append(prop).append(" <= ?").append(index++);
            } else if (part.endsWith("GreaterThan")) {
                prop = JPQL.extractProp(part, "GreaterThan");
                jpql.append(prop).append(" > ?").append(index++);
            } else if (part.endsWith("GreaterThanEquals")) {
                prop = JPQL.extractProp(part, "GreaterThanEquals");
                jpql.append(prop).append(" >= ?").append(index++);
            } else if (part.endsWith("Between")) {
                prop = JPQL.extractProp(part, "Between");
                jpql.append(prop).append(" < ?").append(index++).append(" AND ").append(prop).append(" > ?").append(index++);
            } else if (part.endsWith("Like")) {
                prop = JPQL.extractProp(part, "Like");
                jpql.append("LOWER(").append(prop).append(") like ?").append(index++);
            } else if (part.endsWith("Ilike")) {
                prop = JPQL.extractProp(part, "Ilike");
                jpql.append("LOWER(").append(prop).append(") like LOWER(?").append(index++).append(")");
            } else if (part.endsWith("Elike")) {
                prop = JPQL.extractProp(part, "Elike");
                jpql.append(prop).append(" like ?").append(index++);
            } else {
                prop = JPQL.extractProp(part, "");
                jpql.append(prop).append(" = ?").append(index++);
            }
            if (i >= parts.length - 1) continue;
            jpql.append(" AND ");
        }
        if (findBy.contains("OrderBy")) {
            jpql.append(" ORDER BY ");
            String orderQuery = findBy.split("OrderBy")[1];
            parts = orderQuery.split("And");
            for (int i = 0; i < parts.length; ++i) {
                String part = parts[i];
                String orderProp = part.endsWith("Desc") ? JPQL.extractProp(part, "Desc") + " DESC" : part.toLowerCase();
                if (i > 0) {
                    jpql.append(", ");
                }
                jpql.append(orderProp);
            }
        }
        return jpql.toString();
    }

    protected static String extractProp(String part, String end) {
        String prop = part.substring(0, part.length() - end.length());
        prop = (prop.charAt(0) + "").toLowerCase() + prop.substring(1);
        return prop;
    }
}

