/*
 * Decompiled with CFR 0.152.
 */
package net.csdn.jpa.enhancer;

import java.io.DataInputStream;
import java.io.InputStream;
import java.util.HashSet;
import java.util.List;
import javassist.CtClass;
import net.csdn.common.collections.WowCollections;
import net.csdn.common.settings.Settings;
import net.csdn.enhancer.ActiveORMEnhancer;
import net.csdn.jpa.enhancer.AssociationEnhancer;
import net.csdn.jpa.enhancer.ClassMethodEnhancer;
import net.csdn.jpa.enhancer.EntityEnhancer;
import net.csdn.jpa.enhancer.ModelClass;
import tech.mlsql.common.utils.collect.Lists;

public class JPAEnhancer
extends ActiveORMEnhancer {
    private Settings settings;

    public JPAEnhancer(Settings settings) {
        this.settings = settings;
    }

    @Override
    public CtClass enhanceThisClass(DataInputStream dataInputStream) throws Exception {
        CtClass ctClass = this.classPool.makeClassIfNew((InputStream)dataInputStream);
        if (!ctClass.subtypeOf(this.classPool.get("net.csdn.jpa.model.Model"))) {
            return ctClass;
        }
        return ctClass;
    }

    private void buildModelClassTree(List<ModelClass> modelClasses) throws Exception {
        for (ModelClass modelClass : modelClasses) {
            if (!modelClass.originClass.getSuperclass().getName().equals("net.csdn.jpa.model.Model")) continue;
            ModelClass.ROOTS.add(modelClass);
            this.buildRelationship(modelClasses, modelClass);
        }
    }

    private void buildRelationship(List<ModelClass> modelClasses, ModelClass modelClass) {
        for (ModelClass temp : modelClasses) {
            if (!temp.originClass.subclassOf(modelClass.originClass) || temp.originClass == modelClass.originClass) continue;
            modelClass.addChild(temp);
            temp.parent(modelClass);
            this.buildRelationship(modelClasses, temp);
        }
    }

    @Override
    public List<ModelClass> enhanceThisClass2(List<CtClass> ctClasses) throws Exception {
        List modelClasses = WowCollections.list((Object[])new ModelClass[0]);
        for (CtClass ct : ctClasses) {
            ModelClass modelClass = new ModelClass(ct);
            modelClasses.add(modelClass);
            ModelClass.CTModelClasses.put(ct, modelClass);
        }
        this.buildModelClassTree(modelClasses);
        HashSet<ModelClass> result = new HashSet<ModelClass>();
        for (ModelClass modelClass : ModelClass.ROOTS) {
            if (modelClass.isLeafNode()) {
                result.add(modelClass);
                continue;
            }
            result.addAll(modelClass.findLeafNodes());
        }
        new EntityEnhancer(this.settings).enhance(ModelClass.ROOTS);
        new ClassMethodEnhancer(this.settings).enhance(Lists.newArrayList(result));
        new AssociationEnhancer(this.settings).enhance(Lists.newArrayList(result));
        return ModelClass.ROOTS;
    }
}

