/*
 * Decompiled with CFR 0.152.
 */
package net.csdn.modules.persist.mysql;

import com.alibaba.druid.pool.DruidDataSource;
import com.alibaba.druid.pool.DruidDataSourceFactory;
import com.google.inject.Inject;
import java.util.HashMap;
import java.util.Map;
import javax.sql.DataSource;
import net.csdn.common.logging.CSLogger;
import net.csdn.common.logging.Loggers;
import net.csdn.common.settings.Settings;
import net.csdn.jpa.JPA;

public class DataSourceManager {
    private Map<String, DataSource> dataSourceMap;
    private Settings settings;
    private CSLogger logger = Loggers.getLogger(DataSourceManager.class);

    @Inject
    public DataSourceManager(Settings _settings) {
        this.settings = _settings;
        this.dataSourceMap = this.buildDataSourceMap();
    }

    public DataSource datasource(String name) {
        return this.dataSourceMap.get(name);
    }

    public Map<String, DataSource> dataSourceMap() {
        return this.dataSourceMap;
    }

    private Map<String, DataSource> buildDataSourceMap() {
        HashMap<String, DataSource> tempDataSourceMap = new HashMap<String, DataSource>();
        Map groups = this.settings.getGroups(JPA.mode() + ".datasources");
        for (Map.Entry group : groups.entrySet()) {
            if (((String)group.getKey()).equals("mysql")) {
                tempDataSourceMap.put((String)group.getKey(), this.buildPool((Settings)group.getValue()));
                continue;
            }
            if (!((String)group.getKey()).equals("multi-mysql")) continue;
            Map mysqlGroups = this.settings.getGroups(JPA.mode() + ".datasources.multi-mysql");
            for (Map.Entry temp : mysqlGroups.entrySet()) {
                tempDataSourceMap.put((String)temp.getKey(), this.buildPool((Settings)temp.getValue()));
            }
        }
        return tempDataSourceMap;
    }

    private DataSource buildPool(Settings mysqlSetting) {
        try {
            DruidDataSource dataSource = (DruidDataSource)DruidDataSourceFactory.createDataSource(JPA.properties(mysqlSetting));
            return dataSource;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("can not create datasource");
        }
    }
}

