/*
 * Decompiled with CFR 0.152.
 */
package net.csdn.jpa.context;

import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import net.csdn.jpa.context.JPAContext;

public class JPAConfig {
    private final String configName;
    private EntityManagerFactory entityManagerFactory = null;
    private ThreadLocal<JPAContext> local = new ThreadLocal();

    public JPAConfig(Map<String, String> _properties, String _configName) {
        this.configName = _configName;
        this.entityManagerFactory = Persistence.createEntityManagerFactory((String)this.configName, _properties);
    }

    public String getConfigName() {
        return this.configName;
    }

    protected void close() {
        if (this.isEnabled()) {
            try {
                this.entityManagerFactory.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.entityManagerFactory = null;
        }
    }

    public boolean isEnabled() {
        return this.entityManagerFactory != null;
    }

    public EntityManager newEntityManager() {
        return this.entityManagerFactory.createEntityManager();
    }

    public JPAContext getJPAContext() {
        JPAContext context = this.local.get();
        if (context == null) {
            context = new JPAContext(this);
            this.local.set(context);
        }
        return context;
    }

    public JPAContext reInitJPAContext() {
        JPAContext oldContext = this.local.get();
        this.local.set(new JPAContext(this));
        return oldContext;
    }

    protected void clearJPAContext() {
        JPAContext context = this.local.get();
        if (context != null) {
            try {
                context.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.local.remove();
        }
    }
}

