/*
 * Decompiled with CFR 0.152.
 */
package net.csdn.modules.persist.mysql;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;

public class SqlClient {
    private DataSource dataSource = null;

    public SqlClient(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public DataSource dataSource() {
        return this.dataSource;
    }

    private Connection getConnection() throws SQLException {
        return this.dataSource.getConnection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(String sql, Object ... params) throws SQLException {
        Connection conn = null;
        Statement preparedStatement = null;
        try {
            conn = this.getConnection();
            preparedStatement = this.preparedStatement(conn, sql, false);
            if (params.length > 0) {
                SqlClient.setParams((PreparedStatement)preparedStatement, params);
            }
            preparedStatement.execute();
        }
        finally {
            try {
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException sQLException) {}
        }
    }

    private PreparedStatement preparedStatement(Connection conn, String sql, boolean streaming) throws SQLException {
        if (streaming) {
            PreparedStatement preparedStatement = conn.prepareStatement(sql, 1003, 1007);
            preparedStatement.setFetchSize(1000);
        }
        return conn.prepareStatement(sql);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeStreaming(String sql, Object ... params) throws SQLException {
        Connection conn = null;
        Statement preparedStatement = null;
        try {
            conn = this.getConnection();
            preparedStatement = this.preparedStatement(conn, sql, true);
            if (params.length > 0) {
                SqlClient.setParams((PreparedStatement)preparedStatement, params);
            }
            preparedStatement.execute();
        }
        finally {
            try {
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException sQLException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeBatch(String sql, BatchSqlCallback callback) throws SQLException {
        Connection conn = null;
        PreparedStatement preparedStatement = null;
        long time1 = System.currentTimeMillis();
        try {
            conn = this.getConnection();
            preparedStatement = conn.prepareStatement(sql);
            callback.execute(preparedStatement);
            preparedStatement.executeBatch();
        }
        finally {
            try {
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException sQLException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T executeQuery(String sql, SqlCallback<T> callback, Object ... params) throws SQLException {
        Connection conn = null;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        long time1 = System.currentTimeMillis();
        try {
            conn = this.getConnection();
            preparedStatement = this.preparedStatement(conn, sql, false);
            if (params.length > 0) {
                SqlClient.setParams(preparedStatement, params);
            }
            resultSet = preparedStatement.executeQuery();
            T t = callback.execute(resultSet);
            return t;
        }
        finally {
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException sQLException) {}
            long l = System.currentTimeMillis();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T executeStreamingQuery(String sql, SqlCallback<T> callback, Object ... params) throws SQLException {
        Connection conn = null;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        long time1 = System.currentTimeMillis();
        try {
            conn = this.getConnection();
            preparedStatement = this.preparedStatement(conn, sql, true);
            if (params.length > 0) {
                SqlClient.setParams(preparedStatement, params);
            }
            resultSet = preparedStatement.executeQuery();
            T t = callback.execute(resultSet);
            return t;
        }
        finally {
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException sQLException) {}
            long l = System.currentTimeMillis();
        }
    }

    public static Map rsToMapSingle(ResultSet rs, String[] keys) throws SQLException {
        boolean haveNext = rs.next();
        if (!haveNext) {
            return null;
        }
        String[] _keys = keys;
        if (_keys == null) {
            _keys = SqlClient.getRsCloumns(rs);
        }
        Map temp = SqlClient.rsToMap(rs, _keys);
        return temp;
    }

    public static Map rsToMap(ResultSet rs, String[] keys) {
        HashMap<String, Object> temp = new HashMap<String, Object>();
        for (int i = 0; i < keys.length; ++i) {
            try {
                temp.put(keys[i], rs.getObject(keys[i]));
                continue;
            }
            catch (SQLException e) {
                // empty catch block
            }
        }
        return temp;
    }

    public static List<Map> rsToMaps(ResultSet rs, String[] keys) {
        ArrayList<Map> result = new ArrayList<Map>();
        try {
            while (rs.next()) {
                result.add(SqlClient.rsToMap(rs, keys));
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return result;
    }

    public static List<Map> rsToMaps(ResultSet rs) {
        ArrayList<Map> result = new ArrayList<Map>();
        try {
            while (rs.next()) {
                result.add(SqlClient.rsToMap(rs, SqlClient.getRsCloumns(rs)));
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return result;
    }

    public static String[] getRsCloumns(ResultSet rs) throws SQLException {
        ResultSetMetaData rsm = rs.getMetaData();
        String[] columns = new String[rsm.getColumnCount()];
        for (int i = 0; i < columns.length; ++i) {
            columns[i] = rsm.getColumnLabel(i + 1);
        }
        return columns;
    }

    private static void setParams(PreparedStatement ps, Object[] params) throws SQLException {
        if (params == null || params.length == 0) {
            return;
        }
        for (int i = 0; i < params.length; ++i) {
            ps.setObject(i + 1, params[i]);
        }
    }

    public static interface SqlListCallback<T> {
        public List<T> execute(ResultSet var1);
    }

    public static interface BatchSqlCallback {
        public void execute(PreparedStatement var1);
    }

    public static interface SqlCallback<T> {
        public T execute(ResultSet var1);
    }
}

