/*
 * Decompiled with CFR 0.152.
 */
package net.csdn.jpa.hql;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import net.csdn.common.collections.WowCollections;

public class WowWhereParser {
    public static final String HQL_SEPARATORS = " \n\r\f\t,()=<>&|+-=/*'^![]#~\\";
    private Set columns = new HashSet();
    private String alias = "";
    private List<String> whereConditions = new ArrayList<String>();
    private boolean open = false;
    private boolean close = true;
    private List<String> smallExpression = new ArrayList<String>();
    private static final Set EXPRESSION_TERMINATORS = new HashSet();
    private static final Set EXPRESSION_OPENERS = new HashSet();
    private static final Set BOOLEAN_OPERATORS = new HashSet();
    private static final Map NEGATIONS = new HashMap();

    public WowWhereParser(Set columns, String alias) {
        this.columns = columns;
        this.alias = alias;
    }

    public void parse(String wheres) {
        StringTokenizer tokens = new StringTokenizer(wheres, HQL_SEPARATORS, true);
        while (tokens.hasMoreElements()) {
            String token = tokens.nextToken();
            this.whereConditions.add(this.token(token));
        }
    }

    public String toHql() {
        return WowCollections.join(this.whereConditions);
    }

    private String token(String token) {
        String lcToken = token.toLowerCase().trim();
        if (this.open && !this.close) {
            if (lcToken.equals("'") || lcToken.equals("\"")) {
                this.open = false;
                this.close = true;
                this.smallExpression.add(token);
                return WowCollections.join(this.smallExpression);
            }
            this.smallExpression.add(token);
            return "";
        }
        if (lcToken.trim().isEmpty() || lcToken.startsWith(":") || EXPRESSION_TERMINATORS.contains(lcToken) || BOOLEAN_OPERATORS.contains(lcToken)) {
            return token;
        }
        if ((lcToken.equals("'") || lcToken.equals("\"")) && !this.open && this.close) {
            this.open = true;
            this.close = false;
            this.smallExpression.clear();
            this.smallExpression.add(token);
            return "";
        }
        String prefixName = WowWhereParser.root(token);
        if (this.columns.contains(prefixName)) {
            if (prefixName.equals(this.alias)) {
                return token;
            }
            return this.alias + "." + token;
        }
        return token;
    }

    public static String root(String qualifiedName) {
        int loc = qualifiedName.indexOf(".");
        return loc < 0 ? qualifiedName : qualifiedName.substring(0, loc);
    }

    static {
        EXPRESSION_TERMINATORS.add("and");
        EXPRESSION_TERMINATORS.add("or");
        EXPRESSION_TERMINATORS.add(")");
        EXPRESSION_OPENERS.add("and");
        EXPRESSION_OPENERS.add("or");
        EXPRESSION_OPENERS.add("(");
        BOOLEAN_OPERATORS.add("<");
        BOOLEAN_OPERATORS.add("=");
        BOOLEAN_OPERATORS.add(">");
        BOOLEAN_OPERATORS.add("#");
        BOOLEAN_OPERATORS.add("~");
        BOOLEAN_OPERATORS.add("like");
        BOOLEAN_OPERATORS.add("ilike");
        BOOLEAN_OPERATORS.add("regexp");
        BOOLEAN_OPERATORS.add("rlike");
        BOOLEAN_OPERATORS.add("is");
        BOOLEAN_OPERATORS.add("in");
        BOOLEAN_OPERATORS.add("any");
        BOOLEAN_OPERATORS.add("some");
        BOOLEAN_OPERATORS.add("all");
        BOOLEAN_OPERATORS.add("exists");
        BOOLEAN_OPERATORS.add("between");
        BOOLEAN_OPERATORS.add("<=");
        BOOLEAN_OPERATORS.add(">=");
        BOOLEAN_OPERATORS.add("=>");
        BOOLEAN_OPERATORS.add("=<");
        BOOLEAN_OPERATORS.add("!=");
        BOOLEAN_OPERATORS.add("<>");
        BOOLEAN_OPERATORS.add("!#");
        BOOLEAN_OPERATORS.add("!~");
        BOOLEAN_OPERATORS.add("!<");
        BOOLEAN_OPERATORS.add("!>");
        BOOLEAN_OPERATORS.add("is not");
        BOOLEAN_OPERATORS.add("not like");
        BOOLEAN_OPERATORS.add("not ilike");
        BOOLEAN_OPERATORS.add("not regexp");
        BOOLEAN_OPERATORS.add("not rlike");
        BOOLEAN_OPERATORS.add("not in");
        BOOLEAN_OPERATORS.add("not between");
        BOOLEAN_OPERATORS.add("not exists");
        NEGATIONS.put("and", "or");
        NEGATIONS.put("or", "and");
        NEGATIONS.put("<", ">=");
        NEGATIONS.put("=", "<>");
        NEGATIONS.put(">", "<=");
        NEGATIONS.put("#", "!#");
        NEGATIONS.put("~", "!~");
        NEGATIONS.put("like", "not like");
        NEGATIONS.put("ilike", "not ilike");
        NEGATIONS.put("regexp", "not regexp");
        NEGATIONS.put("rlike", "not rlike");
        NEGATIONS.put("is", "is not");
        NEGATIONS.put("in", "not in");
        NEGATIONS.put("exists", "not exists");
        NEGATIONS.put("between", "not between");
        NEGATIONS.put("<=", ">");
        NEGATIONS.put(">=", "<");
        NEGATIONS.put("=>", "<");
        NEGATIONS.put("=<", ">");
        NEGATIONS.put("!=", "=");
        NEGATIONS.put("<>", "=");
        NEGATIONS.put("!#", "#");
        NEGATIONS.put("!~", "~");
        NEGATIONS.put("!<", "<");
        NEGATIONS.put("!>", ">");
        NEGATIONS.put("is not", "is");
        NEGATIONS.put("not like", "like");
        NEGATIONS.put("not ilike", "ilike");
        NEGATIONS.put("not regexp", "regexp");
        NEGATIONS.put("not rlike", "rlike");
        NEGATIONS.put("not in", "in");
        NEGATIONS.put("not between", "between");
        NEGATIONS.put("not exists", "exists");
    }
}

