/*
 * Decompiled with CFR 0.152.
 */
package net.csdn.jpa.enhancer;

import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import javassist.CtClass;
import javassist.CtField;
import javassist.CtMethod;
import javassist.Modifier;
import javassist.NotFoundException;
import javassist.bytecode.ConstPool;
import javassist.bytecode.annotation.BooleanMemberValue;
import javassist.bytecode.annotation.EnumMemberValue;
import javassist.bytecode.annotation.StringMemberValue;
import javax.persistence.Column;
import javax.persistence.DiscriminatorColumn;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.MappedSuperclass;
import javax.persistence.Table;
import net.csdn.annotation.validate.Validate;
import net.csdn.common.Strings;
import net.csdn.common.collect.Tuple;
import net.csdn.common.collections.WowCollections;
import net.csdn.common.enhancer.EnhancerHelper;
import net.csdn.common.logging.CSLogger;
import net.csdn.common.logging.Loggers;
import net.csdn.common.settings.Settings;
import net.csdn.enhancer.BitEnhancer;
import net.csdn.jpa.JPA;
import net.csdn.jpa.enhancer.AssociationEnhancer;
import net.csdn.jpa.enhancer.ModelClass;
import net.csdn.jpa.type.DBInfo;
import net.csdn.jpa.type.DBType;
import org.apache.commons.lang.StringUtils;
import org.hibernate.annotations.DynamicInsert;

public class EntityEnhancer
implements BitEnhancer {
    private Settings settings;
    private CSLogger logger = Loggers.getLogger(this.getClass());
    private DBInfo dbInfo = JPA.dbInfo();

    public EntityEnhancer(Settings settings) {
        this.settings = settings;
    }

    @Override
    public void enhance(List<ModelClass> roots) throws Exception {
        for (ModelClass modelClass : roots) {
            if (modelClass.isLeafNode()) {
                this.processLeafEntity(modelClass);
                this.autoInjectProperty(modelClass);
                this.autoInjectGetSet(modelClass);
                continue;
            }
            this.processInheritanceEntity(modelClass);
        }
    }

    private void processEntityDiscriminatorColumn(ModelClass modelClass) {
        CtClass ctClass = modelClass.originClass;
        Map<String, String> columns = this.dbInfo.tableColumns.get(ctClass.getSimpleName());
        if (columns != null && !ctClass.hasAnnotation(DiscriminatorColumn.class)) {
            for (String columnName : columns.keySet()) {
                if (!columnName.equals("discriminator")) continue;
                ConstPool constPool = ctClass.getClassFile().getConstPool();
                EnumMemberValue emb = new EnumMemberValue(constPool);
                emb.setType("javax.persistence.DiscriminatorType");
                emb.setValue("STRING");
                EnhancerHelper.createAnnotation((CtClass)ctClass, DiscriminatorColumn.class, (Map)WowCollections.map((Object[])new Object[]{"name", new StringMemberValue(columnName, constPool), "discriminatorType", emb}));
                EnumMemberValue strategy = new EnumMemberValue(constPool);
                strategy.setType("javax.persistence.InheritanceType");
                strategy.setValue("SINGLE_TABLE");
                EnhancerHelper.createAnnotation((CtClass)ctClass, Inheritance.class, (Map)WowCollections.map((Object[])new Object[]{"strategy", strategy}));
                for (ModelClass mc : modelClass.findLeafNodes()) {
                    this.dbInfo.tableColumns.put(mc.originClass.getName(), columns);
                }
            }
        }
    }

    private void processLeafEntity(ModelClass modelClass) throws Exception {
        String entityName;
        CtClass ct = modelClass.originClass;
        ConstPool constPool = ct.getClassFile().getConstPool();
        EnhancerHelper.createAnnotation((CtClass)ct, Entity.class, (Map)WowCollections.map((Object[])new Object[0]));
        Entity entity = (Entity)ct.getAnnotation(Entity.class);
        String string = entityName = StringUtils.isEmpty((String)entity.name()) ? Strings.toUnderscoreCase((String)ct.getSimpleName()) : entity.name();
        if (!ct.hasAnnotation(Table.class)) {
            EnhancerHelper.createAnnotation((CtClass)ct, Table.class, (Map)WowCollections.map((Object[])new Object[]{"name", new StringMemberValue(entityName, constPool)}));
        }
        EnhancerHelper.createAnnotation((CtClass)ct, org.hibernate.annotations.Entity.class, (Map)WowCollections.map((Object[])new Object[]{"dynamicInsert", new BooleanMemberValue(true, constPool)}));
        EnhancerHelper.createAnnotation((CtClass)ct, DynamicInsert.class, (Map)WowCollections.map((Object[])new Object[0]));
        this.dbInfo.tableColumns.put(ct.getSimpleName(), this.dbInfo.tableColumns.get(entityName));
    }

    private void processInheritanceEntity(ModelClass modelClass) throws Exception {
        CtClass ct = modelClass.originClass;
        List<ModelClass> leafNodes = modelClass.findLeafNodes();
        if (!ct.hasAnnotation(Inheritance.class) && Modifier.isAbstract((int)ct.getModifiers())) {
            EnhancerHelper.createAnnotation((CtClass)ct, MappedSuperclass.class, (Map)WowCollections.map((Object[])new Object[0]));
            ConstPool constPool = ct.getClassFile().getConstPool();
            EnumMemberValue strategy = new EnumMemberValue(constPool);
            strategy.setType("javax.persistence.InheritanceType");
            strategy.setValue("JOINED");
            EnhancerHelper.createAnnotation((CtClass)ct, Inheritance.class, (Map)WowCollections.map((Object[])new Object[]{"strategy", strategy}));
        }
        for (ModelClass mc : leafNodes) {
            this.processLeafEntity(mc);
            this.autoInjectGetSet(mc);
        }
        this.autoInjectGetSet(modelClass);
        MappedSuperclass mappedSuperclass = (MappedSuperclass)ct.getAnnotation(MappedSuperclass.class);
        if (mappedSuperclass != null) {
            this.autoInhanceProperty(modelClass);
            this.autoInjectGetSet(modelClass);
            AssociationEnhancer associationEnhancer = new AssociationEnhancer(this.settings);
            for (ModelClass mc : leafNodes) {
                this.autoInjectProperty(mc);
            }
            associationEnhancer.enhance(WowCollections.list((Object[])new ModelClass[]{modelClass}));
        } else {
            Inheritance inheritance = (Inheritance)ct.getAnnotation(Inheritance.class);
            if (!inheritance.strategy().equals((Object)InheritanceType.JOINED) && !inheritance.strategy().equals((Object)InheritanceType.SINGLE_TABLE) && inheritance.strategy().equals((Object)InheritanceType.TABLE_PER_CLASS)) {
                this.autoInjectProperty(modelClass);
                for (ModelClass mc : leafNodes) {
                    this.autoInjectProperty(mc);
                }
            }
        }
    }

    private void copyFields(final ModelClass modelClass) {
        ModelClass.iterateSuperClass(modelClass.originClass, new ModelClass.SuperClassIterator(){

            @Override
            public void iterate(CtClass ctClass) {
                try {
                    EntityEnhancer.copyFieldsToSubclass(ctClass, modelClass.originClass);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
    }

    private void autoInhanceProperty(ModelClass modelClass) {
        try {
            CtField[] fields;
            List<String> skipFields = modelClass.notMappings();
            ConstPool constPool = modelClass.originClass.getClassFile().getConstPool();
            for (CtField ctField : fields = modelClass.originClass.getDeclaredFields()) {
                if (skipFields.contains(ctField.getName()) || skipFields.contains(Strings.toUnderscoreCase((String)ctField.getName())) || ctField.getAnnotations().length != 0 || ctField.getName().equals("discriminator")) continue;
                if (ctField.getName().equals("id")) {
                    EnhancerHelper.createAnnotation((CtField)ctField, Id.class, (Map)WowCollections.map((Object[])new Object[0]));
                    EnumMemberValue emv = new EnumMemberValue(constPool);
                    emv.setType(GenerationType.class.getName());
                    emv.setValue(GenerationType.IDENTITY.name());
                    EnhancerHelper.createAnnotation((CtField)ctField, GeneratedValue.class, (Map)WowCollections.map((Object[])new Object[]{"strategy", emv}));
                    continue;
                }
                EnhancerHelper.createAnnotation((CtField)ctField, Column.class, (Map)WowCollections.map((Object[])new Object[]{"name", new StringMemberValue(Strings.toUnderscoreCase((String)ctField.getName()), constPool), "nullable", new BooleanMemberValue(true, constPool)}));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void autoInjectProperty(ModelClass modelClass) {
        CtClass ctClass = modelClass.originClass;
        List<String> skipFields = modelClass.notMappings();
        String entitySimpleName = ctClass.getSimpleName();
        try {
            DBType dbType = JPA.dbType();
            DBInfo dbInfo = JPA.dbInfo();
            Map<String, String> columns = dbInfo.tableColumns.get(entitySimpleName);
            if (columns == null) {
                return;
            }
            ConstPool constPool = ctClass.getClassFile().getConstPool();
            for (String columnName : columns.keySet()) {
                CtField ctField;
                final String fieldName = Strings.toCamelCase((String)columnName, (boolean)false);
                String fieldType = columns.get(columnName);
                if (skipFields.contains(columnName) || skipFields.contains(fieldName) || fieldName.equals("discriminator")) continue;
                final AtomicBoolean pass = new AtomicBoolean(true);
                try {
                    ctClass.getDeclaredField(fieldName);
                }
                catch (Exception e) {
                    ModelClass.iterateSuperClass(ctClass, new ModelClass.SuperClassIterator(){

                        @Override
                        public void iterate(CtClass ctClass) {
                            if (!pass.get()) {
                                return;
                            }
                            try {
                                ctClass.getDeclaredField(fieldName);
                            }
                            catch (Exception e) {
                                pass.set(false);
                            }
                        }
                    });
                }
                if (pass.get()) {
                    ctField = ctClass.getField(fieldName);
                    this.addColumnAnnotation(ctField, dbType, fieldType, constPool);
                    continue;
                }
                ctField = CtField.make((String)(" private " + (String)dbType.typeToJava(fieldType).v2() + " " + fieldName + " ;"), (CtClass)ctClass);
                this.addColumnAnnotation(ctField, dbType, fieldType, constPool);
                ctClass.addField(ctField);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        ctClass.defrost();
    }

    private void addColumnAnnotation(CtField ctField, DBType dbType, String fieldType, ConstPool constPool) {
        String fieldName;
        Tuple<Class, Map> tuple = dbType.dateType(fieldType, constPool);
        if (tuple != null) {
            EnhancerHelper.createAnnotation((CtField)ctField, (Class)((Class)tuple.v1()), (Map)((Map)tuple.v2()));
        }
        if ((fieldName = ctField.getName()).equals("id")) {
            EnumMemberValue emv = new EnumMemberValue(constPool);
            emv.setType(GenerationType.class.getName());
            emv.setValue(GenerationType.IDENTITY.name());
            EnhancerHelper.createAnnotation((CtField)ctField, Id.class, (Map)WowCollections.map((Object[])new Object[0]));
            EnhancerHelper.createAnnotation((CtField)ctField, GeneratedValue.class, (Map)WowCollections.map((Object[])new Object[]{"strategy", emv}));
        } else {
            EnhancerHelper.createAnnotation((CtField)ctField, Column.class, (Map)WowCollections.map((Object[])new Object[]{"name", new StringMemberValue(Strings.toUnderscoreCase((String)fieldName), constPool), "nullable", new BooleanMemberValue(true, constPool)}));
        }
    }

    boolean isFinal(CtField ctField) {
        return java.lang.reflect.Modifier.isFinal(ctField.getModifiers());
    }

    boolean isStatic(CtField ctField) {
        return java.lang.reflect.Modifier.isStatic(ctField.getModifiers());
    }

    private void autoInjectGetSet(ModelClass modelClass) throws Exception {
        CtClass ctClass = modelClass.originClass;
        for (CtField ctField : ctClass.getDeclaredFields()) {
            CtMethod ctMethod;
            if (this.isFinal(ctField) || this.isStatic(ctField) || ctField.hasAnnotation(Validate.class)) continue;
            String propertyName = ctField.getName().substring(0, 1).toUpperCase() + ctField.getName().substring(1);
            String getter = "get" + propertyName;
            String setter = "set" + propertyName;
            try {
                ctMethod = ctClass.getDeclaredMethod(getter);
                if (ctMethod.getParameterTypes().length > 0 || java.lang.reflect.Modifier.isStatic(ctMethod.getModifiers())) {
                    throw new NotFoundException("it's not a getter !");
                }
            }
            catch (NotFoundException noGetter) {
                String code = "public " + ctField.getType().getName() + " " + getter + "() { return this." + ctField.getName() + "; }";
                CtMethod getMethod = CtMethod.make((String)code, (CtClass)ctClass);
                getMethod.setModifiers(getMethod.getModifiers() | 0x1000);
                ctClass.addMethod(getMethod);
            }
            try {
                ctMethod = ctClass.getDeclaredMethod(setter);
                if (ctMethod.getParameterTypes().length == 1 && ctMethod.getParameterTypes()[0].equals(ctField.getType()) && !java.lang.reflect.Modifier.isStatic(ctMethod.getModifiers())) continue;
                throw new NotFoundException("it's not a setter !");
            }
            catch (NotFoundException noSetter) {
                CtMethod setMethod = CtMethod.make((String)("public void " + setter + "(" + ctField.getType().getName() + " value) { this." + ctField.getName() + " = value; }"), (CtClass)ctClass);
                setMethod.setModifiers(setMethod.getModifiers() | 0x1000);
                ctClass.addMethod(setMethod);
            }
        }
        ctClass.defrost();
    }

    private static void copyFieldsToSubclass(CtClass document, CtClass targetClass) throws Exception {
        CtField[] ctFields;
        for (CtField ctField : ctFields = document.getDeclaredFields()) {
            if (Modifier.isStatic((int)ctField.getModifiers())) continue;
            CtField ctField1 = new CtField(ctField.getType(), ctField.getName(), targetClass);
            ctField1.setModifiers(ctField.getModifiers());
            ctField1.getFieldInfo().getAttributes().addAll(ctField.getFieldInfo().getAttributes());
            targetClass.addField(ctField1);
        }
    }
}

