/*
 * Decompiled with CFR 0.152.
 */
package net.csdn.jpa.type;

import com.google.inject.Inject;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.csdn.common.Strings;
import net.csdn.common.logging.support.MessageFormat;
import net.csdn.common.settings.Settings;
import net.csdn.jpa.JPA;

public class DBInfo {
    public final List<String> tableNames = new ArrayList<String>();
    public final Map<String, Map<String, String>> tableColumns = new HashMap<String, Map<String, String>>();
    private Settings settings;

    @Inject
    public DBInfo(Settings settings) {
        this.settings = settings;
        try {
            boolean disableMysql = settings.getAsBoolean(JPA.mode() + ".datasources.mysql.disable", Boolean.valueOf(false));
            if (!disableMysql) {
                this.info();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void info() throws Exception {
        Connection conn = null;
        Class.forName("com.mysql.jdbc.Driver").newInstance();
        Map groups = this.settings.getGroups(JPA.mode() + ".datasources");
        Settings mysqlSetting = (Settings)groups.get("mysql");
        if (mysqlSetting == null) {
            return;
        }
        String url = "jdbc:mysql://{}:{}/{}?useUnicode=true&characterEncoding=utf8";
        url = MessageFormat.format((String)url, (Object[])new Object[]{mysqlSetting.get("host", "127.0.0.1"), mysqlSetting.get("port", "3306"), mysqlSetting.get("database", "csdn_search_client")});
        conn = DriverManager.getConnection(url, mysqlSetting.get("username"), mysqlSetting.get("password"));
        DatabaseMetaData databaseMetaData = conn.getMetaData();
        ResultSet resultSet = databaseMetaData.getTables(null, null, "%", null);
        while (resultSet.next()) {
            String tableName = resultSet.getString(3);
            this.tableNames.add(tableName);
            PreparedStatement ps = conn.prepareStatement("select * from " + tableName + " limit 1");
            ResultSet rs = ps.executeQuery();
            ResultSetMetaData rsme = rs.getMetaData();
            int columnCount = rsme.getColumnCount();
            HashMap<String, String> columns = new HashMap<String, String>();
            for (int i = 1; i <= columnCount; ++i) {
                String fieldName = rsme.getColumnName(i);
                String typeName = rsme.getColumnTypeName(i);
                columns.put(fieldName, typeName);
            }
            this.tableColumns.put(tableName, columns);
            this.tableColumns.put(Strings.toCamelCase((String)tableName, (boolean)true), columns);
        }
        conn.close();
    }
}

