/*
 * Decompiled with CFR 0.152.
 */
package net.csdn.jpa.enhancer;

import java.lang.reflect.Modifier;
import java.util.List;
import javassist.CtClass;
import javassist.CtField;
import javassist.CtMethod;
import javassist.CtNewMethod;
import net.csdn.common.collections.WowCollections;
import net.csdn.common.settings.Settings;
import net.csdn.enhancer.BitEnhancer;
import net.csdn.jpa.enhancer.ModelClass;

public class ClassMethodEnhancer
implements BitEnhancer {
    private Settings settings;
    private List<String> shouldCopyToSubclassStaticMethods = WowCollections.list((Object[])new String[]{"validate_info", "validate"});

    public ClassMethodEnhancer(Settings settings) {
        this.settings = settings;
    }

    @Override
    public void enhance(List<ModelClass> modelClasses) throws Exception {
        for (ModelClass modelClass : modelClasses) {
            this.copyStaticFieldsToSubclass(modelClass.originClass);
            this.copyStaticMethodsToSubclass(modelClass.originClass);
            this.enhanceModelMethods(modelClass.originClass);
        }
    }

    private void copyStaticMethodsToSubclass(CtClass ctClass) {
        try {
            CtClass parent = ctClass.getSuperclass();
            while (!parent.getName().equals("net.csdn.jpa.model.Model") && !parent.getName().equals("java.lang.Object")) {
                parent = parent.getSuperclass();
            }
            this.copyStaticMethodsToSubclass(parent, ctClass);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void copyStaticFieldsToSubclass(CtClass ctClass) {
        try {
            CtClass parent = ctClass.getSuperclass();
            while (!parent.getName().equals("net.csdn.jpa.model.Model") && !parent.getName().equals("java.lang.Object")) {
                parent = parent.getSuperclass();
            }
            this.copyStaticFieldsToSubclass(parent, ctClass);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void enhanceModelMethods(CtClass ctClass) throws Exception {
        String entityName = ctClass.getName();
        String simpleEntityName = ctClass.getSimpleName();
        CtMethod count = CtMethod.make((String)("public static long count() { return getJPAContext().jpql().count(\"" + entityName + "\"); }"), (CtClass)ctClass);
        ctClass.addMethod(count);
        CtMethod count2 = CtMethod.make((String)("public static long count(String query, Object[] params) { return  getJPAContext().jpql().count(\"" + entityName + "\", query, params); }"), (CtClass)ctClass);
        ctClass.addMethod(count2);
        CtMethod findAll = CtMethod.make((String)("public static java.util.List findAll() { return  getJPAContext().jpql().findAll(\"" + entityName + "\"); }"), (CtClass)ctClass);
        ctClass.addMethod(findAll);
        CtMethod findById = CtMethod.make((String)("public static net.csdn.jpa.model.JPABase findById(Object id) { return  getJPAContext().jpql().findById(" + entityName + ".class, id); }"), (CtClass)ctClass);
        ctClass.addMethod(findById);
        CtMethod find = CtMethod.make((String)("public static net.csdn.jpa.model.Model.JPAQuery find(String query, Object[] params) { return  getJPAContext().jpql().find(\"" + entityName + "\", query, params); }"), (CtClass)ctClass);
        ctClass.addMethod(find);
        CtMethod find2 = CtMethod.make((String)("public static net.csdn.jpa.model.Model.JPAQuery find() { return  getJPAContext().jpql().find(\"" + entityName + "\"); }"), (CtClass)ctClass);
        ctClass.addMethod(find2);
        CtMethod all = CtMethod.make((String)("public static net.csdn.jpa.model.Model.JPAQuery all() { return  getJPAContext().jpql().all(\"" + entityName + "\"); }"), (CtClass)ctClass);
        ctClass.addMethod(all);
        CtMethod delete = CtMethod.make((String)("public static int delete(String query, Object[] params) { return  getJPAContext().jpql().delete(\"" + entityName + "\", query, params); }"), (CtClass)ctClass);
        ctClass.addMethod(delete);
        CtMethod deleteAll = CtMethod.make((String)("public static int deleteAll() { return  getJPAContext().jpql().deleteAll(\"" + entityName + "\"); }"), (CtClass)ctClass);
        ctClass.addMethod(deleteAll);
        CtMethod findOneBy = CtMethod.make((String)("public static net.csdn.jpa.model.JPABase findOneBy(String query, Object[] params) { return  getJPAContext().jpql().findOneBy(\"" + entityName + "\", query, params); }"), (CtClass)ctClass);
        ctClass.addMethod(findOneBy);
        CtMethod create = CtMethod.make((String)("public static net.csdn.jpa.model.JPABase create(java.util.Map params) { return  getJPAContext().jpql().create(" + entityName + ".class, params); }"), (CtClass)ctClass);
        ctClass.addMethod(create);
        CtMethod where = CtMethod.make((String)("public static net.csdn.jpa.model.JPQL where(String cc){return getJPAContext().jpql(\"" + simpleEntityName + "\").where(cc);}"), (CtClass)ctClass);
        ctClass.addMethod(where);
        CtMethod in = CtMethod.make((String)("public static net.csdn.jpa.model.JPQL in(String cc,java.util.Map params){return getJPAContext().jpql(\"" + simpleEntityName + "\").in(cc,params);}"), (CtClass)ctClass);
        ctClass.addMethod(in);
        CtMethod in2 = CtMethod.make((String)("public static net.csdn.jpa.model.JPQL in(String cc,java.util.List params){return getJPAContext().jpql(\"" + simpleEntityName + "\").in(cc,params);}"), (CtClass)ctClass);
        ctClass.addMethod(in2);
        CtMethod where2 = CtMethod.make((String)("public static net.csdn.jpa.model.JPQL where(String cc,java.util.Map params){return getJPAContext().jpql(\"" + simpleEntityName + "\").where(cc,params);}"), (CtClass)ctClass);
        ctClass.addMethod(where2);
        CtMethod where3 = CtMethod.make((String)("public static net.csdn.jpa.model.JPQL where(java.util.Map params){return getJPAContext().jpql(\"" + simpleEntityName + "\").where(params);}"), (CtClass)ctClass);
        ctClass.addMethod(where3);
        CtMethod select = CtMethod.make((String)("public static net.csdn.jpa.model.JPQL select(String cc){return getJPAContext().jpql(\"" + simpleEntityName + "\").select(cc);}"), (CtClass)ctClass);
        ctClass.addMethod(select);
        CtMethod joins = CtMethod.make((String)("public static net.csdn.jpa.model.JPQL joins(String cc){return getJPAContext().jpql(\"" + simpleEntityName + "\").joins(cc);}"), (CtClass)ctClass);
        ctClass.addMethod(joins);
        CtMethod order = CtMethod.make((String)("public static net.csdn.jpa.model.JPQL order(String cc){return getJPAContext().jpql(\"" + simpleEntityName + "\").order(cc);}"), (CtClass)ctClass);
        ctClass.addMethod(order);
        CtMethod limit = CtMethod.make((String)("public static net.csdn.jpa.model.JPQL limit(int cc){return getJPAContext().jpql(\"" + simpleEntityName + "\").limit(cc);}"), (CtClass)ctClass);
        ctClass.addMethod(limit);
        CtMethod offset = CtMethod.make((String)("public static net.csdn.jpa.model.JPQL offset(int cc){return getJPAContext().jpql(\"" + simpleEntityName + "\").offset(cc);}"), (CtClass)ctClass);
        ctClass.addMethod(offset);
        CtMethod findWithSingleId = CtMethod.make((String)("public static net.csdn.jpa.model.JPABase  find(Integer cc){return getJPAContext().jpql(\"" + simpleEntityName + "\").find(cc);}"), (CtClass)ctClass);
        ctClass.addMethod(findWithSingleId);
        CtMethod findWithMultiId = CtMethod.make((String)("public static java.util.List find(java.util.List cc){return getJPAContext().jpql(\"" + simpleEntityName + "\").find(cc);}"), (CtClass)ctClass);
        ctClass.addMethod(findWithMultiId);
        ctClass.defrost();
    }

    private void copyStaticMethodsToSubclass(CtClass document, CtClass targetClass) throws Exception {
        CtMethod[] ctMethods;
        for (CtMethod ctMethod : ctMethods = document.getMethods()) {
            if (!Modifier.isStatic(ctMethod.getModifiers()) || !this.shouldCopyToSubclassStaticMethods.contains(ctMethod.getName())) continue;
            CtMethod ctNewMethod = CtNewMethod.copy((CtMethod)ctMethod, (CtClass)targetClass, null);
            targetClass.addMethod(ctNewMethod);
        }
    }

    private void copyStaticFieldsToSubclass(CtClass document, CtClass targetClass) throws Exception {
        CtField[] ctFields;
        for (CtField ctField : ctFields = document.getFields()) {
            if (!Modifier.isStatic(ctField.getModifiers()) || !ctField.getName().startsWith("parent$_")) continue;
            CtField ctField1 = new CtField(ctField.getType(), ctField.getName(), targetClass);
            ctField1.setModifiers(ctField.getModifiers());
            targetClass.addField(ctField1);
        }
    }
}

