/*
 * Decompiled with CFR 0.152.
 */
package net.csdn.mongo;

import com.google.inject.Injector;
import com.mongodb.DB;
import com.mongodb.DBCollection;
import com.mongodb.Mongo;
import java.io.DataInputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javassist.ClassPath;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.LoaderClassPath;
import net.csdn.common.scan.DefaultScanService;
import net.csdn.common.scan.ScanService;
import net.csdn.common.settings.Settings;
import net.csdn.mongo.Document;
import net.csdn.mongo.enhancer.Enhancer;
import net.csdn.mongo.enhancer.MongoEnhancer;

public class MongoMongo {
    private Mongo mongo;
    private String dbName;
    private static CSDNMongoConfiguration mongoConfiguration;
    private static final String defaultHostName = "127.0.0.1";
    private static final int defaultHostPort = 27017;
    private static final String defaultDBName = "csdn_data_center";

    public static CSDNMongoConfiguration getMongoConfiguration() {
        return mongoConfiguration;
    }

    public MongoMongo(CSDNMongoConfiguration csdnMongoConfiguration) throws Exception {
        mongoConfiguration = csdnMongoConfiguration;
        this.mongo = new Mongo(MongoMongo.settings().get(MongoMongo.mode() + ".datasources.mongodb.host", defaultHostName), mongoConfiguration.settings.getAsInt(MongoMongo.mode() + ".datasources.mongodb.port", Integer.valueOf(27017)).intValue());
        this.dbName = MongoMongo.settings().get(MongoMongo.mode() + ".datasources.mongodb.database", defaultDBName);
    }

    public static void configure(CSDNMongoConfiguration csdnMongoConfiguration) {
        MongoMongo mongoMongo = null;
        try {
            Document.mongoMongo = mongoMongo = new MongoMongo(csdnMongoConfiguration);
            mongoMongo.loadDocuments();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static String mode() {
        return mongoConfiguration.mode;
    }

    public Mongo mongo() {
        return this.mongo;
    }

    public String dbName() {
        return this.dbName;
    }

    public static Settings settings() {
        return mongoConfiguration.settings;
    }

    public static void injector(Injector injector) {
        mongoConfiguration.injector = injector;
    }

    public static Injector injector() {
        return mongoConfiguration.injector;
    }

    public static ClassPool classPool() {
        return mongoConfiguration.classPool;
    }

    public DBCollection collection(String tableName) {
        return this.database().getCollection(tableName);
    }

    public DB database() {
        return this.mongo.getDB(this.dbName);
    }

    public static void loadDocuments() {
        try {
            new MongoDocumentLoader().load();
            new MongoValidatorLoader().load();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static class MongoValidatorLoader {
        public void load() throws Exception {
            HashMap<String, String> defaultMaps = new HashMap<String, String>();
            defaultMaps.put("format", "net.csdn.mongo.validate.impl.Format");
            defaultMaps.put("numericality", "net.csdn.mongo.validate.impl.Numericality");
            defaultMaps.put("presence", "net.csdn.mongo.validate.impl.Presence");
            defaultMaps.put("uniqueness", "net.csdn.mongo.validate.impl.Uniqueness");
            defaultMaps.put("length", "net.csdn.mongo.validate.impl.Length");
            defaultMaps.put("associated", "net.csdn.mongo.validate.impl.Associated");
            for (Map.Entry entry : defaultMaps.entrySet()) {
                Document.validateParses.add(Class.forName((String)entry.getValue()).newInstance());
            }
        }
    }

    public static class MongoDocumentLoader {
        public void load() throws Exception {
            final MongoEnhancer enhancer = new MongoEnhancer(MongoMongo.settings());
            final ArrayList<CtClass> classList = new ArrayList<CtClass>();
            DefaultScanService scanService = new DefaultScanService();
            scanService.setLoader(mongoConfiguration.classLoader);
            scanService.scanArchives(MongoMongo.settings().get("application.document"), new ScanService.LoadClassEnhanceCallBack(){

                public Class loaded(DataInputStream classFile) {
                    try {
                        classList.add(enhancer.enhanceThisClass(classFile));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    return null;
                }
            });
            ((Enhancer)enhancer).enhanceThisClass2(classList);
        }
    }

    public static class CSDNMongoConfiguration {
        private Settings settings;
        private Injector injector;
        private ClassPool classPool;
        private Class classLoader;
        private String mode;

        public Class getClassLoader() {
            return this.classLoader;
        }

        public Settings getSettings() {
            return this.settings;
        }

        public void setSettings(Settings settings) {
            this.settings = settings;
        }

        public String getMode() {
            return this.mode;
        }

        public void setMode(String mode) {
            this.mode = mode;
        }

        public CSDNMongoConfiguration(String mode, Settings settings, Class classLoader) {
            this.mode = mode;
            this.classLoader = classLoader;
            this.settings = settings;
            this.buildClassPool();
        }

        public CSDNMongoConfiguration(String mode, Settings settings, Class classLoader, ClassPool classPool) {
            this.mode = mode;
            this.settings = settings;
            this.classLoader = classLoader;
            this.classPool = classPool;
        }

        public void buildClassPool() {
            this.classPool = new ClassPool();
            this.classPool.appendSystemPath();
            this.classPool.appendClassPath((ClassPath)new LoaderClassPath(this.classLoader.getClassLoader()));
        }

        public Injector getInjector() {
            return this.injector;
        }

        public void setInjector(Injector injector) {
            this.injector = injector;
        }

        public ClassPool getClassPool() {
            return this.classPool;
        }

        public void setClassPool(ClassPool classPool) {
            this.classPool = classPool;
        }
    }
}

