/*
 * Decompiled with CFR 0.152.
 */
package net.csdn.http.server;

import java.io.IOException;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.SessionManager;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.eclipse.jetty.server.handler.HandlerList;
import org.eclipse.jetty.server.handler.ResourceHandler;
import org.eclipse.jetty.server.session.HashSessionManager;
import org.eclipse.jetty.server.session.SessionHandler;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.eclipse.jetty.util.thread.ThreadPool;

public class JettyServer {
    public Server createServer(String host, int port, int minThreads, int maxThreads, String staticDir, String templateDir, boolean staticEnable, boolean classPathEnable, boolean sessionEanble, AbstractHandler abstractHandler) {
        QueuedThreadPool threadPool = new QueuedThreadPool();
        threadPool.setMinThreads(minThreads);
        threadPool.setMaxThreads(maxThreads);
        Server server = new Server((ThreadPool)threadPool);
        HttpConfiguration httpConfig = new HttpConfiguration();
        ServerConnector connector = new ServerConnector(server, new ConnectionFactory[]{new HttpConnectionFactory(httpConfig)});
        connector.setPort(port);
        connector.setHost(host);
        server.addConnector((Connector)connector);
        HandlerList handlers = new HandlerList();
        if (staticEnable) {
            ResourceHandler resource_handler = new ResourceHandler();
            resource_handler.setDirectoriesListed(false);
            try {
                if (classPathEnable) {
                    String webDir = this.getClass().getClassLoader().getResource(staticDir).toExternalForm();
                    resource_handler.setBaseResource(Resource.newResource((String)webDir));
                } else {
                    resource_handler.setBaseResource(Resource.newResource((String)(templateDir + "/" + staticDir + "/")));
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            if (sessionEanble) {
                HashSessionManager sessionManager = new HashSessionManager();
                sessionManager.setSessionIdPathParameterName("none");
                handlers.setHandlers(new Handler[]{resource_handler, new SessionHandler((SessionManager)sessionManager), abstractHandler});
            } else {
                handlers.setHandlers(new Handler[]{resource_handler, abstractHandler});
            }
        } else {
            handlers.setHandlers(new Handler[]{abstractHandler});
        }
        server.setHandler((Handler)handlers);
        return server;
    }
}

