/*
 * Decompiled with CFR 0.152.
 */
package net.csdn.common.reflect;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashSet;
import java.util.List;
import net.csdn.common.collections.WowCollections;
import net.csdn.common.exception.ExceptionHandler;
import org.apache.commons.beanutils.MethodUtils;
import tech.mlsql.common.utils.collect.Lists;

public class ReflectHelper {
    public static List<Field> fields(Class clzz, Class annotation) {
        Field[] fields;
        List<Field> result = WowCollections.list(new Field[0]);
        for (Field field : fields = clzz.getDeclaredFields()) {
            if (!field.isAnnotationPresent(annotation)) continue;
            result.add(field);
        }
        return result;
    }

    public static List<Method> methods(Class clzz, Class annotation) {
        Method[] methods;
        List<Method> result = WowCollections.list(new Method[0]);
        for (Method method : methods = clzz.getDeclaredMethods()) {
            if (!method.isAnnotationPresent(annotation)) continue;
            result.add(method);
        }
        return result;
    }

    public static List<Field> findFieldsByAnnotation(Class clzz, Class annotation) {
        return ReflectHelper.fields(clzz, annotation);
    }

    public static List<Method> findMethodsByAnnotation(Class clzz, Class annotation) {
        return ReflectHelper.methods(clzz, annotation);
    }

    public static Field findField(Class clzz, String fieldName) {
        Field field;
        block2: {
            field = null;
            try {
                field = clzz.getDeclaredField(fieldName);
            }
            catch (Exception e) {
                if (clzz.getSuperclass() == null) break block2;
                field = ReflectHelper.findField(clzz.getSuperclass(), fieldName);
            }
        }
        return field;
    }

    public static Method findMethodByName(Class clzz, String methodName) {
        Method[] methods;
        Method result = null;
        for (Method method : methods = clzz.getDeclaredMethods()) {
            if (!method.getName().equals(methodName)) continue;
            result = method;
            break;
        }
        if (result == null && clzz.getSuperclass() != null) {
            result = ReflectHelper.findMethodByName(clzz.getSuperclass(), methodName);
        }
        return result;
    }

    public static void field(Object obj, String fieldName, Object value) throws Exception {
        Field field = ReflectHelper.findField(obj.getClass(), fieldName);
        field.setAccessible(true);
        field.set(obj, value);
    }

    public static Object field(Object obj, String fieldName) throws Exception {
        Field field = ReflectHelper.findField(obj.getClass(), fieldName);
        field.setAccessible(true);
        return field.get(obj);
    }

    public static Object staticField(Class obj, String fieldName) {
        Field field = ReflectHelper.findField(obj, fieldName);
        field.setAccessible(true);
        try {
            return field.get(null);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void staticField(Class obj, String fieldName, Object value) {
        Field field = ReflectHelper.findField(obj, fieldName);
        field.setAccessible(true);
        try {
            field.set(null, value);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }

    public static void field(Object obj, Class clzz, String fieldName, Object value) throws Exception {
        Field field = ReflectHelper.findField(clzz, fieldName);
        field.setAccessible(true);
        field.set(obj, value);
    }

    public static Object field(Object obj, Class clzz, String fieldName) throws Exception {
        Field field = ReflectHelper.findField(clzz, fieldName);
        field.setAccessible(true);
        return field.get(obj);
    }

    public static Method findTTMethod(Class clazz, String methodName, Class ... paramTypes) {
        Class superclass = clazz;
        try {
            return superclass.getDeclaredMethod(methodName, paramTypes);
        }
        catch (Exception e2) {
            while (true) {
                superclass = superclass.getSuperclass();
                try {
                    return superclass.getDeclaredMethod(methodName, paramTypes);
                }
                catch (NoSuchMethodException e) {
                    if (superclass != null && !Object.class.getName().equals(superclass.getName())) continue;
                    return null;
                }
                break;
            }
        }
    }

    public static List<Method> findTTMethods(Class clazz, String methodName) {
        HashSet<Method> methodSet = new HashSet<Method>();
        Class superclass = clazz;
        for (Method method : clazz.getDeclaredMethods()) {
            if (!method.getName().equals(methodName)) continue;
            methodSet.add(method);
        }
        do {
            superclass = superclass.getSuperclass();
            for (Method method : superclass.getDeclaredMethods()) {
                if (!method.getName().equals(methodName)) continue;
                methodSet.add(method);
            }
        } while (superclass != null && !Object.class.getName().equals(superclass.getName()));
        return Lists.newArrayList(methodSet);
    }

    public static void method2(Object obj, String methodName) {
        try {
            Method method = null;
            try {
                method = obj.getClass().getDeclaredMethod(methodName, new Class[0]);
            }
            catch (Exception e) {
                method = obj.getClass().getMethod(methodName, new Class[0]);
            }
            method.setAccessible(true);
            method.invoke(obj, new Object[0]);
        }
        catch (Exception e) {
            try {
                ExceptionHandler.renderHandle(e);
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }
    }

    public static Object method(Object obj, String methodName) {
        try {
            Method method = null;
            try {
                method = obj.getClass().getDeclaredMethod(methodName, new Class[0]);
            }
            catch (Exception e) {
                method = obj.getClass().getMethod(methodName, new Class[0]);
            }
            method.setAccessible(true);
            return method.invoke(obj, new Object[0]);
        }
        catch (Exception e) {
            try {
                ExceptionHandler.renderHandle(e);
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
            return null;
        }
    }

    public static Object staticMethod(Class obj, String methodName, Object ... params) {
        try {
            Method method = null;
            try {
                method = obj.getDeclaredMethod(methodName, ReflectHelper.paramsToTypes(params));
            }
            catch (Exception e) {
                try {
                    method = obj.getMethod(methodName, ReflectHelper.paramsToTypes(params));
                }
                catch (Exception e1) {
                    method = MethodUtils.getMatchingAccessibleMethod((Class)obj, (String)methodName, (Class[])ReflectHelper.paramsToTypes(params));
                }
            }
            if (!Modifier.isPublic(method.getModifiers())) {
                method.setAccessible(true);
            }
            return method.invoke(null, params);
        }
        catch (Exception e) {
            try {
                ExceptionHandler.renderHandle(e);
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
            return null;
        }
    }

    public static Object method(Object obj, String methodName, Object ... params) {
        try {
            Method method = null;
            try {
                method = obj.getClass().getDeclaredMethod(methodName, ReflectHelper.paramsToTypes(params));
            }
            catch (Exception e) {
                try {
                    method = obj.getClass().getMethod(methodName, ReflectHelper.paramsToTypes(params));
                }
                catch (Exception e1) {
                    method = MethodUtils.getMatchingAccessibleMethod(obj.getClass(), (String)methodName, (Class[])ReflectHelper.paramsToTypes(params));
                }
            }
            method.setAccessible(true);
            return method.invoke(obj, params);
        }
        catch (Exception e) {
            try {
                ExceptionHandler.renderHandle(e);
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
            return null;
        }
    }

    public static Class[] paramsToTypes(Object ... params) {
        Class[] clzz = new Class[params.length];
        int i = 0;
        for (Object tt : params) {
            clzz[i++] = tt.getClass();
        }
        return clzz;
    }

    public static Annotation[] annotation(Object obj, String fieldName) throws Exception {
        Field field = obj.getClass().getDeclaredField(fieldName);
        return field.getAnnotations();
    }
}

