/*
 * Decompiled with CFR 0.152.
 */
package net.csdn.common.scan;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import net.csdn.common.scan.ScanService;
import tech.mlsql.common.utils.collect.UnmodifiableIterator;
import tech.mlsql.common.utils.reflect.ClassPath;

public class DefaultScanService
implements ScanService {
    private Class loader = DefaultScanService.class;

    @Override
    public Class getLoader() {
        return this.loader;
    }

    @Override
    public void setLoader(Class loader) {
        this.loader = loader;
    }

    @Override
    public List<InputStream> scanArchives(String packageName) throws IOException {
        return this.scanArchives(packageName);
    }

    @Override
    public List<Class> scanArchives(String packageName, ScanService.LoadClassEnhanceCallBack loadClassEnhanceCallBack) throws IOException {
        UnmodifiableIterator classinfos = ClassPath.from((ClassLoader)this.loader.getClassLoader()).getTopLevelClassesRecursive(packageName).iterator();
        ArrayList<URL> urlList = new ArrayList<URL>();
        while (classinfos.hasNext()) {
            ClassPath.ClassInfo info = (ClassPath.ClassInfo)classinfos.next();
            urlList.add(info.url());
        }
        URL[] res = new URL[urlList.size()];
        return this.scanClass(this.scanArchives(urlList.toArray(res)), loadClassEnhanceCallBack);
    }

    @Override
    public List<InputStream> scanArchives(URL ... urls) throws IOException {
        ArrayList<InputStream> streamList = new ArrayList<InputStream>();
        for (URL url : urls) {
            String protocol = url.getProtocol();
            if (protocol == "file") {
                streamList.add(new FileInputStream(new File(url.getFile())));
                continue;
            }
            if (protocol == "jar") {
                streamList.add(this.loader.getResourceAsStream(url.getFile().split("\\.jar!")[1]));
                continue;
            }
            throw new RuntimeException(url.toString() + " is not supported");
        }
        return streamList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Class scanClass(InputStream bits, ScanService.LoadClassEnhanceCallBack loadClassEnhanceCallBack) throws IOException {
        DataInputStream dstream = new DataInputStream(new BufferedInputStream(bits));
        try {
            Class clazz = loadClassEnhanceCallBack.loaded(dstream);
            return clazz;
        }
        catch (Exception e) {
            e.printStackTrace();
            Class clazz = null;
            return clazz;
        }
        finally {
            dstream.close();
            bits.close();
        }
    }

    @Override
    public List<Class> scanClass(List<InputStream> inputStreams, ScanService.LoadClassEnhanceCallBack loadClassEnhanceCallBack) throws IOException {
        ArrayList<Class> classList = new ArrayList<Class>();
        for (InputStream inputStream : inputStreams) {
            classList.add(this.scanClass(inputStream, loadClassEnhanceCallBack));
        }
        return classList;
    }
}

