/*
 * Decompiled with CFR 0.152.
 */
package net.csdn.common.network;

import java.lang.reflect.Method;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import net.csdn.common.logging.CSLogger;
import net.csdn.common.logging.Loggers;
import tech.mlsql.common.utils.collect.Lists;

public class NetworkUtils {
    private static final CSLogger logger = Loggers.getLogger(NetworkUtils.class);
    public static final String IPv4_SETTING = "java.net.preferIPv4Stack";
    public static final String IPv6_SETTING = "java.net.preferIPv6Addresses";
    public static final String NON_LOOPBACK_ADDRESS = "non_loopback_address";
    private static InetAddress localAddress;
    private static InetAddress intranet_ip;

    public static void main(String[] args) {
        System.out.println(intranet_ip.getHostAddress());
    }

    public static InetAddress local_address() {
        return localAddress;
    }

    public static InetAddress intranet_ip() {
        return intranet_ip;
    }

    public static boolean isIPv4() {
        return System.getProperty(IPv4_SETTING) != null && System.getProperty(IPv4_SETTING).equals("true");
    }

    public static InetAddress getFirstNonLoopbackAddress(StackType ip_version) {
        try {
            InetAddress address = null;
            Enumeration<NetworkInterface> intfs = NetworkInterface.getNetworkInterfaces();
            ArrayList intfsList = Lists.newArrayList();
            while (intfs.hasMoreElements()) {
                intfsList.add(intfs.nextElement());
            }
            try {
                final Method getIndexMethod = NetworkInterface.class.getDeclaredMethod("getIndex", new Class[0]);
                getIndexMethod.setAccessible(true);
                Collections.sort(intfsList, new Comparator<NetworkInterface>(){

                    @Override
                    public int compare(NetworkInterface o1, NetworkInterface o2) {
                        try {
                            return (Integer)getIndexMethod.invoke((Object)o1, new Object[0]) - (Integer)getIndexMethod.invoke((Object)o2, new Object[0]);
                        }
                        catch (Exception e) {
                            throw new IllegalArgumentException("failed to fetch index of network interface");
                        }
                    }
                });
            }
            catch (Exception exception) {
                // empty catch block
            }
            for (NetworkInterface intf : intfsList) {
                if (!intf.isUp() || intf.isLoopback() || (address = NetworkUtils.getFirstNonLoopbackAddress(intf, ip_version)) == null) continue;
                return address;
            }
        }
        catch (SocketException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static InetAddress getFirstNonLoopbackAddress(NetworkInterface intf, StackType ipVersion) throws SocketException {
        if (intf == null) {
            throw new IllegalArgumentException("Network interface pointer is null");
        }
        Enumeration<InetAddress> addresses = intf.getInetAddresses();
        while (addresses.hasMoreElements()) {
            InetAddress address = addresses.nextElement();
            if (address.isLoopbackAddress() || (!(address instanceof Inet4Address) || ipVersion != StackType.IPv4) && (!(address instanceof Inet6Address) || ipVersion != StackType.IPv6)) continue;
            return address;
        }
        return null;
    }

    public static List<NetworkInterface> getAllAvailableInterfaces() throws SocketException {
        ArrayList<NetworkInterface> allInterfaces = new ArrayList<NetworkInterface>(10);
        Enumeration<NetworkInterface> en = NetworkInterface.getNetworkInterfaces();
        while (en.hasMoreElements()) {
            NetworkInterface intf = en.nextElement();
            allInterfaces.add(intf);
        }
        return allInterfaces;
    }

    public static Collection<InetAddress> getAllAvailableAddresses() {
        HashSet<InetAddress> retval = new HashSet<InetAddress>();
        try {
            Enumeration<NetworkInterface> en = NetworkInterface.getNetworkInterfaces();
            if (en == null) {
                return retval;
            }
            while (en.hasMoreElements()) {
                NetworkInterface intf = en.nextElement();
                Enumeration<InetAddress> addrs = intf.getInetAddresses();
                while (addrs.hasMoreElements()) {
                    retval.add(addrs.nextElement());
                }
            }
        }
        catch (SocketException e) {
            logger.warn("Failed to derive all available interfaces", e, new Object[0]);
        }
        return retval;
    }

    private NetworkUtils() {
    }

    static {
        InetAddress localAddressX = null;
        Object intranet_ip_x = null;
        try {
            localAddressX = InetAddress.getLocalHost();
        }
        catch (Exception e) {
            logger.warn("Failed to find local hostAndPort", e, new Object[0]);
        }
        localAddress = localAddressX;
        Collection<InetAddress> inetAddresses = NetworkUtils.getAllAvailableAddresses();
        for (InetAddress ia : inetAddresses) {
            if (!ia.getHostAddress().startsWith("192.168")) continue;
            intranet_ip = ia;
            break;
        }
        if (intranet_ip == null) {
            try {
                intranet_ip = NetworkUtils.getFirstNonLoopbackAddress(StackType.IPv4);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static enum StackType {
        IPv4,
        IPv6,
        Unknown;

    }
}

