/*
 * Decompiled with CFR 0.152.
 */
package net.csdn.common.logging.log4j;

import java.util.Map;
import java.util.Properties;
import net.csdn.common.collect.MapBuilder;
import net.csdn.common.env.Environment;
import net.csdn.common.settings.ImmutableSettings;
import net.csdn.common.settings.Settings;
import org.apache.log4j.PropertyConfigurator;
import tech.mlsql.common.utils.collect.ImmutableMap;

public class LogConfigurator {
    private static boolean loaded;
    private static ImmutableMap<String, String> replacements;

    public static void configure(Settings settings) {
        if (loaded) {
            return;
        }
        loaded = true;
        Environment environment = new Environment(settings);
        ImmutableSettings.Builder settingsBuilder = ImmutableSettings.settingsBuilder().put(settings);
        settingsBuilder.loadFromUrl(environment.resolveConfig("logging.yml")).replacePropertyPlaceholders();
        Properties props = new Properties();
        for (Map.Entry entry : settingsBuilder.build().getAsMap().entrySet()) {
            String key = "log4j." + (String)entry.getKey();
            String value = (String)entry.getValue();
            if (replacements.containsKey((Object)value)) {
                value = (String)replacements.get((Object)value);
            }
            if (key.endsWith(".value")) {
                props.setProperty(key.substring(0, key.length() - ".value".length()), value);
                continue;
            }
            if (key.endsWith(".type")) {
                props.setProperty(key.substring(0, key.length() - ".type".length()), value);
                continue;
            }
            props.setProperty(key, value);
        }
        PropertyConfigurator.configure((Properties)props);
    }

    static {
        replacements = new MapBuilder<String, String>().put("console", "net.csdn.common.logging.log4j.ConsoleAppender").put("async", "org.apache.log4j.AsyncAppender").put("dailyRollingFile", "org.apache.log4j.DailyRollingFileAppender").put("externallyRolledFile", "org.apache.log4j.ExternallyRolledFileAppender").put("file", "org.apache.log4j.FileAppender").put("hadoo", "org.apache.log4j.FileAppender").put("jdbc", "org.apache.log4j.jdbc.JDBCAppender").put("jms", "org.apache.log4j.net.JMSAppender").put("lf5", "org.apache.log4j.lf5.LF5Appender").put("ntevent", "org.apache.log4j.nt.NTEventLogAppender").put("null", "org.apache.log4j.NullAppender").put("rollingFile", "org.apache.log4j.RollingFileAppender").put("smtp", "org.apache.log4j.net.SMTPAppender").put("socket", "org.apache.log4j.net.SocketAppender").put("socketHub", "org.apache.log4j.net.SocketHubAppender").put("syslog", "org.apache.log4j.net.SyslogAppender").put("telnet", "org.apache.log4j.net.TelnetAppender").put("simple", "org.apache.log4j.SimpleLayout").put("html", "org.apache.log4j.HTMLLayout").put("pattern", "org.apache.log4j.PatternLayout").put("consolePattern", "net.csdn.common.logging.log4j.JLinePatternLayout").put("ttcc", "org.apache.log4j.TTCCLayout").put("xml", "org.apache.log4j.XMLLayout").immutableMap();
    }
}

