/*
 * Decompiled with CFR 0.152.
 */
package net.csdn.common;

import java.lang.reflect.Modifier;

public class Classes {
    private static final char PACKAGE_SEPARATOR = '.';

    public static ClassLoader getDefaultClassLoader() {
        ClassLoader cl = null;
        try {
            cl = Thread.currentThread().getContextClassLoader();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (cl == null) {
            cl = Classes.class.getClassLoader();
        }
        return cl;
    }

    public static String getPackageName(Class clazz) {
        String className = clazz.getName();
        int lastDotIndex = className.lastIndexOf(46);
        return lastDotIndex != -1 ? className.substring(0, lastDotIndex) : "";
    }

    public static String getPackageNameNoDomain(Class clazz) {
        String fullPackage = Classes.getPackageName(clazz);
        if (fullPackage.startsWith("org.") || fullPackage.startsWith("com.") || fullPackage.startsWith("net.")) {
            return fullPackage.substring(4);
        }
        return fullPackage;
    }

    public static boolean isInnerClass(Class<?> clazz) {
        return !Modifier.isStatic(clazz.getModifiers()) && clazz.getEnclosingClass() != null;
    }

    public static boolean isConcrete(Class<?> clazz) {
        int modifiers = clazz.getModifiers();
        return !clazz.isInterface() && !Modifier.isAbstract(modifiers);
    }

    private Classes() {
    }
}

