/*
 * Decompiled with CFR 0.152.
 */
package net.csdn.modules.transport;

import com.google.inject.Inject;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import net.csdn.common.collect.Tuple;
import net.csdn.common.collections.WowCollections;
import net.csdn.common.logging.CSLogger;
import net.csdn.common.logging.Loggers;
import net.csdn.common.path.Url;
import net.csdn.common.settings.Settings;
import net.csdn.modules.http.RestRequest;
import net.csdn.modules.http.support.HttpStatus;
import net.csdn.modules.threadpool.ThreadPoolService;
import net.csdn.modules.transport.HttpTransportService;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.client.HttpClient;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpOptions;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.PoolingClientConnectionManager;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultHttpTransportService
implements HttpTransportService {
    private final HttpClient httpClient;
    private CSLogger logger = Loggers.getLogger(this.getClass());
    public static final String charset = "utf-8";
    private static final Tuple<String, String> content_type = new Tuple((Object)"Content-Type", (Object)"application/x-www-form-urlencoded");
    @Inject
    private ThreadPoolService threadPoolService;
    @Inject
    private Settings settings;
    private static final Map<String, String> EMPTY_MAP = WowCollections.map((Object[])new Object[0]);

    public DefaultHttpTransportService() {
        PoolingClientConnectionManager poolingClientConnectionManager = new PoolingClientConnectionManager();
        poolingClientConnectionManager.setMaxTotal(50);
        poolingClientConnectionManager.setDefaultMaxPerRoute(25);
        this.httpClient = new DefaultHttpClient((ClientConnectionManager)poolingClientConnectionManager);
        int timeout = 2;
        this.httpClient.getParams().setParameter("http.socket.timeout", (Object)(timeout * 1000));
        this.httpClient.getParams().setParameter("http.connection.timeout", (Object)(timeout * 1000));
        this.httpClient.getParams().setParameter("http.connection-manager.timeout", (Object)new Long(timeout * 1000));
    }

    @Override
    public void header(String header, String value) {
        this.httpClient.getParams().setParameter(header, (Object)value);
    }

    @Override
    public HttpTransportService.SResponse post(Url url, Map data) {
        return this.post(url, data, EMPTY_MAP);
    }

    @Override
    public HttpTransportService.SResponse post(Url url, Map data, Map<String, String> headers) {
        HttpPost post = null;
        try {
            post = new HttpPost(url.toURI());
            UrlEncodedFormEntity urlEncodedFormEntity = new UrlEncodedFormEntity(this.mapToNameValuesPairs(data), charset);
            post.setHeader((String)content_type.v1(), (String)content_type.v2());
            if (headers != null) {
                for (Map.Entry<String, String> entry : headers.entrySet()) {
                    post.setHeader(entry.getKey(), entry.getValue());
                }
            }
            post.setEntity((HttpEntity)urlEncodedFormEntity);
            HttpResponse response = this.httpClient.execute((HttpUriRequest)post);
            return new HttpTransportService.SResponse(response.getStatusLine().getStatusCode(), EntityUtils.toString((HttpEntity)response.getEntity(), (String)charset), url);
        }
        catch (Exception e) {
            if (post != null) {
                post.abort();
            }
            this.logger.error("Error when remote search url:[{}] ", new Object[]{url.toString()});
            return null;
        }
    }

    @Override
    public HttpTransportService.SResponse put(Url url, Map data) {
        return this.put(url, data, EMPTY_MAP);
    }

    @Override
    public HttpTransportService.SResponse put(Url url, Map data, Map<String, String> headers) {
        HttpPut put = null;
        try {
            put = new HttpPut(url.toURI());
            UrlEncodedFormEntity urlEncodedFormEntity = new UrlEncodedFormEntity(this.mapToNameValuesPairs(data), charset);
            put.setHeader((String)content_type.v1(), (String)content_type.v2());
            if (headers != null) {
                for (Map.Entry<String, String> entry : headers.entrySet()) {
                    put.setHeader(entry.getKey(), entry.getValue());
                }
            }
            put.setEntity((HttpEntity)urlEncodedFormEntity);
            HttpResponse response = this.httpClient.execute((HttpUriRequest)put);
            return new HttpTransportService.SResponse(response.getStatusLine().getStatusCode(), EntityUtils.toString((HttpEntity)response.getEntity(), (String)charset), url);
        }
        catch (Exception e) {
            this.logger.error(this.getClass().getName() + " error when visit url:[{}] ", new Object[]{url.toString()});
            if (put != null) {
                put.abort();
            }
            return null;
        }
    }

    @Override
    public HttpTransportService.SResponse http(Url url, String jsonData, RestRequest.Method method) {
        return this.http(url, jsonData, EMPTY_MAP, method);
    }

    @Override
    public HttpTransportService.SResponse http(Url url, String jsonData, Map<String, String> headers, RestRequest.Method method) {
        HttpRequestBase httpRequestBase = null;
        try {
            httpRequestBase = this.createMethod(url, jsonData, method);
            if (headers != null) {
                for (Map.Entry<String, String> entry : headers.entrySet()) {
                    httpRequestBase.setHeader(entry.getKey(), entry.getValue());
                }
            }
            HttpResponse response = this.httpClient.execute((HttpUriRequest)httpRequestBase);
            return new HttpTransportService.SResponse(response.getStatusLine().getStatusCode(), EntityUtils.toString((HttpEntity)response.getEntity(), (String)charset), url);
        }
        catch (Exception e) {
            if (httpRequestBase != null) {
                httpRequestBase.abort();
            }
            return new HttpTransportService.SResponse(HttpStatus.HttpStatusServerDown, "", url);
        }
    }

    @Override
    public HttpTransportService.SResponse http(final Url url, final String jsonData, final RestRequest.Method method, int timeout) {
        HttpTransportService.SResponse response = (HttpTransportService.SResponse)this.threadPoolService.runWithTimeout(timeout, new ThreadPoolService.Run<Object>(){

            @Override
            public Object run() {
                return DefaultHttpTransportService.this.http(url, jsonData, method);
            }
        });
        return response;
    }

    @Override
    public HttpTransportService.SResponse http(final Url url, final String jsonData, final Map<String, String> headers, final RestRequest.Method method, int timeout) {
        HttpTransportService.SResponse response = (HttpTransportService.SResponse)this.threadPoolService.runWithTimeout(timeout, new ThreadPoolService.Run<Object>(){

            @Override
            public Object run() {
                return DefaultHttpTransportService.this.http(url, jsonData, headers, method);
            }
        });
        return response;
    }

    @Override
    public HttpTransportService.SResponse post(final Url url, final Map data, final Map<String, String> headers, int timeout) {
        HttpTransportService.SResponse response = (HttpTransportService.SResponse)this.threadPoolService.runWithTimeout(timeout, new ThreadPoolService.Run<Object>(){

            @Override
            public Object run() {
                return DefaultHttpTransportService.this.post(url, data, headers);
            }
        });
        return response;
    }

    @Override
    public HttpTransportService.SResponse post(final Url url, final Map data, int timeout) {
        HttpTransportService.SResponse response = (HttpTransportService.SResponse)this.threadPoolService.runWithTimeout(timeout, new ThreadPoolService.Run<Object>(){

            @Override
            public Object run() {
                return DefaultHttpTransportService.this.post(url, data);
            }
        });
        return response;
    }

    @Override
    public FutureTask<HttpTransportService.SResponse> asyncHttp(final Url url, final String jsonData, final RestRequest.Method method) {
        FutureTask<HttpTransportService.SResponse> getRemoteDataTask = new FutureTask<HttpTransportService.SResponse>(new Callable<HttpTransportService.SResponse>(){

            @Override
            public HttpTransportService.SResponse call() throws Exception {
                return DefaultHttpTransportService.this.http(url, jsonData, method);
            }
        });
        this.threadPoolService.executor("search").execute(getRemoteDataTask);
        return getRemoteDataTask;
    }

    @Override
    public List<HttpTransportService.SResponse> asyncHttps(List<Url> urls, String jsonData, RestRequest.Method method) {
        ArrayList<HttpTransportService.SResponse> responses = new ArrayList<HttpTransportService.SResponse>(urls.size());
        ArrayList<FutureTask<HttpTransportService.SResponse>> futureTasks = new ArrayList<FutureTask<HttpTransportService.SResponse>>(urls.size());
        for (int i = 0; i < urls.size(); ++i) {
            Url url = urls.get(i);
            FutureTask<HttpTransportService.SResponse> getRemoteDataTask = this.asyncHttp(url, jsonData, method);
            futureTasks.add(getRemoteDataTask);
        }
        for (FutureTask futureTask : futureTasks) {
            try {
                HttpTransportService.SResponse sResponse = (HttpTransportService.SResponse)futureTask.get(5L, TimeUnit.SECONDS);
                responses.add(sResponse);
            }
            catch (Exception e) {
                e.printStackTrace();
                futureTask.cancel(true);
            }
        }
        return responses;
    }

    private HttpRequestBase createMethod(Url url, String jsonData, RestRequest.Method method) {
        HttpGet httpRequestBase;
        URI uri = url.toURI();
        if (method == RestRequest.Method.GET) {
            httpRequestBase = new HttpGet(uri);
        } else if (method == RestRequest.Method.PUT) {
            httpRequestBase = new HttpPut(uri);
            if (jsonData != null && !jsonData.isEmpty()) {
                ((HttpPut)httpRequestBase).setEntity((HttpEntity)this.stringEntity(jsonData));
            }
        } else if (method == RestRequest.Method.DELETE) {
            if (jsonData != null && !jsonData.isEmpty()) {
                httpRequestBase = new HttpPost(uri);
                url.addParam("_method", "DELETE");
                ((HttpPost)httpRequestBase).setEntity((HttpEntity)this.stringEntity(jsonData));
            } else {
                httpRequestBase = new HttpDelete(uri);
            }
        } else if (method == RestRequest.Method.HEAD) {
            httpRequestBase = new HttpHead(uri);
        } else if (method == RestRequest.Method.OPTIONS) {
            httpRequestBase = new HttpOptions(uri);
        } else {
            httpRequestBase = new HttpPost(uri);
            if (jsonData != null && !jsonData.isEmpty()) {
                ((HttpPost)httpRequestBase).setEntity((HttpEntity)this.stringEntity(jsonData));
            }
        }
        return httpRequestBase;
    }

    private StringEntity stringEntity(String jsonData) {
        try {
            return new StringEntity(jsonData, charset);
        }
        catch (UnsupportedEncodingException e) {
            this.logger.error(this.getClass().getName() + "UnsupportedEncodingException e=>" + e.getMessage(), new Object[0]);
            return null;
        }
    }

    private List<NameValuePair> mapToNameValuesPairs(Map data) {
        ArrayList<NameValuePair> params = new ArrayList<NameValuePair>();
        for (Object key : data.keySet()) {
            params.add((NameValuePair)new BasicNameValuePair((String)key, (String)data.get(key)));
        }
        return params;
    }

    public void shutdownTransport() {
        this.httpClient.getConnectionManager().shutdown();
    }
}

