/*
 * Decompiled with CFR 0.152.
 */
package net.csdn.modules.thrift;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.csdn.common.logging.CSLogger;
import net.csdn.common.logging.Loggers;
import net.csdn.modules.thrift.ThriftConnectException;
import net.csdn.modules.thrift.pool.BaseObjectPool;
import net.csdn.modules.thrift.pool.NoValidObjectException;
import net.csdn.modules.thrift.pool.ObjectPool;
import net.csdn.modules.thrift.pool.PoolExhaustedException;
import net.csdn.modules.thrift.pool.PoolableObjectFactory;
import org.apache.thrift.TServiceClient;
import org.apache.thrift.protocol.TCompactProtocol;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.transport.TSocket;
import org.apache.thrift.transport.TTransport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ThriftClient<T extends TServiceClient> {
    private CSLogger logger = Loggers.getLogger(ThriftClient.class);
    private final int connectTimeoutInMillis = 1000;
    private Class<T> hold;
    private static final Map<Class, ThriftClient> pools = new ConcurrentHashMap<Class, ThriftClient>();
    final ObjectPool<String, T> connectionPool = new BaseObjectPool.Builder(new PoolableObjectFactory<String, T>(){

        @Override
        public T createObject(String key) throws Exception {
            String[] socketInfo = key.split(":");
            TSocket transport = new TSocket(socketInfo[0], Integer.parseInt(socketInfo[1]));
            transport.open();
            TCompactProtocol protocol = new TCompactProtocol((TTransport)transport);
            return (TServiceClient)ThriftClient.this.hold.getConstructor(TProtocol.class).newInstance(protocol);
        }

        @Override
        public void destroyObject(String key, T value) throws Exception {
            if (value != null) {
                TProtocol inputTProtocol = value.getInputProtocol();
                this.closeTransport(inputTProtocol);
                TProtocol outputTProtocol = value.getOutputProtocol();
                this.closeTransport(outputTProtocol);
            }
        }

        private void closeTransport(TProtocol protocol) {
            if (protocol == null) {
                return;
            }
            TTransport transport = protocol.getTransport();
            try {
                if (transport != null && transport.isOpen()) {
                    transport.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        @Override
        public boolean validateObject(String key, T value) throws Exception {
            return true;
        }
    }).borrowValidation(true).min(5).max(5).build();

    public static synchronized ThriftClient build(Class type) {
        if (pools.containsKey(type)) {
            return pools.get(type);
        }
        ThriftClient thriftClient = new ThriftClient();
        thriftClient.hold = type;
        pools.put(type, thriftClient);
        return thriftClient;
    }

    private ThriftClient() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(String address, Callback<T> callback) throws ThriftConnectException {
        T obj = this.brow(address);
        try {
            callback.execute(obj);
        }
        finally {
            this.back(address, obj);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void tryExecute(String address, Callback<T> callback) throws ThriftConnectException {
        T obj = null;
        int failCount = 0;
        boolean shouldTry = true;
        while (shouldTry && failCount < 4) {
            try {
                obj = this.brow(address);
                shouldTry = false;
            }
            catch (ThriftConnectException e) {
                e.printStackTrace();
                try {
                    Thread.sleep(3000L);
                }
                catch (InterruptedException e1) {
                    e1.printStackTrace();
                }
                if (++failCount != 4) continue;
                throw e;
            }
        }
        try {
            callback.execute(obj);
        }
        finally {
            this.back(address, obj);
        }
    }

    public T brow(String socketAddress) throws ThriftConnectException {
        try {
            return (T)((TServiceClient)this.connectionPool.borrowObject(socketAddress, 1000L));
        }
        catch (PoolExhaustedException e) {
            e.printStackTrace();
            throw new ThriftConnectException(e);
        }
        catch (NoValidObjectException e) {
            e.printStackTrace();
            throw new ThriftConnectException(e);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            return null;
        }
    }

    public void back(String socketAddress, T value) {
        try {
            this.connectionPool.returnObject(socketAddress, value);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Callback<T> {
        public void execute(T var1);
    }
}

