/*
 * Decompiled with CFR 0.152.
 */
package net.csdn.modules.threadpool;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.inject.Inject;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.FutureTask;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import net.csdn.common.settings.Settings;
import net.csdn.common.unit.TimeValue;
import net.csdn.modules.threadpool.ThreadPoolService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultThreadPoolService
implements ThreadPoolService {
    private Settings settings;
    private final ImmutableMap<String, Executor> executors;
    private final ScheduledExecutorService scheduler;

    @Inject
    public DefaultThreadPoolService(Settings settings) {
        this.settings = settings;
        HashMap executors = Maps.newHashMap();
        executors.put("search", this.build("search"));
        executors.put("refresh", this.build("refresh"));
        executors.put("cached", this.buildCache("cached"));
        this.executors = ImmutableMap.copyOf((Map)executors);
        this.scheduler = Executors.newScheduledThreadPool(1, Executors.defaultThreadFactory());
    }

    @Override
    public <T> T runWithTimeout(int timeValue, final ThreadPoolService.Run<T> run) {
        FutureTask futureTask = new FutureTask(new Callable<T>(){

            @Override
            public T call() throws Exception {
                return run.run();
            }
        });
        this.executor("cached").execute(futureTask);
        try {
            return (T)futureTask.get(timeValue, TimeUnit.MILLISECONDS);
        }
        catch (Exception e) {
            futureTask.cancel(true);
            return null;
        }
    }

    public DefaultThreadPoolService start() {
        return this;
    }

    @Override
    public Executor executor(String name) {
        Executor executor = (Executor)this.executors.get((Object)name);
        if (executor == null) {
            throw new IllegalArgumentException("No executor found for [" + name + "]");
        }
        return executor;
    }

    public ScheduledFuture<?> scheduleWithFixedDelay(Runnable command, TimeValue interval) {
        return this.scheduler.scheduleWithFixedDelay(command, interval.millis(), interval.millis(), TimeUnit.MILLISECONDS);
    }

    public void shutdown() {
        this.scheduler.shutdown();
        for (Executor executor : this.executors.values()) {
            if (!(executor instanceof ThreadPoolExecutor)) continue;
            ((ThreadPoolExecutor)executor).shutdown();
        }
    }

    public void shutdownNow() {
        this.scheduler.shutdownNow();
        for (Executor executor : this.executors.values()) {
            if (!(executor instanceof ThreadPoolExecutor)) continue;
            ((ThreadPoolExecutor)executor).shutdownNow();
        }
    }

    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        boolean result = this.scheduler.awaitTermination(timeout, unit);
        for (Executor executor : this.executors.values()) {
            if (!(executor instanceof ThreadPoolExecutor)) continue;
            result &= ((ThreadPoolExecutor)executor).awaitTermination(timeout, unit);
        }
        return result;
    }

    public Executor build(String name) {
        return new ThreadPoolExecutor(0, Integer.MAX_VALUE, 5L, TimeUnit.MINUTES, new SynchronousQueue<Runnable>(), Executors.defaultThreadFactory());
    }

    public Executor buildCache(String name) {
        return new ThreadPoolExecutor(5, 1000, 1L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), Executors.defaultThreadFactory());
    }
}

