/*
 * Decompiled with CFR 0.152.
 */
package net.csdn.modules.mock;

import java.util.Map;
import java.util.regex.Pattern;
import net.csdn.common.Booleans;
import net.csdn.common.Unicode;
import net.csdn.common.unit.ByteSizeValue;
import net.csdn.common.unit.TimeValue;
import net.csdn.modules.http.RestRequest;
import net.csdn.modules.http.RestUtils;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MockRestRequest
implements RestRequest {
    private static final Pattern commaPattern = Pattern.compile(",");
    private final RestRequest.Method method;
    private final Map<String, String> params;
    private final String rawPath;
    private byte[] content = new byte[0];

    public MockRestRequest(Map<String, String> params, RestRequest.Method method, String bodyContentNotForm) {
        this.method = method;
        this.params = params;
        this.rawPath = "";
        if (bodyContentNotForm != null) {
            try {
                this.content = bodyContentNotForm.getBytes();
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Fail to parse request params");
            }
        }
    }

    public MockRestRequest(String path, Map<String, String> params, RestRequest.Method requestMethod, String bodyContentNotForm) {
        this.method = requestMethod;
        this.params = params;
        this.rawPath = path;
        if (bodyContentNotForm != null) {
            try {
                this.content = bodyContentNotForm.getBytes();
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Fail to parse request params");
            }
        }
    }

    @Override
    public RestRequest.Method method() {
        return this.method;
    }

    @Override
    public String uri() {
        return null;
    }

    @Override
    public String rawPath() {
        return this.rawPath;
    }

    @Override
    public String url() {
        return null;
    }

    @Override
    public String queryString() {
        return null;
    }

    @Override
    public boolean hasContent() {
        return this.content.length > 0;
    }

    @Override
    public boolean contentUnsafe() {
        return false;
    }

    @Override
    public byte[] contentByteArray() {
        return this.content;
    }

    @Override
    public int contentByteArrayOffset() {
        return 0;
    }

    @Override
    public int contentLength() {
        return this.content.length;
    }

    @Override
    public String contentAsString() {
        return Unicode.fromBytes((byte[])this.contentByteArray(), (int)this.contentByteArrayOffset(), (int)this.contentLength());
    }

    @Override
    public String header(String name) {
        return null;
    }

    @Override
    public Map<String, String> params() {
        return this.params;
    }

    @Override
    public String cookie(String name) {
        return null;
    }

    @Override
    public Object session(String key) {
        return null;
    }

    @Override
    public void session(String key, Object value) {
    }

    @Override
    public Object flash(String key) {
        return null;
    }

    @Override
    public void flash(String key, Object value) {
    }

    @Override
    public boolean hasParam(String key) {
        return this.params.containsKey(key);
    }

    @Override
    public String param(String key) {
        return this.params.get(key);
    }

    @Override
    public String paramMultiKey(String ... keys) {
        for (String key : keys) {
            String temp = this.param(key);
            if (StringUtils.isEmpty((String)temp)) continue;
            return temp;
        }
        return null;
    }

    @Override
    public String param(String key, String defaultValue) {
        String value = this.params.get(key);
        if (value == null) {
            return defaultValue;
        }
        return value;
    }

    @Override
    public final String path() {
        return RestUtils.decodeComponent(this.rawPath());
    }

    @Override
    public float paramAsFloat(String key, float defaultValue) {
        String sValue = this.param(key);
        if (sValue == null) {
            return defaultValue;
        }
        try {
            return Float.parseFloat(sValue);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Failed to parse float parameter [" + key + "] with value [" + sValue + "]", e);
        }
    }

    @Override
    public int paramAsInt(String key, int defaultValue) {
        String sValue = this.param(key);
        if (sValue == null) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(sValue);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Failed to parse int parameter [" + key + "] with value [" + sValue + "]", e);
        }
    }

    @Override
    public long paramAsLong(String key, long defaultValue) {
        String sValue = this.param(key);
        if (sValue == null) {
            return defaultValue;
        }
        try {
            return Long.parseLong(sValue);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Failed to parse int parameter [" + key + "] with value [" + sValue + "]", e);
        }
    }

    @Override
    public boolean paramAsBoolean(String key, boolean defaultValue) {
        return Booleans.parseBoolean((String)this.param(key), (boolean)defaultValue);
    }

    @Override
    public Boolean paramAsBoolean(String key, Boolean defaultValue) {
        String sValue = this.param(key);
        if (sValue == null) {
            return defaultValue;
        }
        return !sValue.equals("false") && !sValue.equals("0") && !sValue.equals("off");
    }

    @Override
    public TimeValue paramAsTime(String key, TimeValue defaultValue) {
        return TimeValue.parseTimeValue((String)this.param(key), (TimeValue)defaultValue);
    }

    @Override
    public ByteSizeValue paramAsSize(String key, ByteSizeValue defaultValue) {
        return ByteSizeValue.parseBytesSizeValue((String)this.param(key), (ByteSizeValue)defaultValue);
    }

    @Override
    public String[] paramAsStringArray(String key, String[] defaultValue) {
        String value = this.param(key);
        if (value == null) {
            return defaultValue;
        }
        return commaPattern.split(value);
    }
}

