/*
 * Decompiled with CFR 0.152.
 */
package net.csdn.modules.log;

import com.google.inject.Inject;
import java.io.IOException;
import net.csdn.common.env.Environment;
import net.csdn.common.settings.Settings;
import net.csdn.modules.log.SystemLogger;
import org.apache.log4j.DailyRollingFileAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;

public class SystemLoggerImpl
implements SystemLogger {
    private Logger applicationLogger;
    private Logger behaviorLogger;
    private Logger healthLogger;
    private Settings settings;

    @Inject
    public SystemLoggerImpl(Settings settings) {
        this.settings = settings;
        this.applicationLogger = this.createLogger("sapplication");
        this.behaviorLogger = this.createLogger("sbehavior");
        this.healthLogger = this.createLogger("shealth");
    }

    public Logger applicationLogger() {
        return this.applicationLogger;
    }

    public Logger behaviorLogger() {
        return this.behaviorLogger;
    }

    public Logger healthLogger() {
        return this.healthLogger;
    }

    private Logger createLogger(String name) {
        Logger logger = Logger.getLogger((String)name);
        PatternLayout layout = new PatternLayout("%m%n");
        DailyRollingFileAppender appender = null;
        try {
            Environment environment = new Environment(this.settings);
            appender = new DailyRollingFileAppender((Layout)layout, environment.logsFile().getPath() + "/" + name + "/" + name, "'.'yyyy-MM-dd");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        logger.addAppender(appender);
        return logger;
    }
}

