/*
 * Decompiled with CFR 0.152.
 */
package net.csdn.modules.http;

import com.google.common.base.Charsets;
import java.nio.charset.Charset;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RestUtils {
    public static void decodeQueryString(String s, int fromIndex, Map<String, String> params) {
        int i;
        if (fromIndex < 0) {
            return;
        }
        if (fromIndex >= s.length()) {
            return;
        }
        String name = null;
        int pos = fromIndex;
        char c = '\u0000';
        for (i = fromIndex; i < s.length(); ++i) {
            c = s.charAt(i);
            if (c == '=' && name == null) {
                if (pos != i) {
                    name = RestUtils.decodeComponent(s.substring(pos, i));
                }
                pos = i + 1;
                continue;
            }
            if (c != '&') continue;
            if (name == null && pos != i) {
                RestUtils.addParam(params, RestUtils.decodeComponent(s.substring(pos, i)), "");
            } else if (name != null) {
                RestUtils.addParam(params, name, RestUtils.decodeComponent(s.substring(pos, i)));
                name = null;
            }
            pos = i + 1;
        }
        if (pos != i) {
            if (name == null) {
                RestUtils.addParam(params, RestUtils.decodeComponent(s.substring(pos, i)), "");
            } else {
                RestUtils.addParam(params, name, RestUtils.decodeComponent(s.substring(pos, i)));
            }
        } else if (name != null) {
            RestUtils.addParam(params, name, "");
        }
    }

    private static void addParam(Map<String, String> params, String name, String value) {
        if (params.containsKey(name)) {
            params.put(name, params.get(name) + "," + value);
        } else {
            params.put(name, value);
        }
    }

    public static String decodeComponent(String s) {
        return RestUtils.decodeComponent(s, Charsets.UTF_8);
    }

    public static String decodeComponent(String s, Charset charset) {
        if (s == null) {
            return "";
        }
        int size = s.length();
        boolean modified = false;
        for (int i = 0; i < size; ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '%': {
                    ++i;
                }
                case '+': {
                    modified = true;
                }
            }
        }
        if (!modified) {
            return s;
        }
        byte[] buf = new byte[size];
        int pos = 0;
        block9: for (int i = 0; i < size; ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '+': {
                    buf[pos++] = 32;
                    continue block9;
                }
                case '%': {
                    if (i == size - 1) {
                        throw new IllegalArgumentException("unterminated escape sequence at end of string: " + s);
                    }
                    if ((c = s.charAt(++i)) == '%') {
                        buf[pos++] = 37;
                        continue block9;
                    }
                    if (i == size - 1) {
                        throw new IllegalArgumentException("partial escape sequence at end of string: " + s);
                    }
                    c = RestUtils.decodeHexNibble(c);
                    char c2 = RestUtils.decodeHexNibble(s.charAt(++i));
                    if (c == '\uffff' || c2 == '\uffff') {
                        throw new IllegalArgumentException("invalid escape sequence `%" + s.charAt(i - 1) + s.charAt(i) + "' at index " + (i - 2) + " of: " + s);
                    }
                    c = (char)(c * 16 + c2);
                }
                default: {
                    buf[pos++] = (byte)c;
                }
            }
        }
        return new String(buf, 0, pos, charset);
    }

    private static char decodeHexNibble(char c) {
        if ('0' <= c && c <= '9') {
            return (char)(c - 48);
        }
        if ('a' <= c && c <= 'f') {
            return (char)(c - 97 + 10);
        }
        if ('A' <= c && c <= 'F') {
            return (char)(c - 65 + 10);
        }
        return '\uffff';
    }
}

