/*
 * Decompiled with CFR 0.152.
 */
package net.csdn.modules.http;

import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.csdn.ServiceFramwork;
import net.csdn.annotation.filter.AroundFilter;
import net.csdn.annotation.filter.BeforeFilter;
import net.csdn.common.collect.Tuple;
import net.csdn.common.exception.ArgumentErrorException;
import net.csdn.common.exception.RecordNotFoundException;
import net.csdn.common.logging.CSLogger;
import net.csdn.common.logging.Loggers;
import net.csdn.common.logging.support.MessageFormat;
import net.csdn.common.path.PathTrie;
import net.csdn.common.reflect.ReflectHelper;
import net.csdn.modules.http.ApplicationController;
import net.csdn.modules.http.RestRequest;
import net.csdn.modules.http.RestResponse;
import net.csdn.modules.http.WowAroundFilter;
import net.csdn.modules.http.support.FilterHelper2;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RestController {
    private CSLogger logger = Loggers.getLogger(this.getClass());
    private Tuple<Class<ApplicationController>, Method> defaultHandlerKey;
    private Tuple<Class<ApplicationController>, Method> errorHandlerKey;
    private final PathTrie<Tuple<Class<ApplicationController>, Method>> getHandlers = new PathTrie();
    private final PathTrie<Tuple<Class<ApplicationController>, Method>> postHandlers = new PathTrie();
    private final PathTrie<Tuple<Class<ApplicationController>, Method>> putHandlers = new PathTrie();
    private final PathTrie<Tuple<Class<ApplicationController>, Method>> deleteHandlers = new PathTrie();
    private final PathTrie<Tuple<Class<ApplicationController>, Method>> headHandlers = new PathTrie();
    private final PathTrie<Tuple<Class<ApplicationController>, Method>> optionsHandlers = new PathTrie();

    public void registerHandler(RestRequest.Method method, String path, Tuple<Class<ApplicationController>, Method> handler) {
        switch (method) {
            case GET: {
                this.getHandlers.insert(path, handler);
                break;
            }
            case DELETE: {
                this.deleteHandlers.insert(path, handler);
                break;
            }
            case POST: {
                this.postHandlers.insert(path, handler);
                break;
            }
            case PUT: {
                this.putHandlers.insert(path, handler);
                break;
            }
            case OPTIONS: {
                this.optionsHandlers.insert(path, handler);
                break;
            }
            case HEAD: {
                this.headHandlers.insert(path, handler);
                break;
            }
            default: {
                throw new ArgumentErrorException("Can't handle [" + (Object)((Object)method) + "] for path [" + path + "]");
            }
        }
    }

    public void setDefaultHandlerKey(Tuple<Class<ApplicationController>, Method> defaultHandlerKey) {
        this.defaultHandlerKey = defaultHandlerKey;
    }

    public void setErrorHandlerKey(Tuple<Class<ApplicationController>, Method> errorHandlerKey) {
        this.errorHandlerKey = errorHandlerKey;
    }

    public Tuple<Class<ApplicationController>, Method> defaultHandlerKey() {
        return this.defaultHandlerKey;
    }

    public Tuple<Class<ApplicationController>, Method> errorHandlerKey() {
        return this.errorHandlerKey;
    }

    public void dispatchRequest(RestRequest request, RestResponse restResponse) throws Exception {
        Tuple<Class<ApplicationController>, Method> handlerKey = this.getHandler(request);
        if (handlerKey == null) {
            if (this.defaultHandlerKey != null) {
                handlerKey = this.defaultHandlerKey;
            } else {
                throw new RecordNotFoundException(MessageFormat.format((String)"\u4f60\u8bf7\u6c42\u7684URL\u5730\u5740[{}]\u4e0d\u5b58\u5728", (Object[])new Object[]{request.rawPath().toString()}));
            }
        }
        ApplicationController applicationController = (ApplicationController)ServiceFramwork.injector.getInstance((Class)handlerKey.v1());
        RestController.enhanceApplicationController(applicationController, request, restResponse);
        if (handlerKey == this.defaultHandlerKey) {
            ((Method)handlerKey.v2()).invoke((Object)applicationController, new Object[0]);
        } else {
            this.filter(handlerKey, applicationController);
        }
    }

    public static void enhanceApplicationController(ApplicationController applicationController, RestRequest request, RestResponse restResponse) throws Exception {
        ReflectHelper.field((Object)applicationController, (String)"request", (Object)request);
        ReflectHelper.field((Object)applicationController, (String)"restResponse", (Object)restResponse);
    }

    private void filter(Tuple<Class<ApplicationController>, Method> handlerKey, ApplicationController applicationController) throws Exception {
        Map<Method, Map<Class, List<Method>>> result = FilterHelper2.create((Class)handlerKey.v1());
        Map<Class, List<Method>> filters = result.get(handlerKey.v2());
        WowAroundFilter first = null;
        if (filters.containsKey(BeforeFilter.class)) {
            for (Method filter : filters.get(BeforeFilter.class)) {
                filter.setAccessible(true);
                filter.invoke((Object)applicationController, new Object[0]);
            }
        }
        if (filters.containsKey(AroundFilter.class)) {
            Method currentFilter;
            Iterator<Method> iterator = filters.get(AroundFilter.class).iterator();
            WowAroundFilter wowAroundFilter = null;
            if (iterator.hasNext()) {
                currentFilter = iterator.next();
                first = wowAroundFilter = new WowAroundFilter(currentFilter, (Method)handlerKey.v2(), applicationController);
            }
            while (iterator.hasNext()) {
                currentFilter = iterator.next();
                wowAroundFilter.setNext(new WowAroundFilter(currentFilter, (Method)handlerKey.v2(), applicationController));
                wowAroundFilter = wowAroundFilter.getNext();
            }
        }
        if (first != null) {
            first.invoke();
        } else {
            ((Method)handlerKey.v2()).invoke((Object)applicationController, new Object[0]);
        }
    }

    public Tuple<Class<ApplicationController>, Method> getHandler(RestRequest request) {
        String path = this.getPath(request);
        RestRequest.Method method = request.method();
        if (method == RestRequest.Method.GET) {
            return (Tuple)this.getHandlers.retrieve(path, request.params());
        }
        if (method == RestRequest.Method.POST) {
            return (Tuple)this.postHandlers.retrieve(path, request.params());
        }
        if (method == RestRequest.Method.PUT) {
            return (Tuple)this.putHandlers.retrieve(path, request.params());
        }
        if (method == RestRequest.Method.DELETE) {
            return (Tuple)this.deleteHandlers.retrieve(path, request.params());
        }
        if (method == RestRequest.Method.HEAD) {
            return (Tuple)this.headHandlers.retrieve(path, request.params());
        }
        if (method == RestRequest.Method.OPTIONS) {
            return (Tuple)this.optionsHandlers.retrieve(path, request.params());
        }
        return null;
    }

    private String getPath(RestRequest request) {
        return request.rawPath();
    }
}

