/*
 * Decompiled with CFR 0.152.
 */
package net.csdn.modules.http;

import com.google.common.base.Joiner;
import com.google.common.collect.Maps;
import com.google.inject.Inject;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.csdn.ServiceFramwork;
import net.csdn.common.collections.WowCollections;
import net.csdn.common.env.Environment;
import net.csdn.common.exception.ArgumentErrorException;
import net.csdn.common.exception.ExceptionHandler;
import net.csdn.common.exception.RecordExistedException;
import net.csdn.common.exception.RecordNotFoundException;
import net.csdn.common.logging.CSLogger;
import net.csdn.common.logging.Loggers;
import net.csdn.common.settings.Settings;
import net.csdn.hibernate.support.filter.CSDNStatFilterstat;
import net.csdn.jpa.JPA;
import net.csdn.modules.http.ApplicationController;
import net.csdn.modules.http.DefaultRestRequest;
import net.csdn.modules.http.RestController;
import net.csdn.modules.http.RestResponse;
import net.csdn.modules.http.ViewType;
import net.csdn.modules.http.support.HttpHolder;
import net.csdn.modules.http.support.HttpStatus;
import net.csdn.modules.log.SystemLogger;
import net.sf.json.JSONException;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.SessionManager;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.eclipse.jetty.server.handler.HandlerList;
import org.eclipse.jetty.server.handler.ResourceHandler;
import org.eclipse.jetty.server.nio.SelectChannelConnector;
import org.eclipse.jetty.server.session.HashSessionManager;
import org.eclipse.jetty.server.session.SessionHandler;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.eclipse.jetty.util.thread.ThreadPool;

public class HttpServer {
    private final Server server;
    private CSLogger logger = Loggers.getLogger(this.getClass());
    private RestController restController;
    private boolean disableMysql = false;
    private Settings settings;
    private SystemLogger systemLogger;
    private static ThreadLocal<HttpHolder> httpHolder = new ThreadLocal();

    public static void setHttpHolder(HttpHolder value) {
        httpHolder.set(value);
    }

    public static void removeHttpHolder() {
        httpHolder.remove();
    }

    public static HttpHolder httpHolder() {
        return httpHolder.get();
    }

    @Inject
    public HttpServer(Settings settings, SystemLogger systemLogger, RestController restController) {
        this.settings = settings;
        this.systemLogger = systemLogger;
        this.restController = restController;
        Environment environment = new Environment(settings);
        this.disableMysql = settings.getAsBoolean((Object)((Object)ServiceFramwork.mode) + ".datasources.mysql.disable", Boolean.valueOf(false));
        this.server = new Server();
        SelectChannelConnector connector = new SelectChannelConnector();
        QueuedThreadPool threadPool = new QueuedThreadPool();
        threadPool.setMinThreads(settings.getAsInt("http.threads.min", Integer.valueOf(100)).intValue());
        threadPool.setMaxThreads(settings.getAsInt("http.threads.max", Integer.valueOf(1000)).intValue());
        connector.setThreadPool((ThreadPool)threadPool);
        connector.setPort(settings.getAsInt("http.port", Integer.valueOf(8080)).intValue());
        this.server.addConnector((Connector)connector);
        HandlerList handlers = new HandlerList();
        if (settings.getAsBoolean("application.static.enable", Boolean.valueOf(false)).booleanValue()) {
            ResourceHandler resource_handler = new ResourceHandler();
            resource_handler.setDirectoriesListed(false);
            try {
                resource_handler.setBaseResource(Resource.newResource((String)(environment.templateDirFile().getPath() + "/assets/")));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            if (settings.getAsBoolean("application.session.enable", Boolean.valueOf(false)).booleanValue()) {
                HashSessionManager sessionManager = new HashSessionManager();
                sessionManager.setSessionIdPathParameterName("none");
                handlers.setHandlers(new Handler[]{resource_handler, new SessionHandler((SessionManager)sessionManager), new DefaultHandler()});
            } else {
                handlers.setHandlers(new Handler[]{resource_handler, new DefaultHandler()});
            }
        } else {
            handlers.setHandlers(new Handler[]{new DefaultHandler()});
        }
        this.server.setHandler((Handler)handlers);
    }

    public void start() {
        new Thread(new Runnable(){

            public void run() {
                try {
                    HttpServer.this.server.start();
                    HttpServer.this.server.join();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }).start();
    }

    public void close() {
        try {
            this.server.stop();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void join() {
        try {
            this.server.join();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    class DefaultHandler
    extends AbstractHandler {
        DefaultHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void handle(String s, Request request, final HttpServletRequest httpServletRequest, final HttpServletResponse httpServletResponse) throws IOException, ServletException {
            block23: {
                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                class DefaultResponse
                implements RestResponse {
                    private String content;
                    private byte[] contentByte;
                    private int status = HttpStatus.HttpStatusOK;
                    private String content_type = "application/json; charset=UTF-8";
                    private String redirectPath;

                    DefaultResponse() {
                    }

                    @Override
                    public void write(String content) {
                        this.content = content;
                    }

                    private void configureMimeType(ViewType viewType) {
                        if (viewType == ViewType.xml) {
                            this.content_type = "application/xml;charset=UTF-8";
                        } else if (viewType == ViewType.image) {
                            this.content_type = "image/jpeg";
                        } else if (viewType == ViewType.string) {
                            this.content_type = "text/plain;charset=UTF-8";
                        } else if (viewType == ViewType.html) {
                            this.content_type = "text/html;charset=UTF-8";
                        }
                    }

                    @Override
                    public void write(String content, ViewType viewType) {
                        this.configureMimeType(viewType);
                        this.content = content;
                    }

                    @Override
                    public void write(int httpStatus, String content) {
                        this.content = content;
                        this.status = httpStatus;
                    }

                    @Override
                    public void write(int httpStatus, String content, ViewType viewType) {
                        this.configureMimeType(viewType);
                        this.content = content;
                        this.status = httpStatus;
                    }

                    @Override
                    public void write(byte[] contentByte) {
                        this.contentByte = contentByte;
                    }

                    @Override
                    public void cookie(String name, String value) {
                        httpServletResponse.addCookie(new Cookie(name, value));
                    }

                    @Override
                    public void cookie(Map cookieInfo) {
                        Cookie cookie = new Cookie((String)cookieInfo.get("name"), (String)cookieInfo.get("value"));
                        if (cookieInfo.containsKey("domain")) {
                            cookie.setDomain((String)cookieInfo.get("domain"));
                        }
                        if (cookieInfo.containsKey("max_age")) {
                            cookie.setMaxAge(((Integer)cookieInfo.get("max_age")).intValue());
                        }
                        if (cookieInfo.containsKey("path")) {
                            cookie.setPath((String)cookieInfo.get("path"));
                        }
                        if (cookieInfo.containsKey("secure")) {
                            cookie.setSecure(((Boolean)cookieInfo.get("secure")).booleanValue());
                        }
                        if (cookieInfo.containsKey("version")) {
                            cookie.setVersion(((Integer)cookieInfo.get("version")).intValue());
                        }
                        httpServletResponse.addCookie(cookie);
                    }

                    @Override
                    public String content() {
                        return this.content;
                    }

                    @Override
                    public Object originContent() {
                        return null;
                    }

                    @Override
                    public void redirectTo(String path, Map params) {
                        HashMap temp = Maps.newHashMap();
                        try {
                            for (Object o : params.keySet()) {
                                if (params.get(o) instanceof String) {
                                    temp.put(o, URLEncoder.encode((String)params.get(o), "UTF-8"));
                                    continue;
                                }
                                temp.put(o, params.get(o));
                            }
                        }
                        catch (UnsupportedEncodingException e) {
                            e.printStackTrace();
                        }
                        String param = Joiner.on((String)"&").withKeyValueSeparator("=").join((Map)temp);
                        if (path.contains("?")) {
                            path = path + "&" + param;
                        } else if (params.size() != 0) {
                            path = path + "?" + param;
                        }
                        this.redirectPath = path;
                    }

                    @Override
                    public RestResponse originContent(Object obj) {
                        return null;
                    }

                    @Override
                    public int status() {
                        return this.status;
                    }

                    public void send() throws IOException {
                        httpServletResponse.setContentType(this.content_type);
                        if (!WowCollections.isNull((Object)this.redirectPath)) {
                            httpServletResponse.sendRedirect(httpServletResponse.encodeRedirectURL(this.redirectPath));
                            return;
                        }
                        if (this.content != null) {
                            this.output(this.content);
                            return;
                        }
                        if (this.contentByte != null) {
                            this.outputAsByte(this.contentByte);
                            return;
                        }
                    }

                    public void error(Exception e) throws IOException {
                        this.status = e instanceof RecordNotFoundException ? HttpStatus.HttpStatusNotFound : (e instanceof RecordExistedException || e instanceof ArgumentErrorException || e instanceof JSONException ? HttpStatus.HttpStatusBadRequest : HttpStatus.HttpStatusSystemError);
                        httpServletResponse.setContentType("text/plain;charset=UTF-8");
                        httpServletResponse.setStatus(this.status);
                        this.output(e.getMessage());
                    }

                    public void output(String msg) throws IOException {
                        httpServletResponse.setStatus(this.status);
                        PrintWriter printWriter = httpServletResponse.getWriter();
                        printWriter.write(msg);
                        printWriter.flush();
                        printWriter.close();
                    }

                    public void outputAsByte(byte[] msg) throws IOException {
                        httpServletResponse.setStatus(this.status);
                        ServletOutputStream outputStream = httpServletResponse.getOutputStream();
                        outputStream.write(msg);
                        outputStream.flush();
                        outputStream.close();
                    }

                    public void internalDispatchRequest() throws Exception {
                        RestController controller = HttpServer.this.restController;
                        DefaultRestRequest restRequest = new DefaultRestRequest(httpServletRequest);
                        HttpServer.setHttpHolder(new HttpHolder(restRequest, this));
                        try {
                            controller.dispatchRequest(restRequest, this);
                        }
                        catch (Exception e) {
                            ExceptionHandler.renderHandle((Exception)e);
                        }
                    }
                }
                DefaultResponse channel = new DefaultResponse();
                long startTime = System.currentTimeMillis();
                if (!HttpServer.this.disableMysql) {
                    CSDNStatFilterstat.setSQLTIME(new AtomicLong(0L));
                }
                try {
                    try {
                        channel.internalDispatchRequest();
                        if (!HttpServer.this.disableMysql) {
                            JPA.getJPAConfig().getJPAContext().closeTx(false);
                        }
                        channel.send();
                    }
                    catch (Exception e) {
                        if (HttpServer.this.settings.getAsBoolean("framework.printStackTrace", Boolean.valueOf(false)).booleanValue()) {
                            e.printStackTrace();
                        }
                        HttpServer.this.logger.error("System processing error", (Throwable)e, new Object[0]);
                        if (!HttpServer.this.disableMysql) {
                            try {
                                JPA.getJPAConfig().getJPAContext().closeTx(true);
                            }
                            catch (Exception e2) {
                                // empty catch block
                            }
                        }
                        if (HttpServer.this.restController.errorHandlerKey() != null) {
                            ApplicationController errorApplicationController = (ApplicationController)ServiceFramwork.injector.getInstance((Class)HttpServer.this.restController.errorHandlerKey().v1());
                            try {
                                RestController.enhanceApplicationController(errorApplicationController, HttpServer.httpHolder().restRequest(), channel);
                                try {
                                    ((Method)HttpServer.this.restController.errorHandlerKey().v2()).invoke((Object)errorApplicationController, e);
                                }
                                catch (Exception e2) {
                                    ExceptionHandler.renderHandle((Exception)e2);
                                    channel.send();
                                }
                            }
                            catch (Exception e1) {
                                HttpServer.this.logger.error("System processing error", (Throwable)e1, new Object[0]);
                            }
                        } else {
                            channel.error(e);
                        }
                        Object var12_8 = null;
                        boolean logEnable = HttpServer.this.settings.getAsBoolean("application.log.enable", Boolean.valueOf(true));
                        if (logEnable) {
                            long endTime = System.currentTimeMillis();
                            String url = httpServletRequest.getQueryString();
                            HttpServer.this.logger.info("Completed " + channel.status + " in " + (endTime - startTime) + "ms (ActiveORM: " + (HttpServer.this.disableMysql ? 0L : CSDNStatFilterstat.SQLTIME().get()) + "ms)", new Object[0]);
                            HttpServer.this.logger.info(httpServletRequest.getMethod() + " " + httpServletRequest.getRequestURI() + (WowCollections.isNull((Object)url) ? "" : "?" + url), new Object[0]);
                            HttpServer.this.logger.info("\n\n\n\n", new Object[0]);
                        }
                        if (!HttpServer.this.disableMysql) {
                            CSDNStatFilterstat.removeSQLTIME();
                        }
                        HttpServer.removeHttpHolder();
                        return;
                    }
                    Object var12_7 = null;
                    boolean logEnable = HttpServer.this.settings.getAsBoolean("application.log.enable", Boolean.valueOf(true));
                    if (!logEnable) break block23;
                }
                catch (Throwable throwable) {
                    Object var12_9 = null;
                    boolean logEnable = HttpServer.this.settings.getAsBoolean("application.log.enable", Boolean.valueOf(true));
                    if (logEnable) {
                        long endTime = System.currentTimeMillis();
                        String url = httpServletRequest.getQueryString();
                        HttpServer.this.logger.info("Completed " + channel.status + " in " + (endTime - startTime) + "ms (ActiveORM: " + (HttpServer.this.disableMysql ? 0L : CSDNStatFilterstat.SQLTIME().get()) + "ms)", new Object[0]);
                        HttpServer.this.logger.info(httpServletRequest.getMethod() + " " + httpServletRequest.getRequestURI() + (WowCollections.isNull((Object)url) ? "" : "?" + url), new Object[0]);
                        HttpServer.this.logger.info("\n\n\n\n", new Object[0]);
                    }
                    if (!HttpServer.this.disableMysql) {
                        CSDNStatFilterstat.removeSQLTIME();
                    }
                    HttpServer.removeHttpHolder();
                    throw throwable;
                }
                long endTime = System.currentTimeMillis();
                String url = httpServletRequest.getQueryString();
                HttpServer.this.logger.info("Completed " + channel.status + " in " + (endTime - startTime) + "ms (ActiveORM: " + (HttpServer.this.disableMysql ? 0L : CSDNStatFilterstat.SQLTIME().get()) + "ms)", new Object[0]);
                HttpServer.this.logger.info(httpServletRequest.getMethod() + " " + httpServletRequest.getRequestURI() + (WowCollections.isNull((Object)url) ? "" : "?" + url), new Object[0]);
                HttpServer.this.logger.info("\n\n\n\n", new Object[0]);
            }
            if (!HttpServer.this.disableMysql) {
                CSDNStatFilterstat.removeSQLTIME();
            }
            HttpServer.removeHttpHolder();
        }
    }
}

