/*
 * Decompiled with CFR 0.152.
 */
package net.csdn.modules.http;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import net.csdn.common.Booleans;
import net.csdn.common.Unicode;
import net.csdn.common.io.Streams;
import net.csdn.common.unit.ByteSizeValue;
import net.csdn.common.unit.TimeValue;
import net.csdn.modules.http.RestRequest;
import net.csdn.modules.http.RestUtils;
import net.sf.json.util.JSONUtils;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultRestRequest
implements RestRequest {
    private static final Pattern commaPattern = Pattern.compile(",");
    private final HttpServletRequest servletRequest;
    private RestRequest.Method method;
    private final Map<String, String> params;
    private final byte[] content;

    public DefaultRestRequest(String method, Map params) {
        this.method = RestRequest.Method.valueOf(method);
        this.params = params;
        this.servletRequest = null;
        this.content = new byte[0];
    }

    public DefaultRestRequest(HttpServletRequest servletRequest) {
        this.servletRequest = servletRequest;
        this.method = RestRequest.Method.valueOf(servletRequest.getMethod());
        this.params = new HashMap<String, String>();
        if (servletRequest.getQueryString() != null) {
            RestUtils.decodeQueryString(servletRequest.getQueryString(), 0, this.params);
        }
        if (this.params.containsKey("_method")) {
            this.method = RestRequest.Method.valueOf(this.params.get("_method"));
        }
        String contentType = servletRequest.getHeader("content-type");
        try {
            this.content = Streams.copyToByteArray((InputStream)servletRequest.getInputStream());
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Fail to parse request params");
        }
        if ("application/json".equals(contentType)) {
            return;
        }
        String wow = this.contentAsString();
        if (wow == null) {
            return;
        }
        if (JSONUtils.mayBeJSON((String)(wow = wow.trim()))) {
            return;
        }
        try {
            RestUtils.decodeQueryString(wow, 0, this.params);
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    @Override
    public RestRequest.Method method() {
        return this.method;
    }

    @Override
    public String uri() {
        return this.servletRequest.getRequestURI();
    }

    @Override
    public String url() {
        return this.servletRequest.getRequestURL().toString();
    }

    @Override
    public String queryString() {
        return this.servletRequest.getQueryString();
    }

    @Override
    public String rawPath() {
        return this.servletRequest.getRequestURI();
    }

    @Override
    public boolean hasContent() {
        return this.content.length > 0;
    }

    @Override
    public boolean contentUnsafe() {
        return false;
    }

    @Override
    public byte[] contentByteArray() {
        return this.content;
    }

    @Override
    public int contentByteArrayOffset() {
        return 0;
    }

    @Override
    public int contentLength() {
        return this.content.length;
    }

    @Override
    public String contentAsString() {
        return Unicode.fromBytes((byte[])this.contentByteArray(), (int)this.contentByteArrayOffset(), (int)this.contentLength());
    }

    @Override
    public String header(String name) {
        return this.servletRequest.getHeader(name);
    }

    @Override
    public Map<String, String> params() {
        return this.params;
    }

    @Override
    public String cookie(String name) {
        Cookie[] cookies = this.servletRequest.getCookies();
        if (cookies == null || cookies.length == 0) {
            return null;
        }
        for (Cookie cookie : cookies) {
            if (!cookie.getName().equalsIgnoreCase(name)) continue;
            return cookie.getValue();
        }
        return null;
    }

    @Override
    public Object session(String key) {
        return this.servletRequest.getSession().getAttribute(key);
    }

    @Override
    public void session(String key, Object value) {
        this.servletRequest.getSession().setAttribute(key, value);
    }

    @Override
    public Object flash(String key) {
        return this.servletRequest.getAttribute(key);
    }

    @Override
    public void flash(String key, Object value) {
        this.servletRequest.setAttribute(key, value);
    }

    @Override
    public boolean hasParam(String key) {
        return this.params.containsKey(key);
    }

    @Override
    public String param(String key) {
        return this.params.get(key);
    }

    @Override
    public String paramMultiKey(String ... keys) {
        for (String key : keys) {
            String temp = this.param(key);
            if (StringUtils.isEmpty((String)temp)) continue;
            return temp;
        }
        return null;
    }

    @Override
    public String param(String key, String defaultValue) {
        String value = this.params.get(key);
        if (value == null) {
            return defaultValue;
        }
        return value;
    }

    @Override
    public final String path() {
        return RestUtils.decodeComponent(this.rawPath());
    }

    @Override
    public float paramAsFloat(String key, float defaultValue) {
        String sValue = this.param(key);
        if (sValue == null) {
            return defaultValue;
        }
        try {
            return Float.parseFloat(sValue);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Failed to parse float parameter [" + key + "] with value [" + sValue + "]", e);
        }
    }

    @Override
    public int paramAsInt(String key, int defaultValue) {
        String sValue = this.param(key);
        if (sValue == null) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(sValue);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Failed to parse int parameter [" + key + "] with value [" + sValue + "]", e);
        }
    }

    @Override
    public long paramAsLong(String key, long defaultValue) {
        String sValue = this.param(key);
        if (sValue == null) {
            return defaultValue;
        }
        try {
            return Long.parseLong(sValue);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Failed to parse int parameter [" + key + "] with value [" + sValue + "]", e);
        }
    }

    @Override
    public boolean paramAsBoolean(String key, boolean defaultValue) {
        return Booleans.parseBoolean((String)this.param(key), (boolean)defaultValue);
    }

    @Override
    public Boolean paramAsBoolean(String key, Boolean defaultValue) {
        String sValue = this.param(key);
        if (sValue == null) {
            return defaultValue;
        }
        return !sValue.equals("false") && !sValue.equals("0") && !sValue.equals("off");
    }

    @Override
    public TimeValue paramAsTime(String key, TimeValue defaultValue) {
        return TimeValue.parseTimeValue((String)this.param(key), (TimeValue)defaultValue);
    }

    @Override
    public ByteSizeValue paramAsSize(String key, ByteSizeValue defaultValue) {
        return ByteSizeValue.parseBytesSizeValue((String)this.param(key), (ByteSizeValue)defaultValue);
    }

    @Override
    public String[] paramAsStringArray(String key, String[] defaultValue) {
        String value = this.param(key);
        if (value == null) {
            return defaultValue;
        }
        return commaPattern.split(value);
    }
}

