/*
 * Decompiled with CFR 0.152.
 */
package net.csdn.modules.http;

import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import net.csdn.ServiceFramwork;
import net.csdn.common.Strings;
import net.csdn.common.collect.Tuple;
import net.csdn.common.collections.WowCollections;
import net.csdn.common.exception.ArgumentErrorException;
import net.csdn.common.exception.RenderFinish;
import net.csdn.common.logging.CSLogger;
import net.csdn.common.logging.Loggers;
import net.csdn.common.reflect.ReflectHelper;
import net.csdn.common.settings.Settings;
import net.csdn.common.time.NumberExtendedForTime;
import net.csdn.common.unit.ByteSizeValue;
import net.csdn.common.unit.TimeValue;
import net.csdn.modules.http.DateJsonValueProcessor;
import net.csdn.modules.http.RestController;
import net.csdn.modules.http.RestRequest;
import net.csdn.modules.http.RestResponse;
import net.csdn.modules.http.ViewType;
import net.csdn.modules.log.SystemLogger;
import net.csdn.modules.mock.MockRestRequest;
import net.csdn.modules.mock.MockRestResponse;
import net.sf.json.JSON;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import net.sf.json.JsonConfig;
import net.sf.json.processors.JsonValueProcessor;
import net.sf.json.util.CycleDetectionStrategy;
import net.sf.json.xml.XMLSerializer;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.Velocity;
import org.apache.velocity.context.Context;
import org.joda.time.DateTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ApplicationController {
    protected CSLogger logger = Loggers.getLogger(this.getClass());
    protected RestRequest request;
    protected RestResponse restResponse;
    protected Settings settings = (Settings)ServiceFramwork.injector.getInstance(Settings.class);
    protected SystemLogger systemLogger = (SystemLogger)ServiceFramwork.injector.getInstance(SystemLogger.class);
    protected JSONOutPutConfig config = new JSONOutPutConfig();
    public static Map<String, Map<String, List>> parent$_before_filter_info;
    public static Map<String, Map<String, List>> parent$_around_filter_info;

    public Class const_document_get(String name) {
        return this.inner_const_get("document", name);
    }

    public Class const_service_get(String name) {
        return this.inner_const_get("service", name);
    }

    private Class inner_const_get(String type, String name) {
        String model = this.settings.get("application." + type, "") + "." + Strings.toCamelCase((String)name, (boolean)true);
        Class<?> clzz = null;
        try {
            clzz = Class.forName(model);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            throw new ArgumentErrorException("error: could not load class:[" + model + "]");
        }
        return clzz;
    }

    protected void merge(Object dest, Object origin) {
        try {
            BeanUtils.copyProperties((Object)dest, (Object)origin);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    public void session(String key, Object value) {
        this.request.session(key, value);
    }

    public Object session(String key) {
        return this.request.session(key);
    }

    public String url() {
        return this.request.url();
    }

    public void flash(String key, Object value) {
        this.request.flash(key, value);
    }

    public Object flash(String key) {
        return this.request.flash(key);
    }

    public void render(int status, String content) {
        this.restResponse.originContent(content);
        this.restResponse.write(status, content);
        throw new RenderFinish();
    }

    public void render(int status, Object result) {
        this.restResponse.originContent(result);
        this.restResponse.write(status, this.toJson(result));
        throw new RenderFinish();
    }

    public void redirectTo(String url, Map params) {
        this.restResponse.redirectTo(url, params);
        throw new RenderFinish();
    }

    public void render(int status, String content, ViewType viewType) {
        this.restResponse.originContent(content);
        this.restResponse.write(status, content, viewType);
        throw new RenderFinish();
    }

    public void renderHtml(int status, String path, Map result) {
        VelocityContext context = new VelocityContext();
        this.copyObjectToMap(result, context);
        StringWriter w = new StringWriter();
        Velocity.mergeTemplate((String)path, (String)"utf-8", (Context)context, (Writer)w);
        this.restResponse.write(status, w.toString(), ViewType.html);
    }

    public void renderHtmlWithMaster(int status, String path, Map result) {
        if (!result.containsKey("template")) {
            result.put("template", Strings.toUnderscoreCase((String)this.getControllerNameWithoutSuffix()) + "/" + Strings.toUnderscoreCase((String)this.getActionName()) + ".vm");
        }
        this.renderHtml(status, path, result);
    }

    public void render(int status, Object result, ViewType viewType) {
        this.restResponse.originContent(result);
        if (viewType == ViewType.xml) {
            this.restResponse.write(status, this.toXML(result), viewType);
        } else if (viewType == ViewType.json) {
            this.restResponse.write(status, this.toJson(result), viewType);
        } else if (viewType == ViewType.string) {
            this.restResponse.write(status, result.toString(), viewType);
        } else if (viewType == ViewType.html) {
            VelocityContext context = new VelocityContext();
            this.copyObjectToMap(result, context);
            StringWriter w = new StringWriter();
            Velocity.mergeTemplate((String)(Strings.toUnderscoreCase((String)this.getControllerNameWithoutSuffix()) + "/" + Strings.toUnderscoreCase((String)this.getActionName()) + ".vm"), (String)"utf-8", (Context)context, (Writer)w);
            this.restResponse.write(status, w.toString(), viewType);
        }
        throw new RenderFinish();
    }

    private void copyObjectToMap(Object result, VelocityContext context) {
        if (result instanceof Map) {
            Map temp = (Map)result;
            for (Map.Entry entry : temp.entrySet()) {
                context.put((String)entry.getKey(), entry.getValue());
            }
        }
        context.put("helper", this.findHelper());
        for (Field field : this.getClass().getDeclaredFields()) {
            if (Modifier.isStatic(field.getModifiers())) continue;
            field.setAccessible(true);
            try {
                context.put(field.getName(), field.get(this));
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
    }

    private String getControllerNameWithoutSuffix() {
        return StringUtils.substringBefore((String)this.getControllerName(), (String)"Controller");
    }

    private String getControllerName() {
        return this.getClass().getSimpleName();
    }

    private String getActionName() {
        RestController restController = (RestController)ServiceFramwork.injector.getInstance(RestController.class);
        Tuple<Class<ApplicationController>, Method> handlerKey = restController.getHandler(this.request);
        return ((Method)handlerKey.v2()).getName();
    }

    private Object findHelper() {
        Object instance;
        String wow = StringUtils.substringAfter((String)StringUtils.substringBefore((String)this.getClass().getName(), (String)("." + this.getClass().getSimpleName())), (String)(this.settings.get("application.controller", "") + "."));
        wow = this.settings.get("application.helper", "") + "." + wow + "." + this.getControllerNameWithoutSuffix() + "Helper";
        try {
            instance = Class.forName(wow).newInstance();
        }
        catch (Exception e) {
            instance = new WowCollections();
        }
        return instance;
    }

    public void render(String content) {
        this.restResponse.originContent(content);
        this.restResponse.write(content);
        throw new RenderFinish();
    }

    public void render(Object result) {
        this.restResponse.originContent(result);
        this.restResponse.write(this.toJson(result));
        throw new RenderFinish();
    }

    public void render(String content, ViewType viewType) {
        this.restResponse.originContent(content);
        this.restResponse.write(content, viewType);
        throw new RenderFinish();
    }

    public void render(Object result, ViewType viewType) {
        this.restResponse.originContent(result);
        this.restResponse.write(viewType == ViewType.xml ? this.toXML(result) : this.toJson(result), viewType);
        throw new RenderFinish();
    }

    public String toJson(Object obj) {
        if (this.config.isPretty()) {
            return this._toJson(obj).toString(2);
        }
        return this._toJson(obj).toString();
    }

    public JSON _toJson(Object obj) {
        JsonConfig config = new JsonConfig();
        config.setIgnoreDefaultExcludes(false);
        config.setCycleDetectionStrategy(CycleDetectionStrategy.LENIENT);
        config.registerJsonValueProcessor(Date.class, (JsonValueProcessor)new DateJsonValueProcessor());
        if (obj instanceof Collection) {
            return JSONArray.fromObject((Object)obj, (JsonConfig)config);
        }
        return JSONObject.fromObject((Object)obj, (JsonConfig)config);
    }

    public String toXML(Object obj) {
        JSON json = this._toJson(obj);
        XMLSerializer xmlSerializer = new XMLSerializer();
        return xmlSerializer.write(json);
    }

    public String contentAsString() {
        return this.request.contentAsString();
    }

    public JSONObject paramAsJSON(String key) {
        return JSONObject.fromObject((Object)this.param(key));
    }

    public JSONArray paramAsJSONArray(String key) {
        return JSONArray.fromObject((Object)this.param(key));
    }

    public JSONObject paramAsJSON() {
        JSON json = this._contentAsJSON();
        if (json.isArray()) {
            throw new ArgumentErrorException("\u6570\u636e\u683c\u5f0f\u9519\u8bef\uff0c\u60a8\u9700\u8981\u4f20\u5165json\u683c\u5f0f");
        }
        return (JSONObject)json;
    }

    public JSONArray paramsAsJSONArray() {
        JSON json = this._contentAsJSON();
        if (!json.isArray()) {
            throw new ArgumentErrorException("\u6570\u636e\u683c\u5f0f\u9519\u8bef\uff0c\u60a8\u9700\u8981\u4f20\u5165json\u683c\u5f0f");
        }
        return (JSONArray)json;
    }

    private JSON _contentAsJSON() {
        try {
            return JSONObject.fromObject((Object)this.contentAsString());
        }
        catch (Exception e) {
            try {
                return JSONArray.fromObject((Object)this.contentAsString());
            }
            catch (Exception e1) {
                throw new ArgumentErrorException("\u6570\u636e\u683c\u5f0f\u9519\u8bef\uff0c\u60a8\u9700\u8981\u4f20\u5165json\u683c\u5f0f");
            }
        }
    }

    public JSONArray paramAsXMLArray() {
        JSON json = this._contentAsXML();
        if (!json.isArray()) {
            throw new ArgumentErrorException("\u6570\u636e\u683c\u5f0f\u9519\u8bef\uff0c\u60a8\u9700\u8981\u4f20\u5165json\u683c\u5f0f");
        }
        return (JSONArray)json;
    }

    public JSONObject paramAsXML() {
        JSON json = this._contentAsXML();
        if (json.isArray()) {
            throw new ArgumentErrorException("\u6570\u636e\u683c\u5f0f\u9519\u8bef\uff0c\u60a8\u9700\u8981\u4f20\u5165json\u683c\u5f0f");
        }
        return (JSONObject)json;
    }

    private JSON _contentAsXML() {
        try {
            XMLSerializer xmlSerializer = new XMLSerializer();
            JSON json = xmlSerializer.read(this.contentAsString());
            return json;
        }
        catch (Exception e) {
            throw new ArgumentErrorException("\u6570\u636e\u683c\u5f0f\u9519\u8bef\uff0c\u60a8\u9700\u8981\u4f20\u5165json\u683c\u5f0f");
        }
    }

    public String header(String name) {
        return this.request.header(name);
    }

    public String cookie(String name) {
        return this.request.cookie(name);
    }

    public void cookie(String name, String value) {
        this.restResponse.cookie(name, value);
    }

    public void cookie(Map cookieInfo) {
        this.restResponse.cookie(cookieInfo);
    }

    public void cookie(String name, String value, String path, int max_age) {
        this.restResponse.cookie(this.map("name", name, "value", value, "path", path, "max_age", max_age));
    }

    public Map<String, String> params() {
        return this.request.params();
    }

    public boolean hasParam(String key) {
        return this.request.params().containsKey(key);
    }

    public String param(String key) {
        return this.request.params().get(key);
    }

    public String paramMultiKey(String ... keys) {
        return this.request.paramMultiKey(keys);
    }

    public String param(String key, String defaultValue) {
        return this.request.param(key, defaultValue);
    }

    public boolean isEmpty(String abc) {
        return StringUtils.isEmpty((String)abc);
    }

    public boolean isEmpty(Collection abc) {
        return WowCollections.isEmpty((Collection)abc);
    }

    public float paramAsFloat(String key, float defaultValue) {
        return this.request.paramAsFloat(key, defaultValue);
    }

    public int paramAsInt(String key, int defaultValue) {
        return this.request.paramAsInt(key, defaultValue);
    }

    public int paramAsInt(String key) {
        if (this.param(key) == null) {
            throw new ArgumentErrorException("");
        }
        return this.request.paramAsInt(key, -1);
    }

    public long paramAsLong(String key, long defaultValue) {
        return this.request.paramAsLong(key, defaultValue);
    }

    public boolean paramAsBoolean(String key, boolean defaultValue) {
        return this.request.paramAsBoolean(key, defaultValue);
    }

    public Boolean paramAsBoolean(String key, Boolean defaultValue) {
        return this.request.paramAsBoolean(key, defaultValue);
    }

    public TimeValue paramAsTime(String key, TimeValue defaultValue) {
        return this.request.paramAsTime(key, defaultValue);
    }

    public ByteSizeValue paramAsSize(String key, ByteSizeValue defaultValue) {
        return this.request.paramAsSize(key, defaultValue);
    }

    public String[] paramAsStringArray(String key, String[] defaultValue) {
        return this.request.paramAsStringArray(key, defaultValue);
    }

    public void m(String method) {
        try {
            ReflectHelper.method2((Object)this, (String)method);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public ApplicationController mockRequest(Map<String, String> params, RestRequest.Method method, String xmlOrJsonData) {
        this.request = new MockRestRequest(params, method, xmlOrJsonData);
        this.restResponse = new MockRestResponse();
        return this;
    }

    public RestResponse mockResponse() {
        return this.restResponse;
    }

    public <T> Set<T> newHashSet(T ... arrays) {
        return WowCollections.newHashSet((Object[])arrays);
    }

    public Map selectMap(Map map, String ... keys) {
        return WowCollections.selectMap((Map)map, (String[])keys);
    }

    public Map paramByKeys(Map map, String ... keys) {
        return WowCollections.selectMap((Map)map, (String[])keys);
    }

    public Map selectMapWithAliasName(Map map, String ... keys) {
        return WowCollections.selectMapWithAliasName((Map)map, (String[])keys);
    }

    public Map aliasParamKeys(Map params, String ... keys) {
        return WowCollections.selectMapWithAliasName((Map)params, (String[])keys);
    }

    public Map map(Object ... arrays) {
        return WowCollections.map((Object[])arrays);
    }

    public <T> List<T> list(T ... arrays) {
        return WowCollections.list((Object[])arrays);
    }

    public <T> List<T> projectionColumn(List<Map> maps, String column) {
        return WowCollections.projectionColumn(maps, (String)column);
    }

    public List project(List<Map> list, String key) {
        return WowCollections.project(list, (String)key);
    }

    public String join(Collection collection, String split) {
        return WowCollections.join((Collection)collection, (String)split);
    }

    public String join(Collection collection) {
        return WowCollections.join((Collection)collection);
    }

    public List projectByMethod(List list, String method, Object ... params) {
        return WowCollections.projectByMethod((List)list, (String)method, (Object[])params);
    }

    public Map double_list_to_map(List keys, List values) {
        return WowCollections.doubleListToMap((List)keys, (List)values);
    }

    public String join(Collection collection, String split, String wrapper) {
        return WowCollections.join((Collection)collection, (String)split, (String)wrapper);
    }

    public String join(Object[] collection, String split, String wrapper) {
        return WowCollections.join((Object[])collection, (String)split, (String)wrapper);
    }

    public String getString(Map map, String key) {
        return WowCollections.getString((Map)map, (String)key);
    }

    public String getStringNoNull(Map map, String key) {
        return WowCollections.getStringNoNull((Map)map, (String)key);
    }

    public Date getDate(Map map, String key) {
        return WowCollections.getDate((Map)map, (String)key);
    }

    public long getDateAsLong(Map map, String key) {
        return WowCollections.getDateAsLong((Map)map, (String)key);
    }

    public int getInt(Map map, String key) {
        return WowCollections.getInt((Map)map, (String)key);
    }

    public long getLong(Map map, String key) {
        return WowCollections.getLong((Map)map, (String)key);
    }

    public Set hashSet(Object[] array) {
        return WowCollections.hashSet((Object[])array);
    }

    public List toList(Object[] array) {
        return WowCollections.toList((Object[])array);
    }

    public Set hashSet(int[] array) {
        return WowCollections.hashSet((int[])array);
    }

    public List jsonArrayToList(JSONArray jsonArray) {
        return this.toList(jsonArray.toArray());
    }

    public String join(Object[] arrays, String split) {
        return WowCollections.join((Object[])arrays, (String)split);
    }

    public String join(int[] arrays, String split) {
        return WowCollections.join((int[])arrays, (String)split);
    }

    public <T> T or(T a, T b) {
        if (a == null) {
            return b;
        }
        return a;
    }

    public Map selectMapWithAliasNameInclude(Map map, String ... keys) {
        return WowCollections.selectMapWithAliasNameInclude((Map)map, (String[])keys);
    }

    public Pattern RegEx(String reg) {
        return Pattern.compile(reg);
    }

    public Pattern regEx(String reg) {
        return this.RegEx(reg);
    }

    public Pattern paramsAsRegEx(String key) {
        return this.RegEx(this.param(key));
    }

    public boolean isNull(Object key) {
        return key == null;
    }

    public NumberExtendedForTime time(int number) {
        return new NumberExtendedForTime(number);
    }

    public NumberExtendedForTime time(long number) {
        return new NumberExtendedForTime(number);
    }

    public DateTime now() {
        return new DateTime();
    }

    public static Map<String, Map<String, List>> parent$_before_filter_info() {
        if (parent$_before_filter_info == null) {
            parent$_before_filter_info = new LinkedHashMap<String, Map<String, List>>();
        }
        return parent$_before_filter_info;
    }

    public static Map<String, Map<String, List>> parent$_around_filter_info() {
        if (parent$_around_filter_info == null) {
            parent$_around_filter_info = new LinkedHashMap<String, Map<String, List>>();
        }
        return parent$_around_filter_info;
    }

    public static void beforeFilter(String filter, Map info) {
        ApplicationController.parent$_before_filter_info().put(filter, info);
    }

    public static void aroundFilter(String filter, Map info) {
        ApplicationController.parent$_around_filter_info().put(filter, info);
    }

    public class JSONOutPutConfig
    extends JsonConfig {
        private boolean pretty = false;

        public boolean isPretty() {
            return this.pretty;
        }

        public void setPretty(boolean pretty) {
            this.pretty = pretty;
        }
    }
}

