/*
 * Decompiled with CFR 0.152.
 */
package net.csdn.modules.compress.lzf;

import java.io.IOException;
import java.io.InputStream;
import net.csdn.modules.compress.lzf.BufferRecycler;
import net.csdn.modules.compress.lzf.LZFDecoder;

public class LZFInputStream
extends InputStream {
    private final BufferRecycler _recycler = BufferRecycler.instance();
    protected final InputStream inputStream;
    protected boolean cfgFullReads = false;
    private byte[] _inputBuffer;
    private byte[] _decodedBytes;
    private int bufferPosition = 0;
    private int bufferLength = 0;

    public LZFInputStream(InputStream inputStream) throws IOException {
        this(inputStream, false);
    }

    public LZFInputStream(InputStream in, boolean fullReads) throws IOException {
        this.inputStream = in;
        this.cfgFullReads = fullReads;
        this._inputBuffer = this._recycler.allocInputBuffer(65535);
        this._decodedBytes = this._recycler.allocDecodeBuffer(65535);
    }

    public int read() throws IOException {
        this.readyBuffer();
        if (this.bufferPosition < this.bufferLength) {
            return this._decodedBytes[this.bufferPosition++] & 0xFF;
        }
        return -1;
    }

    public int read(byte[] buffer) throws IOException {
        return this.read(buffer, 0, buffer.length);
    }

    public int read(byte[] buffer, int offset, int length) throws IOException {
        if (length < 1) {
            return 0;
        }
        this.readyBuffer();
        if (this.bufferLength < 0) {
            return -1;
        }
        int chunkLength = Math.min(this.bufferLength - this.bufferPosition, length);
        System.arraycopy(this._decodedBytes, this.bufferPosition, buffer, offset, chunkLength);
        this.bufferPosition += chunkLength;
        if (chunkLength == length || !this.cfgFullReads) {
            return chunkLength;
        }
        int totalRead = chunkLength;
        do {
            offset += chunkLength;
            this.readyBuffer();
            if (this.bufferLength == -1) break;
            chunkLength = Math.min(this.bufferLength - this.bufferPosition, length - totalRead);
            System.arraycopy(this._decodedBytes, this.bufferPosition, buffer, offset, chunkLength);
            this.bufferPosition += chunkLength;
        } while ((totalRead += chunkLength) < length);
        return totalRead;
    }

    public void close() throws IOException {
        this.bufferLength = 0;
        this.bufferPosition = 0;
        byte[] buf = this._inputBuffer;
        if (buf != null) {
            this._inputBuffer = null;
            this._recycler.releaseInputBuffer(buf);
        }
        if ((buf = this._decodedBytes) != null) {
            this._decodedBytes = null;
            this._recycler.releaseDecodeBuffer(buf);
        }
        this.inputStream.close();
    }

    private final void readyBuffer() throws IOException {
        if (this.bufferPosition >= this.bufferLength) {
            this.bufferLength = LZFDecoder.decompressChunk(this.inputStream, this._inputBuffer, this._decodedBytes);
            this.bufferPosition = 0;
        }
    }
}

