/*
 * Decompiled with CFR 0.152.
 */
package net.csdn.modules.cache;

import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.csdn.common.exception.SettingsException;
import net.csdn.common.settings.Settings;
import net.csdn.modules.compress.gzip.GZip;
import org.apache.commons.pool.impl.GenericObjectPool;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPoolConfig;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RedisClient {
    private JedisPool pool;

    @Inject
    public RedisClient(Settings settings) {
        try {
            this.pool = new JedisPool((GenericObjectPool.Config)new JedisPoolConfig(), settings.get("redis.host"), settings.getAsInt("redis.port", Integer.valueOf(6379)).intValue());
        }
        catch (SettingsException settingsException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void operate(Callback callback) {
        Jedis jedis = this.borrow();
        try {
            callback.execute(jedis);
        }
        finally {
            this.revert(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String get(String key) {
        Jedis jedis = this.borrow();
        try {
            String string = jedis.get(key);
            return string;
        }
        finally {
            this.revert(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String bGet(String key) {
        Jedis jedis = this.borrow();
        try {
            byte[] value = jedis.get(key.getBytes());
            if (value != null) {
                String string = GZip.decodeWithGZip(value);
                return string;
            }
            String string = null;
            return string;
        }
        finally {
            this.revert(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String set(String key, String value) {
        Jedis jedis = this.borrow();
        try {
            String string = jedis.set(key, value);
            return string;
        }
        finally {
            this.revert(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void del(String key) {
        Jedis jedis = this.borrow();
        try {
            jedis.del(key);
        }
        finally {
            this.revert(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String bSet(String key, String value) {
        Jedis jedis = this.borrow();
        try {
            String string = jedis.set(key.getBytes(), GZip.encodeWithGZip(value));
            return string;
        }
        finally {
            this.revert(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean exits(String key) {
        Jedis jedis = this.borrow();
        try {
            boolean bl = jedis.exists(key);
            return bl;
        }
        finally {
            this.revert(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> mget(String[] keys) {
        Jedis jedis = this.borrow();
        try {
            List list = jedis.mget(keys);
            return list;
        }
        finally {
            this.revert(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String info() {
        Jedis jedis = this.borrow();
        try {
            String string = jedis.info();
            return string;
        }
        finally {
            this.revert(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> bMget(String[] keys) {
        Jedis jedis = this.borrow();
        int len = keys.length;
        byte[][] bkeys = new byte[len][];
        for (int i = 0; i < keys.length; ++i) {
            bkeys[i] = keys[i].getBytes();
        }
        try {
            List list = jedis.mget((byte[][])bkeys);
            ArrayList<String> temp_list = new ArrayList<String>(list.size());
            for (byte[] temp : list) {
                temp_list.add(GZip.decodeWithGZip(temp));
            }
            ArrayList<String> arrayList = temp_list;
            return arrayList;
        }
        finally {
            this.revert(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> sCopy(String key, String new_key) {
        Jedis jedis = this.borrow();
        try {
            Set oldSets = jedis.smembers(key);
            for (String str : oldSets) {
                jedis.sadd(new_key, new String[]{str});
            }
            Set set = oldSets;
            return set;
        }
        finally {
            this.revert(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sClear(String key, String oldKey) {
        Jedis jedis = this.borrow();
        try {
            Set oldSets = jedis.smembers(key);
            for (String str : oldSets) {
                jedis.del(oldKey + ":" + str);
            }
            jedis.del(key);
        }
        finally {
            this.revert(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> sMove(String key, String new_key) {
        Jedis jedis = this.borrow();
        try {
            Set oldSets = jedis.smembers(key);
            for (String str : oldSets) {
                jedis.smove(key, new_key, str);
            }
            Set set = oldSets;
            return set;
        }
        finally {
            this.revert(jedis);
        }
    }

    public void destory() {
        this.pool.destroy();
    }

    public Jedis borrow() {
        return (Jedis)this.pool.getResource();
    }

    public void revert(Jedis jedis) {
        this.pool.returnResource((Object)jedis);
    }

    public static interface Callback {
        public void execute(Jedis var1);
    }
}

