/*
 * Decompiled with CFR 0.152.
 */
package net.csdn.junit;

import com.google.inject.Injector;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import javassist.CtClass;
import net.csdn.ServiceFramwork;
import net.csdn.jpa.JPA;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IocTest {
    protected static Injector injector = ServiceFramwork.injector;

    public static boolean checkClassLoaded(String name) throws Exception {
        Method m = ClassLoader.class.getDeclaredMethod("findLoadedClass", String.class);
        m.setAccessible(true);
        ClassLoader cl = ClassLoader.getSystemClassLoader();
        Object test1 = m.invoke((Object)cl, name);
        return test1 != null;
    }

    public static void initEnv(Class classLoader) {
        try {
            ServiceFramwork.mode = ServiceFramwork.Mode.test;
            ServiceFramwork.scanService.setLoader(classLoader);
            CtClass ctClass = ServiceFramwork.classPool.get("net.csdn.bootstrap.Bootstrap");
            if (IocTest.checkClassLoaded(ctClass.getName())) {
                return;
            }
            Method method = ctClass.toClass().getDeclaredMethod("configureSystem", new Class[0]);
            method.setAccessible(true);
            method.invoke(null, new Object[0]);
            injector = ServiceFramwork.injector;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void dbCommit() {
        JPA.getJPAConfig().getJPAContext().closeTx(false);
    }

    public void commitTransaction() {
        this.dbCommit();
    }

    protected void mockService(Object targetObj, String fieldName, Object fieldValue) {
        try {
            Field field = targetObj.getClass().getDeclaredField(fieldName);
            field.setAccessible(true);
            field.set(targetObj, fieldValue);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public <T> T findController(Class<T> clzz) {
        return (T)injector.getInstance(clzz);
    }

    public <T> T findService(Class<T> clzz) {
        return (T)injector.getInstance(clzz);
    }

    protected void mockService(Object targetObj, Class<?> fieldClass, Object fieldValue) {
        try {
            Field[] fields;
            for (Field field : fields = targetObj.getClass().getDeclaredFields()) {
                Class<?> temp = field.getType();
                if (temp != fieldClass && !fieldClass.isAssignableFrom(temp)) continue;
                field.setAccessible(true);
                field.set(targetObj, fieldValue);
                return;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

